/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMElementWriter {
    private static String lSep = System.getProperty("line.separator");
    private StringBuffer sb = new StringBuffer();
    protected String[] knownEntities = new String[]{"gt", "amp", "lt", "apos", "quot"};

    public String encode(String string) {
        this.sb.setLength(0);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '<': {
                    this.sb.append("&lt;");
                    break;
                }
                case '>': {
                    this.sb.append("&gt;");
                    break;
                }
                case '\'': {
                    this.sb.append("&apos;");
                    break;
                }
                case '\"': {
                    this.sb.append("&quot;");
                    break;
                }
                case '&': {
                    int n2 = string.indexOf(";", n);
                    if (n2 < 0 || !this.isReference(string.substring(n, n2 + 1))) {
                        this.sb.append("&amp;");
                        break;
                    }
                    this.sb.append('&');
                    break;
                }
                default: {
                    this.sb.append(c);
                    break;
                }
            }
            ++n;
        }
        return this.sb.toString();
    }

    public boolean isReference(String string) {
        if (string.charAt(0) != '&' || !string.endsWith(";")) {
            return false;
        }
        if (string.charAt(1) == '#') {
            if (string.charAt(2) == 'x') {
                try {
                    Integer.parseInt(string.substring(3, string.length() - 1), 16);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            try {
                Integer.parseInt(string.substring(2, string.length() - 1));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        String string2 = string.substring(1, string.length() - 1);
        int n = 0;
        while (n < this.knownEntities.length) {
            if (string2.equals(this.knownEntities[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void write(Element element, Writer writer, int n, String string) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            writer.write(string);
            ++n2;
        }
        writer.write("<");
        writer.write(element.getTagName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n3 = 0;
        while (n3 < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n3);
            writer.write(" ");
            writer.write(attr.getName());
            writer.write("=\"");
            writer.write(this.encode(attr.getValue()));
            writer.write("\"");
            ++n3;
        }
        writer.write(">");
        boolean bl = false;
        NodeList nodeList = element.getChildNodes();
        int n4 = 0;
        while (n4 < nodeList.getLength()) {
            Node node = nodeList.item(n4);
            switch (node.getNodeType()) {
                case 1: {
                    if (!bl) {
                        writer.write(lSep);
                        bl = true;
                    }
                    this.write((Element)node, writer, n + 1, string);
                    break;
                }
                case 3: {
                    writer.write(this.encode(node.getNodeValue()));
                    break;
                }
                case 4: {
                    writer.write("<![CDATA[");
                    writer.write(((Text)node).getData());
                    writer.write("]]>");
                    break;
                }
                case 5: {
                    writer.write(38);
                    writer.write(node.getNodeName());
                    writer.write(59);
                    break;
                }
                case 7: {
                    writer.write("<?");
                    writer.write(node.getNodeName());
                    String string2 = node.getNodeValue();
                    if (string2 != null && string2.length() > 0) {
                        writer.write(32);
                        writer.write(string2);
                    }
                    writer.write("?>");
                    break;
                }
            }
            ++n4;
        }
        if (bl) {
            int n5 = 0;
            while (n5 < n) {
                writer.write(string);
                ++n5;
            }
        }
        writer.write("</");
        writer.write(element.getTagName());
        writer.write(">");
        writer.write(lSep);
        writer.flush();
    }
}

