/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.ZipException;
import org.apache.tools.zip.ExtraFieldUtils;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipShort;

public class ZipEntry
extends java.util.zip.ZipEntry {
    private int internalAttributes = 0;
    private long externalAttributes = 0L;
    private Vector extraFields = new Vector();
    private Long compressedSize = null;
    private static Method setCompressedSizeMethod = null;
    private static Object lockReflection = new Object();
    private static boolean triedToGetMethod = false;
    static /* synthetic */ Class class$java$util$zip$ZipEntry;

    public ZipEntry(String string) {
        super(string);
    }

    public ZipEntry(java.util.zip.ZipEntry zipEntry) throws ZipException {
        super(zipEntry.getName());
        byte[] byArray;
        long l;
        long l2;
        this.setComment(zipEntry.getComment());
        this.setMethod(zipEntry.getMethod());
        this.setTime(zipEntry.getTime());
        long l3 = zipEntry.getSize();
        if (l3 > 0L) {
            this.setSize(l3);
        }
        if ((l2 = zipEntry.getCompressedSize()) > 0L) {
            this.setComprSize(l2);
        }
        if ((l = zipEntry.getCrc()) > 0L) {
            this.setCrc(l);
        }
        if ((byArray = zipEntry.getExtra()) != null) {
            this.setExtraFields(ExtraFieldUtils.parse(byArray));
        } else {
            this.setExtra();
        }
    }

    public ZipEntry(ZipEntry zipEntry) throws ZipException {
        this((java.util.zip.ZipEntry)zipEntry);
        this.setInternalAttributes(zipEntry.getInternalAttributes());
        this.setExternalAttributes(zipEntry.getExternalAttributes());
        this.setExtraFields(zipEntry.getExtraFields());
    }

    public void addExtraField(ZipExtraField zipExtraField) {
        ZipShort zipShort = zipExtraField.getHeaderId();
        boolean bl = false;
        int n = 0;
        while (!bl && n < this.extraFields.size()) {
            if (((ZipExtraField)this.extraFields.elementAt(n)).getHeaderId().equals(zipShort)) {
                this.extraFields.setElementAt(zipExtraField, n);
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            this.extraFields.addElement(zipExtraField);
        }
        this.setExtra();
    }

    private static void checkSCS() {
        if (!triedToGetMethod) {
            Object object = lockReflection;
            synchronized (object) {
                triedToGetMethod = true;
                try {
                    setCompressedSizeMethod = (class$java$util$zip$ZipEntry != null ? class$java$util$zip$ZipEntry : (class$java$util$zip$ZipEntry = ZipEntry.class$("java.util.zip.ZipEntry"))).getMethod("setCompressedSize", Long.TYPE);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object clone() {
        ZipEntry zipEntry = null;
        try {
            zipEntry = new ZipEntry((java.util.zip.ZipEntry)super.clone());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        zipEntry.setInternalAttributes(this.getInternalAttributes());
        zipEntry.setExternalAttributes(this.getExternalAttributes());
        zipEntry.setExtraFields(this.getExtraFields());
        return zipEntry;
    }

    public byte[] getCentralDirectoryExtra() {
        return ExtraFieldUtils.mergeCentralDirectoryData(this.getExtraFields());
    }

    public long getCompressedSize() {
        if (this.compressedSize != null) {
            return this.compressedSize;
        }
        return super.getCompressedSize();
    }

    public long getExternalAttributes() {
        return this.externalAttributes;
    }

    public ZipExtraField[] getExtraFields() {
        Object[] objectArray = new ZipExtraField[this.extraFields.size()];
        this.extraFields.copyInto(objectArray);
        return objectArray;
    }

    public int getInternalAttributes() {
        return this.internalAttributes;
    }

    public byte[] getLocalFileDataExtra() {
        byte[] byArray = this.getExtra();
        return byArray != null ? byArray : new byte[]{};
    }

    private static boolean haveSetCompressedSize() {
        ZipEntry.checkSCS();
        return setCompressedSizeMethod != null;
    }

    private static void performSetCompressedSize(ZipEntry zipEntry, long l) {
        Object[] objectArray = new Long[]{new Long(l)};
        try {
            setCompressedSizeMethod.invoke((Object)zipEntry, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw new RuntimeException("Exception setting the compressed size of " + zipEntry + ": " + throwable.getMessage());
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Exception setting the compressed size of " + zipEntry + ": " + throwable.getMessage());
        }
    }

    public void removeExtraField(ZipShort zipShort) {
        boolean bl = false;
        int n = 0;
        while (!bl && n < this.extraFields.size()) {
            if (((ZipExtraField)this.extraFields.elementAt(n)).getHeaderId().equals(zipShort)) {
                this.extraFields.removeElementAt(n);
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            throw new NoSuchElementException();
        }
        this.setExtra();
    }

    public void setComprSize(long l) {
        if (ZipEntry.haveSetCompressedSize()) {
            ZipEntry.performSetCompressedSize(this, l);
        } else {
            this.compressedSize = new Long(l);
        }
    }

    public void setExternalAttributes(long l) {
        this.externalAttributes = l;
    }

    protected void setExtra() {
        super.setExtra(ExtraFieldUtils.mergeLocalFileDataData(this.getExtraFields()));
    }

    public void setExtra(byte[] byArray) throws RuntimeException {
        try {
            this.setExtraFields(ExtraFieldUtils.parse(byArray));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void setExtraFields(ZipExtraField[] zipExtraFieldArray) {
        this.extraFields.removeAllElements();
        int n = 0;
        while (n < zipExtraFieldArray.length) {
            this.extraFields.addElement(zipExtraFieldArray[n]);
            ++n;
        }
        this.setExtra();
    }

    public void setInternalAttributes(int n) {
        this.internalAttributes = n;
    }
}

