/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;

public class Rpm
extends Task {
    private String specFile;
    private File topDir;
    private String command = "-bb";
    private boolean cleanBuildDir = false;
    private boolean removeSpec = false;
    private boolean removeSource = false;
    private File output;
    private File error;

    public void execute() throws BuildException {
        Object errorstream;
        block28: {
            Commandline toExecute = new Commandline();
            toExecute.setExecutable("rpm");
            if (this.topDir != null) {
                toExecute.createArgument().setValue("--define");
                toExecute.createArgument().setValue("_topdir" + this.topDir);
            }
            toExecute.createArgument().setLine(this.command);
            if (this.cleanBuildDir) {
                toExecute.createArgument().setValue("--clean");
            }
            if (this.removeSpec) {
                toExecute.createArgument().setValue("--rmspec");
            }
            if (this.removeSource) {
                toExecute.createArgument().setValue("--rmsource");
            }
            toExecute.createArgument().setValue("SPECS/" + this.specFile);
            LogStreamHandler streamhandler = null;
            Object outputstream = null;
            errorstream = null;
            if (this.error == null && this.output == null) {
                streamhandler = new LogStreamHandler((Task)this, 2, 1);
            } else {
                if (this.output != null) {
                    try {
                        outputstream = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.output)));
                    }
                    catch (IOException e) {
                        throw new BuildException((Throwable)e, this.location);
                    }
                } else {
                    outputstream = new LogOutputStream((Task)this, 2);
                }
                if (this.error != null) {
                    try {
                        errorstream = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.error)));
                    }
                    catch (IOException e) {
                        throw new BuildException((Throwable)e, this.location);
                    }
                } else {
                    errorstream = new LogOutputStream((Task)this, 1);
                }
                streamhandler = new PumpStreamHandler((OutputStream)outputstream, (OutputStream)errorstream);
            }
            Execute exe = new Execute((ExecuteStreamHandler)streamhandler, null);
            exe.setAntRun(((ProjectComponent)this).project);
            if (this.topDir == null) {
                this.topDir = ((ProjectComponent)this).project.getBaseDir();
            }
            exe.setWorkingDirectory(this.topDir);
            exe.setCommandline(toExecute.getCommandline());
            try {
                try {
                    exe.execute();
                    this.log("Building the RPM based on the " + this.specFile + " file");
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e, this.location);
                }
                Object var7_9 = null;
                if (this.output == null) break block28;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (this.output != null) {
                    try {
                        ((OutputStream)outputstream).close();
                    }
                    catch (IOException iOException) {}
                }
                if (this.error != null) {
                    try {
                        ((OutputStream)errorstream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((OutputStream)outputstream).close();
            }
            catch (IOException iOException) {}
        }
        if (this.error != null) {
            try {
                ((OutputStream)errorstream).close();
            }
            catch (IOException iOException) {}
        }
    }

    public void setCleanBuildDir(boolean cbd) {
        this.cleanBuildDir = cbd;
    }

    public void setCommand(String c) {
        this.command = c;
    }

    public void setError(File error) {
        this.error = error;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setRemoveSource(boolean rs) {
        this.removeSource = rs;
    }

    public void setRemoveSpec(boolean rs) {
        this.removeSpec = rs;
    }

    public void setSpecFile(String sf) {
        if (sf == null || sf.trim().equals("")) {
            throw new BuildException("You must specify a spec file", this.location);
        }
        this.specFile = sf;
    }

    public void setTopDir(File td) {
        this.topDir = td;
    }
}

