/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ccm;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.ccm.Continuus;
import org.apache.tools.ant.types.Commandline;

public class CCMReconfigure
extends Continuus {
    private String project = null;
    private boolean recurse = false;
    private boolean verbose = false;
    public static final String FLAG_RECURSE = "/recurse";
    public static final String FLAG_VERBOSE = "/verbose";
    public static final String FLAG_PROJECT = "/project";

    public CCMReconfigure() {
        this.setCcmAction("reconfigure");
    }

    private void checkOptions(Commandline cmd) {
        if (this.isRecurse()) {
            cmd.createArgument().setValue(FLAG_RECURSE);
        }
        if (this.isVerbose()) {
            cmd.createArgument().setValue(FLAG_VERBOSE);
        }
        if (this.getCcmProject() != null) {
            cmd.createArgument().setValue(FLAG_PROJECT);
            cmd.createArgument().setValue(this.getCcmProject());
        }
    }

    public void execute() throws BuildException {
        Commandline commandLine = new Commandline();
        Project aProj = this.getProject();
        int result = 0;
        commandLine.setExecutable(this.getCcmCommand());
        commandLine.createArgument().setValue(this.getCcmAction());
        this.checkOptions(commandLine);
        result = this.run(commandLine);
        if (result != 0) {
            String msg = "Failed executing: " + commandLine.toString();
            throw new BuildException(msg, this.location);
        }
    }

    public String getCcmProject() {
        return this.project;
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setCcmProject(String v) {
        this.project = v;
    }

    public void setRecurse(boolean v) {
        this.recurse = v;
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
    }
}

