/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.depend;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFile;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFileUtils;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Depend
extends MatchingTask {
    private Path srcPath;
    private Path destPath;
    private File cache;
    private Hashtable affectedClassMap;
    private Hashtable classFileInfoMap;
    private Hashtable classpathDependencies;
    private Hashtable outOfDateClasses;
    private boolean closure = false;
    private boolean dump = false;
    private Path dependClasspath;
    private static final String CACHE_FILE_NAME = "dependencies.txt";
    private static final String CLASSNAME_PREPEND = "||:";

    private void addClassFiles(Vector classFileList, File dir, File root) {
        String[] filesInDir = dir.list();
        if (filesInDir != null) {
            int length = filesInDir.length;
            int i = 0;
            while (i < length) {
                File file = new File(dir, filesInDir[i]);
                if (file.isDirectory()) {
                    this.addClassFiles(classFileList, file, root);
                } else if (file.getName().endsWith(".class")) {
                    ClassFileInfo info = new ClassFileInfo();
                    info.absoluteFile = file;
                    info.relativeName = file.getPath().substring(root.getPath().length() + 1, file.getPath().length() - 6);
                    info.className = ClassFileUtils.convertSlashName(info.relativeName);
                    classFileList.addElement(info);
                }
                ++i;
            }
        }
    }

    public Path createClasspath() {
        if (this.dependClasspath == null) {
            this.dependClasspath = new Path(((ProjectComponent)this).project);
        }
        return this.dependClasspath.createPath();
    }

    private int deleteAffectedFiles(String className) {
        int count = 0;
        Hashtable affectedClasses = (Hashtable)this.affectedClassMap.get(className);
        if (affectedClasses != null) {
            Enumeration e = affectedClasses.keys();
            while (e.hasMoreElements()) {
                String affectedClassName = (String)e.nextElement();
                ClassFileInfo affectedClassInfo = (ClassFileInfo)affectedClasses.get(affectedClassName);
                if (!affectedClassInfo.absoluteFile.exists()) continue;
                this.log("Deleting file " + affectedClassInfo.absoluteFile.getPath() + " since " + className + " out of date", 3);
                affectedClassInfo.absoluteFile.delete();
                ++count;
                if (this.closure) {
                    count += this.deleteAffectedFiles(affectedClassName);
                    continue;
                }
                if (affectedClassName.indexOf("$") == -1) continue;
                String topLevelClassName = affectedClassName.substring(0, affectedClassName.indexOf("$"));
                this.log("Top level class = " + topLevelClassName, 3);
                ClassFileInfo topLevelClassInfo = (ClassFileInfo)this.classFileInfoMap.get(topLevelClassName);
                if (topLevelClassInfo == null || !topLevelClassInfo.absoluteFile.exists()) continue;
                this.log("Deleting file " + topLevelClassInfo.absoluteFile.getPath() + " since " + "one of its inner classes was removed", 3);
                topLevelClassInfo.absoluteFile.delete();
                ++count;
                if (!this.closure) continue;
                count += this.deleteAffectedFiles(topLevelClassName);
            }
        }
        return count;
    }

    private int deleteAllAffectedFiles() {
        int count = 0;
        Enumeration e = this.outOfDateClasses.elements();
        while (e.hasMoreElements()) {
            String className = (String)e.nextElement();
            count += this.deleteAffectedFiles(className);
            ClassFileInfo classInfo = (ClassFileInfo)this.classFileInfoMap.get(className);
            if (classInfo == null || !classInfo.absoluteFile.exists()) continue;
            classInfo.absoluteFile.delete();
            ++count;
        }
        return count;
    }

    private void determineDependencies() throws IOException {
        this.affectedClassMap = new Hashtable();
        this.classFileInfoMap = new Hashtable();
        boolean cacheDirty = false;
        Hashtable dependencyMap = new Hashtable();
        File depCacheFile = null;
        boolean depCacheFileExists = true;
        long depCacheFileLastModified = Long.MAX_VALUE;
        if (this.cache != null) {
            dependencyMap = this.readCachedDependencies();
            depCacheFile = new File(this.cache, CACHE_FILE_NAME);
            depCacheFileExists = depCacheFile.exists();
            depCacheFileLastModified = depCacheFile.lastModified();
        }
        Enumeration e = this.getClassFiles(this.destPath).elements();
        while (e.hasMoreElements()) {
            ClassFileInfo info = (ClassFileInfo)e.nextElement();
            this.log("Adding class info for " + info.className, 4);
            this.classFileInfoMap.put(info.className, info);
            Vector dependencyList = null;
            if (this.cache != null && depCacheFileExists && depCacheFileLastModified > info.absoluteFile.lastModified()) {
                dependencyList = (Vector)dependencyMap.get(info.className);
            }
            if (dependencyList == null) {
                Object var12_12;
                FileInputStream inFileStream;
                block20: {
                    inFileStream = null;
                    try {
                        inFileStream = new FileInputStream(info.absoluteFile);
                        ClassFile classFile = new ClassFile();
                        classFile.read(inFileStream);
                        dependencyList = classFile.getClassRefs();
                        if (dependencyList == null) break block20;
                        cacheDirty = true;
                        dependencyMap.put(info.className, dependencyList);
                    }
                    catch (Throwable throwable) {
                        var12_12 = null;
                        if (inFileStream != null) {
                            inFileStream.close();
                        }
                        throw throwable;
                    }
                }
                var12_12 = null;
                if (inFileStream != null) {
                    inFileStream.close();
                }
            }
            Enumeration depEnum = dependencyList.elements();
            while (depEnum.hasMoreElements()) {
                String dependentClass = (String)depEnum.nextElement();
                Hashtable<String, ClassFileInfo> affectedClasses = (Hashtable<String, ClassFileInfo>)this.affectedClassMap.get(dependentClass);
                if (affectedClasses == null) {
                    affectedClasses = new Hashtable<String, ClassFileInfo>();
                    this.affectedClassMap.put(dependentClass, affectedClasses);
                }
                affectedClasses.put(info.className, info);
            }
        }
        this.classpathDependencies = null;
        if (this.dependClasspath != null) {
            this.classpathDependencies = new Hashtable();
            AntClassLoader loader = new AntClassLoader(this.getProject(), this.dependClasspath);
            Hashtable classpathFileCache = new Hashtable();
            Object nullFileMarker = new Object();
            Enumeration e2 = dependencyMap.keys();
            while (e2.hasMoreElements()) {
                String className = (String)e2.nextElement();
                Vector dependencyList = (Vector)dependencyMap.get(className);
                Hashtable<File, File> dependencies = new Hashtable<File, File>();
                this.classpathDependencies.put(className, dependencies);
                Enumeration e22 = dependencyList.elements();
                while (e22.hasMoreElements()) {
                    String dependency = (String)e22.nextElement();
                    Object classpathFileObject = classpathFileCache.get(dependency);
                    if (classpathFileObject == null) {
                        URL classURL;
                        classpathFileObject = nullFileMarker;
                        if (!dependency.startsWith("java.") && !dependency.startsWith("javax.") && (classURL = loader.getResource(String.valueOf(dependency.replace('.', '/')) + ".class")) != null) {
                            if (classURL.getProtocol().equals("jar")) {
                                String jarFilePath = classURL.getFile();
                                if (jarFilePath.startsWith("file:")) {
                                    int classMarker = jarFilePath.indexOf(33);
                                    jarFilePath = jarFilePath.substring(5, classMarker);
                                }
                                classpathFileObject = new File(jarFilePath);
                            } else if (classURL.getProtocol().equals("file")) {
                                String classFilePath = classURL.getFile();
                                classpathFileObject = new File(classFilePath);
                            }
                            this.log("Class " + className + " depends on " + classpathFileObject + " due to " + dependency, 4);
                        }
                        classpathFileCache.put(dependency, classpathFileObject);
                    }
                    if (classpathFileObject == null || classpathFileObject == nullFileMarker) continue;
                    File jarFile = (File)classpathFileObject;
                    dependencies.put(jarFile, jarFile);
                }
            }
        }
        if (this.cache != null && cacheDirty) {
            this.writeCachedDependencies(dependencyMap);
        }
    }

    public void execute() throws BuildException {
        try {
            String className;
            Enumeration e;
            long start = System.currentTimeMillis();
            String[] srcPathList = this.srcPath.list();
            if (srcPathList.length == 0) {
                throw new BuildException("srcdir attribute must be set!", ((Task)this).location);
            }
            if (this.destPath == null) {
                this.destPath = this.srcPath;
            }
            if (this.cache != null && this.cache.exists() && !this.cache.isDirectory()) {
                throw new BuildException("The cache, if specified, must point to a directory");
            }
            if (this.cache != null && !this.cache.exists()) {
                this.cache.mkdirs();
            }
            this.determineDependencies();
            if (this.dump) {
                this.log("Reverse Dependency Dump for " + this.affectedClassMap.size() + " classes:", 4);
                Enumeration e2 = this.affectedClassMap.keys();
                while (e2.hasMoreElements()) {
                    String className2 = (String)e2.nextElement();
                    this.log(" Class " + className2 + " affects:", 4);
                    Hashtable affectedClasses = (Hashtable)this.affectedClassMap.get(className2);
                    Enumeration e22 = affectedClasses.keys();
                    while (e22.hasMoreElements()) {
                        String affectedClass = (String)e22.nextElement();
                        ClassFileInfo info = (ClassFileInfo)affectedClasses.get(affectedClass);
                        this.log("    " + affectedClass + " in " + info.absoluteFile.getPath(), 4);
                    }
                }
                if (this.classpathDependencies != null) {
                    this.log("Classpath file dependencies (Forward):", 4);
                    e = this.classpathDependencies.keys();
                    while (e.hasMoreElements()) {
                        className = (String)e.nextElement();
                        this.log(" Class " + className + " depends on:", 4);
                        Hashtable dependencies = (Hashtable)this.classpathDependencies.get(className);
                        Enumeration e23 = dependencies.elements();
                        while (e23.hasMoreElements()) {
                            File classpathFile = (File)e23.nextElement();
                            this.log("    " + classpathFile.getPath(), 4);
                        }
                    }
                }
            }
            this.outOfDateClasses = new Hashtable();
            int i = 0;
            while (i < srcPathList.length) {
                File srcDir = ((ProjectComponent)this).project.resolveFile(srcPathList[i]);
                if (srcDir.exists()) {
                    DirectoryScanner ds = this.getDirectoryScanner(srcDir);
                    String[] files = ds.getIncludedFiles();
                    this.scanDir(srcDir, files);
                }
                ++i;
            }
            if (this.classpathDependencies != null) {
                e = this.classpathDependencies.keys();
                block7: while (e.hasMoreElements()) {
                    ClassFileInfo info;
                    className = (String)e.nextElement();
                    if (this.outOfDateClasses.containsKey(className) || (info = (ClassFileInfo)this.classFileInfoMap.get(className)) == null) continue;
                    Hashtable dependencies = (Hashtable)this.classpathDependencies.get(className);
                    Enumeration e2 = dependencies.elements();
                    while (e2.hasMoreElements()) {
                        File classpathFile = (File)e2.nextElement();
                        if (classpathFile.lastModified() <= info.absoluteFile.lastModified()) continue;
                        this.log("Class " + className + " is out of date with respect to " + classpathFile, 4);
                        this.outOfDateClasses.put(className, className);
                        continue block7;
                    }
                }
            }
            int count = this.deleteAllAffectedFiles();
            long duration = (System.currentTimeMillis() - start) / 1000L;
            this.log("Deleted " + count + " out of date files in " + duration + " seconds");
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private Vector getClassFiles(Path classLocations) {
        String[] classLocationsList = classLocations.list();
        Vector classFileList = new Vector();
        int i = 0;
        while (i < classLocationsList.length) {
            File dir = new File(classLocationsList[i]);
            if (dir.isDirectory()) {
                this.addClassFiles(classFileList, dir, dir);
            }
            ++i;
        }
        return classFileList;
    }

    public Path getClasspath() {
        return this.dependClasspath;
    }

    private Hashtable readCachedDependencies() throws IOException {
        Hashtable dependencyMap = new Hashtable();
        if (this.cache != null) {
            File depFile = new File(this.cache, CACHE_FILE_NAME);
            BufferedReader in = null;
            if (depFile.exists()) {
                try {
                    in = new BufferedReader(new FileReader(depFile));
                    String line = null;
                    Vector<String> dependencyList = null;
                    String className = null;
                    int prependLength = CLASSNAME_PREPEND.length();
                    while ((line = in.readLine()) != null) {
                        if (line.startsWith(CLASSNAME_PREPEND)) {
                            dependencyList = new Vector<String>();
                            className = line.substring(prependLength);
                            dependencyMap.put(className, dependencyList);
                            continue;
                        }
                        dependencyList.addElement(line);
                    }
                }
                finally {
                    Object var5_8 = null;
                    if (in != null) {
                        in.close();
                    }
                }
            }
        }
        return dependencyMap;
    }

    protected void scanDir(File srcDir, String[] files) {
        long now = System.currentTimeMillis();
        int i = 0;
        while (i < files.length) {
            File srcFile = new File(srcDir, files[i]);
            if (files[i].endsWith(".java")) {
                String filePath = srcFile.getPath();
                String className = filePath.substring(srcDir.getPath().length() + 1, filePath.length() - ".java".length());
                ClassFileInfo info = (ClassFileInfo)this.classFileInfoMap.get(className = ClassFileUtils.convertSlashName(className));
                if (info == null) {
                    this.outOfDateClasses.put(className, className);
                } else if (srcFile.lastModified() > info.absoluteFile.lastModified()) {
                    this.outOfDateClasses.put(className, className);
                }
            }
            ++i;
        }
    }

    public void setCache(File cache) {
        this.cache = cache;
    }

    public void setClasspath(Path classpath) {
        if (this.dependClasspath == null) {
            this.dependClasspath = classpath;
        } else {
            this.dependClasspath.append(classpath);
        }
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setClosure(boolean closure) {
        this.closure = closure;
    }

    public void setDestDir(Path destPath) {
        this.destPath = destPath;
    }

    public void setDump(boolean dump) {
        this.dump = dump;
    }

    public void setSrcdir(Path srcPath) {
        this.srcPath = srcPath;
    }

    private void writeCachedDependencies(Hashtable dependencyMap) throws IOException {
        if (this.cache != null) {
            PrintWriter pw = null;
            try {
                this.cache.mkdirs();
                File depFile = new File(this.cache, CACHE_FILE_NAME);
                pw = new PrintWriter(new FileWriter(depFile));
                Enumeration deps = dependencyMap.keys();
                while (deps.hasMoreElements()) {
                    String className = (String)deps.nextElement();
                    pw.println(CLASSNAME_PREPEND + className);
                    Vector dependencyList = (Vector)dependencyMap.get(className);
                    int size = dependencyList.size();
                    int x = 0;
                    while (x < size) {
                        pw.println(dependencyList.elementAt(x));
                        ++x;
                    }
                }
            }
            finally {
                Object var4_9 = null;
                if (pw != null) {
                    pw.close();
                }
            }
        }
    }

    private static class ClassFileInfo {
        public File absoluteFile;
        public String relativeName;
        public String className;

        ClassFileInfo() {
        }
    }
}

