/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.metamata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.optional.metamata.AbstractMetamataTask;
import org.apache.tools.ant.taskdefs.optional.metamata.MMetricsStreamHandler;
import org.apache.tools.ant.types.Path;

public class MMetrics
extends AbstractMetamataTask {
    protected String granularity = null;
    protected File outFile = null;
    protected File tmpFile = AbstractMetamataTask.createTmpFile();
    protected Path path = null;

    public MMetrics() {
        super("com.metamata.sc.MMetrics");
    }

    protected void checkOptions() throws BuildException {
        super.checkOptions();
        if (!("files".equals(this.granularity) || "methods".equals(this.granularity) || "types".equals(this.granularity))) {
            throw new BuildException("Metrics reporting granularity is invalid. Must be one of 'files', 'methods', 'types'");
        }
        if (this.outFile == null) {
            throw new BuildException("Output XML file must be set via 'tofile' attribute.");
        }
        if (this.path == null && this.fileSets.size() == 0) {
            throw new BuildException("Must set either paths (path element) or files (fileset element)");
        }
        if (this.path != null && this.fileSets.size() > 0) {
            throw new BuildException("Cannot set paths (path element) and files (fileset element) at the same time");
        }
    }

    protected void cleanUp() throws BuildException {
        try {
            super.cleanUp();
        }
        finally {
            Object var2_1 = null;
            if (this.tmpFile != null) {
                this.tmpFile.delete();
                this.tmpFile = null;
            }
        }
    }

    public Path createPath() {
        if (this.path == null) {
            this.path = new Path(((ProjectComponent)this).project);
        }
        return this.path;
    }

    protected ExecuteStreamHandler createStreamHandler() {
        return new LogStreamHandler((Task)this, 2, 2);
    }

    protected void execute0(ExecuteStreamHandler handler) throws BuildException {
        super.execute0(handler);
        this.transformFile();
    }

    protected Vector getOptions() {
        Vector<String> options = new Vector<String>(512);
        if (this.sourcePath != null) {
            this.sourcePath.append(this.classPath);
            this.classPath = this.sourcePath;
            this.sourcePath = null;
        }
        if (this.classPath != null) {
            options.addElement("-classpath");
            options.addElement((String)this.classPath);
        }
        options.addElement("-output");
        options.addElement(this.tmpFile.toString());
        options.addElement("-" + this.granularity);
        options.addElement("-format");
        options.addElement("tab");
        options.addElement("-i");
        options.addElement("/");
        String[] dirs = this.path.list();
        int i = 0;
        while (i < dirs.length) {
            options.addElement(dirs[i]);
            ++i;
        }
        AbstractMetamataTask.addAllVector(options, this.includedFiles.keys());
        return options;
    }

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public void setTofile(File file) {
        this.outFile = file;
    }

    protected void transformFile() throws BuildException {
        FileInputStream tmpStream;
        block15: {
            tmpStream = null;
            try {
                tmpStream = new FileInputStream(this.tmpFile);
            }
            catch (IOException e) {
                throw new BuildException("Error reading temporary file: " + this.tmpFile, (Throwable)e);
            }
            FileOutputStream xmlStream = null;
            try {
                try {
                    xmlStream = new FileOutputStream(this.outFile);
                    MMetricsStreamHandler xmlHandler = new MMetricsStreamHandler(this, xmlStream);
                    xmlHandler.setProcessOutputStream(tmpStream);
                    xmlHandler.start();
                    xmlHandler.stop();
                }
                catch (IOException e) {
                    throw new BuildException("Error creating output file: " + this.outFile, (Throwable)e);
                }
                Object var4_6 = null;
                if (xmlStream == null) break block15;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                if (xmlStream != null) {
                    try {
                        xmlStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (tmpStream != null) {
                    try {
                        tmpStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                xmlStream.close();
            }
            catch (IOException iOException) {}
        }
        if (tmpStream != null) {
            try {
                tmpStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

