/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.vss;

import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;

public abstract class MSVSS
extends Task {
    private String m_SSDir = "";
    private String m_vssLogin = null;
    private String m_vssPath = null;
    private String m_serverPath = null;
    private static final String SS_EXE = "ss";
    public static final String PROJECT_PREFIX = "$";
    public static final String COMMAND_GET = "Get";
    public static final String COMMAND_CHECKOUT = "Checkout";
    public static final String COMMAND_CHECKIN = "Checkin";
    public static final String COMMAND_LABEL = "Label";
    public static final String COMMAND_HISTORY = "History";
    public static final String FLAG_LOGIN = "-Y";
    public static final String FLAG_OVERRIDE_WORKING_DIR = "-GL";
    public static final String FLAG_AUTORESPONSE_DEF = "-I-";
    public static final String FLAG_AUTORESPONSE_YES = "-I-Y";
    public static final String FLAG_AUTORESPONSE_NO = "-I-N";
    public static final String FLAG_RECURSION = "-R";
    public static final String FLAG_VERSION = "-V";
    public static final String FLAG_VERSION_DATE = "-Vd";
    public static final String FLAG_VERSION_LABEL = "-VL";
    public static final String FLAG_WRITABLE = "-W";
    public static final String VALUE_NO = "-N";
    public static final String VALUE_YES = "-Y";
    public static final String FLAG_QUIET = "-O-";

    public void getLoginCommand(Commandline cmd) {
        if (this.m_vssLogin == null) {
            return;
        }
        cmd.createArgument().setValue("-Y" + this.m_vssLogin);
    }

    public final String getSSCommand() {
        String toReturn = this.m_SSDir;
        if (!toReturn.equals("") && !toReturn.endsWith("\\")) {
            toReturn = String.valueOf(toReturn) + "\\";
        }
        toReturn = String.valueOf(toReturn) + SS_EXE;
        return toReturn;
    }

    public String getVsspath() {
        return this.m_vssPath;
    }

    protected int run(Commandline cmd) {
        try {
            Execute exe = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1));
            if (this.m_serverPath != null) {
                String[] env = exe.getEnvironment();
                if (env == null) {
                    env = new String[]{};
                }
                String[] newEnv = new String[env.length + 1];
                int i = 0;
                while (i < env.length) {
                    newEnv[i] = env[i];
                    ++i;
                }
                newEnv[env.length] = "SSDIR=" + this.m_serverPath;
                exe.setEnvironment(newEnv);
            }
            exe.setAntRun(((ProjectComponent)this).project);
            exe.setWorkingDirectory(((ProjectComponent)this).project.getBaseDir());
            exe.setCommandline(cmd.getCommandline());
            return exe.execute();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.location);
        }
    }

    public final void setLogin(String login) {
        this.m_vssLogin = login;
    }

    public final void setServerpath(String serverPath) {
        this.m_serverPath = serverPath;
    }

    public final void setSsdir(String dir) {
        this.m_SSDir = Project.translatePath((String)dir);
    }

    public final void setVsspath(String vssPath) {
        this.m_vssPath = vssPath.startsWith("vss://") ? PROJECT_PREFIX + vssPath.substring(5) : PROJECT_PREFIX + vssPath;
    }
}

