/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;

public class AntClassLoader
extends ClassLoader
implements BuildListener {
    private static final int BUFFER_SIZE = 8192;
    Vector pathComponents = new Vector();
    private Project project;
    private boolean parentFirst = true;
    private Vector systemPackages = new Vector();
    private Vector loaderPackages = new Vector();
    private boolean ignoreBase = false;
    private ClassLoader parent = null;
    private Hashtable zipFiles = new Hashtable();
    private ClassLoader savedContextLoader = null;
    private boolean isContextLoaderSaved = false;
    private static Method getProtectionDomain = null;
    private static Method defineClassProtectionDomain = null;
    private static Method getContextClassLoader = null;
    private static Method setContextClassLoader = null;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$org$apache$tools$ant$AntClassLoader;
    static /* synthetic */ Class class$org$apache$tools$ant$Project;

    static {
        try {
            getProtectionDomain = (class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = AntClassLoader.class$("java.lang.Class"))).getMethod("getProtectionDomain", new Class[0]);
            Class<?> clazz = Class.forName("java.security.ProtectionDomain");
            Class[] classArray = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = AntClassLoader.class$("java.lang.String")), array$B != null ? array$B : (array$B = AntClassLoader.class$("[B")), Integer.TYPE, Integer.TYPE, clazz};
            defineClassProtectionDomain = (class$java$lang$ClassLoader != null ? class$java$lang$ClassLoader : (class$java$lang$ClassLoader = AntClassLoader.class$("java.lang.ClassLoader"))).getDeclaredMethod("defineClass", classArray);
            getContextClassLoader = (class$java$lang$Thread != null ? class$java$lang$Thread : (class$java$lang$Thread = AntClassLoader.class$("java.lang.Thread"))).getMethod("getContextClassLoader", new Class[0]);
            classArray = new Class[]{class$java$lang$ClassLoader != null ? class$java$lang$ClassLoader : (class$java$lang$ClassLoader = AntClassLoader.class$("java.lang.ClassLoader"))};
            setContextClassLoader = (class$java$lang$Thread != null ? class$java$lang$Thread : (class$java$lang$Thread = AntClassLoader.class$("java.lang.Thread"))).getMethod("setContextClassLoader", classArray);
        }
        catch (Exception exception) {}
    }

    public AntClassLoader(ClassLoader classLoader, Project project, Path path, boolean bl) {
        this(project, path);
        if (classLoader != null) {
            this.parent = classLoader;
        }
        this.parentFirst = bl;
        this.addSystemPackageRoot("java");
        this.addSystemPackageRoot("javax");
    }

    public AntClassLoader(ClassLoader classLoader, boolean bl) {
        if (classLoader != null) {
            this.parent = classLoader;
        } else {
            classLoader = (class$org$apache$tools$ant$AntClassLoader != null ? class$org$apache$tools$ant$AntClassLoader : (class$org$apache$tools$ant$AntClassLoader = AntClassLoader.class$("org.apache.tools.ant.AntClassLoader"))).getClassLoader();
        }
        this.project = null;
        this.parentFirst = bl;
    }

    public AntClassLoader(Project project, Path path) {
        this.parent = (class$org$apache$tools$ant$AntClassLoader != null ? class$org$apache$tools$ant$AntClassLoader : (class$org$apache$tools$ant$AntClassLoader = AntClassLoader.class$("org.apache.tools.ant.AntClassLoader"))).getClassLoader();
        this.project = project;
        project.addBuildListener(this);
        if (path != null) {
            Path path2 = path.concatSystemClasspath("ignore");
            String[] stringArray = path2.list();
            int n = 0;
            while (n < stringArray.length) {
                try {
                    this.addPathElement(stringArray[n]);
                }
                catch (BuildException buildException) {}
                ++n;
            }
        }
    }

    public AntClassLoader(Project project, Path path, boolean bl) {
        this(null, project, path, bl);
    }

    public void addLoaderPackageRoot(String string) {
        this.loaderPackages.addElement(String.valueOf(string) + ".");
    }

    public void addPathElement(String string) throws BuildException {
        File file = this.project != null ? this.project.resolveFile(string) : new File(string);
        this.pathComponents.addElement(file);
    }

    public void addSystemPackageRoot(String string) {
        this.systemPackages.addElement(String.valueOf(string) + ".");
    }

    public void buildFinished(BuildEvent buildEvent) {
        this.cleanup();
    }

    public void buildStarted(BuildEvent buildEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void cleanup() {
        this.pathComponents = null;
        this.project = null;
        Enumeration enumeration = this.zipFiles.elements();
        while (enumeration.hasMoreElements()) {
            ZipFile zipFile = (ZipFile)enumeration.nextElement();
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        this.zipFiles = new Hashtable();
    }

    private Class findBaseClass(String string) throws ClassNotFoundException {
        if (this.parent == null) {
            return this.findSystemClass(string);
        }
        return this.parent.loadClass(string);
    }

    public Class findClass(String string) throws ClassNotFoundException {
        this.log("Finding class " + string, 4);
        return this.findClassInComponents(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class findClassInComponents(String string) throws ClassNotFoundException {
        Class clazz;
        InputStream inputStream = null;
        String string2 = this.getClassFilename(string);
        try {
            Enumeration enumeration = this.pathComponents.elements();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    throw new ClassNotFoundException(string);
                }
                File file = (File)enumeration.nextElement();
                try {
                    inputStream = this.getResourceStream(file, string2);
                    if (inputStream == null) continue;
                    clazz = this.getClassFromStream(inputStream, string);
                    Object var6_7 = null;
                }
                catch (IOException iOException) {
                    this.log("Exception reading component " + file, 3);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        if (inputStream == null) return clazz;
        inputStream.close();
        return clazz;
    }

    protected Enumeration findResources(String string) throws IOException {
        return new ResourceEnumeration(string);
    }

    public Class forceLoadClass(String string) throws ClassNotFoundException {
        this.log("force loading " + string, 4);
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            clazz = this.findClass(string);
        }
        return clazz;
    }

    public Class forceLoadSystemClass(String string) throws ClassNotFoundException {
        this.log("force system loading " + string, 4);
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            clazz = this.findBaseClass(string);
        }
        return clazz;
    }

    private String getClassFilename(String string) {
        return String.valueOf(string.replace('.', '/')) + ".class";
    }

    private Class getClassFromStream(InputStream inputStream, String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = -1;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray, 0, 8192)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (defineClassProtectionDomain != null) {
            try {
                Object object = getProtectionDomain.invoke((Object)(class$org$apache$tools$ant$Project != null ? class$org$apache$tools$ant$Project : (class$org$apache$tools$ant$Project = AntClassLoader.class$("org.apache.tools.ant.Project"))), new Object[0]);
                Object[] objectArray = new Object[]{string, byArray2, new Integer(0), new Integer(byArray2.length), object};
                return (Class)defineClassProtectionDomain.invoke((Object)this, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ClassFormatError) {
                    throw (ClassFormatError)throwable;
                }
                if (throwable instanceof NoClassDefFoundError) {
                    throw (NoClassDefFoundError)throwable;
                }
                throw new IOException(throwable.toString());
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
        }
        return this.defineClass(string, byArray2, 0, byArray2.length);
    }

    public URL getResource(String string) {
        URL uRL = null;
        if (this.isParentFirst(string)) {
            URL uRL2 = uRL = this.parent == null ? super.getResource(string) : this.parent.getResource(string);
        }
        if (uRL != null) {
            this.log("Resource " + string + " loaded from parent loader", 4);
        } else {
            Enumeration enumeration = this.pathComponents.elements();
            while (enumeration.hasMoreElements() && uRL == null) {
                File file = (File)enumeration.nextElement();
                uRL = this.getResourceURL(file, string);
                if (uRL == null) continue;
                this.log("Resource " + string + " loaded from ant loader", 4);
            }
        }
        if (uRL == null && !this.isParentFirst(string)) {
            URL uRL3 = uRL = this.parent == null ? super.getResource(string) : this.parent.getResource(string);
            if (uRL != null) {
                this.log("Resource " + string + " loaded from parent loader", 4);
            }
        }
        if (uRL == null) {
            this.log("Couldn't load Resource " + string, 4);
        }
        return uRL;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        if (this.isParentFirst(string)) {
            inputStream = this.loadBaseResource(string);
            if (inputStream != null) {
                this.log("ResourceStream for " + string + " loaded from parent loader", 4);
            } else {
                inputStream = this.loadResource(string);
                if (inputStream != null) {
                    this.log("ResourceStream for " + string + " loaded from ant loader", 4);
                }
            }
        } else {
            inputStream = this.loadResource(string);
            if (inputStream != null) {
                this.log("ResourceStream for " + string + " loaded from ant loader", 4);
            } else {
                inputStream = this.loadBaseResource(string);
                if (inputStream != null) {
                    this.log("ResourceStream for " + string + " loaded from parent loader", 4);
                }
            }
        }
        if (inputStream == null) {
            this.log("Couldn't load ResourceStream for " + string, 4);
        }
        return inputStream;
    }

    private InputStream getResourceStream(File file, String string) {
        try {
            if (!file.exists()) {
                return null;
            }
            if (file.isDirectory()) {
                File file2 = new File(file, string);
                if (file2.exists()) {
                    return new FileInputStream(file2);
                }
            } else {
                ZipEntry zipEntry;
                ZipFile zipFile = (ZipFile)this.zipFiles.get(file);
                if (zipFile == null) {
                    zipFile = new ZipFile(file);
                    this.zipFiles.put(file, zipFile);
                }
                if ((zipEntry = zipFile.getEntry(string)) != null) {
                    return zipFile.getInputStream(zipEntry);
                }
            }
        }
        catch (Exception exception) {
            this.log("Ignoring Exception " + exception.getClass().getName() + ": " + exception.getMessage() + " reading resource " + string + " from " + file, 3);
        }
        return null;
    }

    private URL getResourceURL(File file, String string) {
        try {
            if (!file.exists()) {
                return null;
            }
            if (file.isDirectory()) {
                File file2 = new File(file, string);
                if (file2.exists()) {
                    try {
                        return new URL("file:" + file2.toString());
                    }
                    catch (MalformedURLException malformedURLException) {
                        return null;
                    }
                }
            } else {
                ZipEntry zipEntry;
                ZipFile zipFile = (ZipFile)this.zipFiles.get(file);
                if (zipFile == null) {
                    zipFile = new ZipFile(file);
                    this.zipFiles.put(file, zipFile);
                }
                if ((zipEntry = zipFile.getEntry(string)) != null) {
                    try {
                        return new URL("jar:file:" + file.toString() + "!/" + zipEntry);
                    }
                    catch (MalformedURLException malformedURLException) {
                        return null;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static void initializeClass(Class clazz) {
        try {
            clazz.newInstance();
        }
        catch (Throwable throwable) {}
    }

    private boolean isParentFirst(String string) {
        Object object;
        boolean bl = this.parentFirst;
        Enumeration enumeration = this.systemPackages.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!string.startsWith((String)object)) continue;
            bl = true;
            break;
        }
        object = this.loaderPackages.elements();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            if (!string.startsWith(string2)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private InputStream loadBaseResource(String string) {
        if (this.parent == null) {
            return ClassLoader.getSystemResourceAsStream(string);
        }
        return this.parent.getResourceAsStream(string);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        if (this.isParentFirst(string)) {
            try {
                clazz = this.findBaseClass(string);
                this.log("Class " + string + " loaded from parent loader", 4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.findClass(string);
                this.log("Class " + string + " loaded from ant loader", 4);
            }
        } else {
            try {
                clazz = this.findClass(string);
                this.log("Class " + string + " loaded from ant loader", 4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.ignoreBase) {
                    throw classNotFoundException;
                }
                clazz = this.findBaseClass(string);
                this.log("Class " + string + " loaded from parent loader", 4);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private InputStream loadResource(String string) {
        InputStream inputStream = null;
        Enumeration enumeration = this.pathComponents.elements();
        while (enumeration.hasMoreElements() && inputStream == null) {
            File file = (File)enumeration.nextElement();
            inputStream = this.getResourceStream(file, string);
        }
        return inputStream;
    }

    protected void log(String string, int n) {
        if (this.project != null) {
            this.project.log(string, n);
        }
    }

    public void messageLogged(BuildEvent buildEvent) {
    }

    public void resetThreadContextLoader() {
        if (this.isContextLoaderSaved && getContextClassLoader != null && setContextClassLoader != null) {
            try {
                Object[] objectArray = new Object[]{this.savedContextLoader};
                setContextClassLoader.invoke((Object)Thread.currentThread(), objectArray);
                this.savedContextLoader = null;
                this.isContextLoaderSaved = false;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                throw new BuildException(throwable.toString());
            }
            catch (Exception exception) {
                throw new BuildException(exception.toString());
            }
        }
    }

    public void setIsolated(boolean bl) {
        this.ignoreBase = bl;
    }

    public void setThreadContextLoader() {
        if (this.isContextLoaderSaved) {
            throw new BuildException("Context loader has not been reset");
        }
        if (getContextClassLoader != null && setContextClassLoader != null) {
            try {
                this.savedContextLoader = (ClassLoader)getContextClassLoader.invoke((Object)Thread.currentThread(), new Object[0]);
                Object[] objectArray = new Object[]{this};
                setContextClassLoader.invoke((Object)Thread.currentThread(), objectArray);
                this.isContextLoaderSaved = true;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                throw new BuildException(throwable.toString());
            }
            catch (Exception exception) {
                throw new BuildException(exception.toString());
            }
        }
    }

    public void targetFinished(BuildEvent buildEvent) {
    }

    public void targetStarted(BuildEvent buildEvent) {
    }

    public void taskFinished(BuildEvent buildEvent) {
    }

    public void taskStarted(BuildEvent buildEvent) {
    }

    private class ResourceEnumeration
    implements Enumeration {
        private String resourceName;
        private int pathElementsIndex;
        private URL nextResource;

        ResourceEnumeration(String string) {
            this.resourceName = string;
            this.pathElementsIndex = 0;
            this.findNextResource();
        }

        private void findNextResource() {
            URL uRL = null;
            while (this.pathElementsIndex < AntClassLoader.this.pathComponents.size() && uRL == null) {
                try {
                    File file = (File)AntClassLoader.this.pathComponents.elementAt(this.pathElementsIndex);
                    uRL = AntClassLoader.this.getResourceURL(file, this.resourceName);
                    ++this.pathElementsIndex;
                }
                catch (BuildException buildException) {}
            }
            this.nextResource = uRL;
        }

        public boolean hasMoreElements() {
            return this.nextResource != null;
        }

        public Object nextElement() {
            URL uRL = this.nextResource;
            this.findNextResource();
            return uRL;
        }
    }
}

