/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import org.apache.tools.ant.Project;

public class DemuxOutputStream
extends OutputStream {
    private static final int MAX_SIZE = 1024;
    private Hashtable buffers = new Hashtable();
    private boolean skip = false;
    private Project project;
    private boolean isErrorStream;

    public DemuxOutputStream(Project project, boolean bl) {
        this.project = project;
        this.isErrorStream = bl;
    }

    public void close() throws IOException {
        this.flush();
    }

    public void flush() throws IOException {
        if (this.getBuffer().size() > 0) {
            this.processBuffer();
        }
    }

    private ByteArrayOutputStream getBuffer() {
        Thread thread = Thread.currentThread();
        ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.buffers.get(thread);
        if (byteArrayOutputStream == null) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            this.buffers.put(thread, byteArrayOutputStream);
        }
        return byteArrayOutputStream;
    }

    protected void processBuffer() {
        String string = this.getBuffer().toString();
        this.project.demuxOutput(string, this.isErrorStream);
        this.resetBuffer();
    }

    private void resetBuffer() {
        Thread thread = Thread.currentThread();
        this.buffers.remove(thread);
    }

    public void write(int n) throws IOException {
        byte by = (byte)n;
        if (by == 10 || by == 13) {
            if (!this.skip) {
                this.processBuffer();
            }
        } else {
            ByteArrayOutputStream byteArrayOutputStream = this.getBuffer();
            byteArrayOutputStream.write(n);
            if (byteArrayOutputStream.size() > 1024) {
                this.processBuffer();
            }
        }
        this.skip = by == 13;
    }
}

