/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.PathTokenizer;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.util.FileUtils;

public class Project {
    public static final int MSG_ERR = 0;
    public static final int MSG_WARN = 1;
    public static final int MSG_INFO = 2;
    public static final int MSG_VERBOSE = 3;
    public static final int MSG_DEBUG = 4;
    private static final String VISITING = "VISITING";
    private static final String VISITED = "VISITED";
    private static String javaVersion;
    public static final String JAVA_1_0 = "1.0";
    public static final String JAVA_1_1 = "1.1";
    public static final String JAVA_1_2 = "1.2";
    public static final String JAVA_1_3 = "1.3";
    public static final String JAVA_1_4 = "1.4";
    public static final String TOKEN_START = "@";
    public static final String TOKEN_END = "@";
    private String name;
    private String description;
    private Hashtable properties = new Hashtable();
    private Hashtable userProperties = new Hashtable();
    private Hashtable references = new Hashtable();
    private String defaultTarget;
    private Hashtable dataClassDefinitions = new Hashtable();
    private Hashtable taskClassDefinitions = new Hashtable();
    private Hashtable targets = new Hashtable();
    private FilterSet globalFilterSet = new FilterSet();
    private FilterSetCollection globalFilters = new FilterSetCollection(this.globalFilterSet);
    private File baseDir;
    private Vector listeners = new Vector();
    private ClassLoader coreLoader = null;
    private Hashtable threadTasks = new Hashtable();
    private FileUtils fileUtils = FileUtils.newFileUtils();

    static {
        try {
            javaVersion = JAVA_1_0;
            Class.forName("java.lang.Void");
            javaVersion = JAVA_1_1;
            Class.forName("java.lang.ThreadLocal");
            javaVersion = JAVA_1_2;
            Class.forName("java.lang.StrictMath");
            javaVersion = JAVA_1_3;
            Class.forName("java.lang.CharSequence");
            javaVersion = JAVA_1_4;
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public void addBuildListener(BuildListener buildListener) {
        this.listeners.addElement(buildListener);
    }

    public void addDataTypeDefinition(String string, Class clazz) {
        String string2 = " +User datatype: " + string + "     " + clazz.getName();
        this.log(string2, 4);
        this.dataClassDefinitions.put(string, clazz);
    }

    public void addFilter(String string, String string2) {
        if (string == null) {
            return;
        }
        this.globalFilterSet.addFilter(new FilterSet.Filter(string, string2));
    }

    public void addOrReplaceTarget(String string, Target target) {
        String string2 = " +Target: " + string;
        this.log(string2, 4);
        target.setProject(this);
        this.targets.put(string, target);
    }

    public void addOrReplaceTarget(Target target) {
        this.addOrReplaceTarget(target.getName(), target);
    }

    public void addReference(String string, Object object) {
        if (this.references.get(string) != null) {
            this.log("Overriding previous definition of reference to " + string, 1);
        }
        this.log("Adding reference: " + string + " -> " + object, 4);
        this.references.put(string, object);
    }

    public void addTarget(String string, Target target) throws BuildException {
        if (this.targets.get(string) != null) {
            throw new BuildException("Duplicate target: `" + string + "'");
        }
        this.addOrReplaceTarget(string, target);
    }

    public void addTarget(Target target) {
        String string = target.getName();
        if (this.targets.get(string) != null) {
            throw new BuildException("Duplicate target: `" + string + "'");
        }
        this.addOrReplaceTarget(string, target);
    }

    public void addTaskDefinition(String string, Class clazz) {
        String string2 = " +User task: " + string + "     " + clazz.getName();
        this.log(string2, 4);
        this.taskClassDefinitions.put(string, clazz);
    }

    public void copyFile(File file, File file2) throws IOException {
        this.fileUtils.copyFile(file, file2);
    }

    public void copyFile(File file, File file2, boolean bl) throws IOException {
        this.fileUtils.copyFile(file, file2, bl ? this.globalFilters : null);
    }

    public void copyFile(File file, File file2, boolean bl, boolean bl2) throws IOException {
        this.fileUtils.copyFile(file, file2, bl ? this.globalFilters : null, bl2);
    }

    public void copyFile(File file, File file2, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.fileUtils.copyFile(file, file2, bl ? this.globalFilters : null, bl2, bl3);
    }

    public void copyFile(String string, String string2) throws IOException {
        this.fileUtils.copyFile(string, string2);
    }

    public void copyFile(String string, String string2, boolean bl) throws IOException {
        this.fileUtils.copyFile(string, string2, bl ? this.globalFilters : null);
    }

    public void copyFile(String string, String string2, boolean bl, boolean bl2) throws IOException {
        this.fileUtils.copyFile(string, string2, bl ? this.globalFilters : null, bl2);
    }

    public void copyFile(String string, String string2, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.fileUtils.copyFile(string, string2, bl ? this.globalFilters : null, bl2, bl3);
    }

    public Object createDataType(String string) throws BuildException {
        Class clazz = (Class)this.dataClassDefinitions.get(string);
        if (clazz == null) {
            return null;
        }
        try {
            Constructor constructor = null;
            boolean bl = false;
            try {
                constructor = clazz.getConstructor(new Class[0]);
                bl = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                constructor = clazz.getConstructor(this.getClass());
                bl = false;
            }
            Object var5_9 = null;
            var5_9 = bl ? constructor.newInstance(new Object[0]) : constructor.newInstance(this);
            if (var5_9 instanceof ProjectComponent) {
                ((ProjectComponent)var5_9).setProject(this);
            }
            String string2 = "   +DataType: " + string;
            this.log(string2, 4);
            return var5_9;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            String string3 = "Could not create datatype of type: " + string + " due to " + throwable;
            throw new BuildException(string3, throwable);
        }
        catch (Throwable throwable) {
            String string4 = "Could not create datatype of type: " + string + " due to " + throwable;
            throw new BuildException(string4, throwable);
        }
    }

    public Task createTask(String string) throws BuildException {
        Class clazz = (Class)this.taskClassDefinitions.get(string);
        if (clazz == null) {
            return null;
        }
        try {
            Object object;
            Object t = clazz.newInstance();
            Task task = null;
            if (t instanceof Task) {
                task = (Task)t;
            } else {
                object = new TaskAdapter();
                ((TaskAdapter)object).setProxy(t);
                task = object;
            }
            task.setProject(this);
            task.setTaskType(string);
            task.setTaskName(string);
            object = "   +Task: " + string;
            this.log((String)object, 4);
            return task;
        }
        catch (Throwable throwable) {
            String string2 = "Could not create task of type: " + string + " due to " + throwable;
            throw new BuildException(string2, throwable);
        }
    }

    public void demuxOutput(String string, boolean bl) {
        Task task = (Task)this.threadTasks.get(Thread.currentThread());
        if (task == null) {
            this.fireMessageLogged(this, string, bl ? 0 : 2);
        } else if (bl) {
            task.handleErrorOutput(string);
        } else {
            task.handleOutput(string);
        }
    }

    public void executeTarget(String string) throws BuildException {
        Target target;
        if (string == null) {
            String string2 = "No target specified";
            throw new BuildException(string2);
        }
        Vector vector = this.topoSort(string, this.targets);
        int n = 0;
        do {
            target = (Target)vector.elementAt(n++);
            target.performTasks();
        } while (!target.getName().equals(string));
    }

    public void executeTargets(Vector vector) throws BuildException {
        Object var2_2 = null;
        int n = 0;
        while (n < vector.size()) {
            this.executeTarget((String)vector.elementAt(n));
            ++n;
        }
    }

    protected void fireBuildFinished(Throwable throwable) {
        BuildEvent buildEvent = new BuildEvent(this);
        buildEvent.setException(throwable);
        int n = 0;
        while (n < this.listeners.size()) {
            BuildListener buildListener = (BuildListener)this.listeners.elementAt(n);
            buildListener.buildFinished(buildEvent);
            ++n;
        }
    }

    protected void fireBuildStarted() {
        BuildEvent buildEvent = new BuildEvent(this);
        int n = 0;
        while (n < this.listeners.size()) {
            BuildListener buildListener = (BuildListener)this.listeners.elementAt(n);
            buildListener.buildStarted(buildEvent);
            ++n;
        }
    }

    protected void fireMessageLogged(Project project, String string, int n) {
        BuildEvent buildEvent = new BuildEvent(project);
        this.fireMessageLoggedEvent(buildEvent, string, n);
    }

    protected void fireMessageLogged(Target target, String string, int n) {
        BuildEvent buildEvent = new BuildEvent(target);
        this.fireMessageLoggedEvent(buildEvent, string, n);
    }

    protected void fireMessageLogged(Task task, String string, int n) {
        BuildEvent buildEvent = new BuildEvent(task);
        this.fireMessageLoggedEvent(buildEvent, string, n);
    }

    private void fireMessageLoggedEvent(BuildEvent buildEvent, String string, int n) {
        buildEvent.setMessage(string, n);
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            BuildListener buildListener = (BuildListener)this.listeners.elementAt(n2);
            buildListener.messageLogged(buildEvent);
            ++n2;
        }
    }

    protected void fireTargetFinished(Target target, Throwable throwable) {
        BuildEvent buildEvent = new BuildEvent(target);
        buildEvent.setException(throwable);
        int n = 0;
        while (n < this.listeners.size()) {
            BuildListener buildListener = (BuildListener)this.listeners.elementAt(n);
            buildListener.targetFinished(buildEvent);
            ++n;
        }
    }

    protected void fireTargetStarted(Target target) {
        BuildEvent buildEvent = new BuildEvent(target);
        int n = 0;
        while (n < this.listeners.size()) {
            BuildListener buildListener = (BuildListener)this.listeners.elementAt(n);
            buildListener.targetStarted(buildEvent);
            ++n;
        }
    }

    protected void fireTaskFinished(Task task, Throwable throwable) {
        this.threadTasks.remove(Thread.currentThread());
        System.out.flush();
        System.err.flush();
        BuildEvent buildEvent = new BuildEvent(task);
        buildEvent.setException(throwable);
        int n = 0;
        while (n < this.listeners.size()) {
            BuildListener buildListener = (BuildListener)this.listeners.elementAt(n);
            buildListener.taskFinished(buildEvent);
            ++n;
        }
    }

    protected void fireTaskStarted(Task task) {
        this.threadTasks.put(Thread.currentThread(), task);
        BuildEvent buildEvent = new BuildEvent(task);
        int n = 0;
        while (n < this.listeners.size()) {
            BuildListener buildListener = (BuildListener)this.listeners.elementAt(n);
            buildListener.taskStarted(buildEvent);
            ++n;
        }
    }

    public File getBaseDir() {
        block2: {
            if (this.baseDir != null) break block2;
            try {
                this.setBasedir(".");
            }
            catch (BuildException buildException) {
                buildException.printStackTrace();
            }
        }
        return this.baseDir;
    }

    public Vector getBuildListeners() {
        return this.listeners;
    }

    public ClassLoader getCoreLoader() {
        return this.coreLoader;
    }

    public Hashtable getDataTypeDefinitions() {
        return this.dataClassDefinitions;
    }

    public String getDefaultTarget() {
        return this.defaultTarget;
    }

    public String getDescription() {
        return this.description;
    }

    public Hashtable getFilters() {
        return this.globalFilterSet.getFilterHash();
    }

    public FilterSet getGlobalFilterSet() {
        return this.globalFilterSet;
    }

    public static String getJavaVersion() {
        return javaVersion;
    }

    public String getName() {
        return this.name;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public String getProperty(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)this.properties.get(string);
        return string2;
    }

    public Hashtable getReferences() {
        return this.references;
    }

    public Hashtable getTargets() {
        return this.targets;
    }

    public Hashtable getTaskDefinitions() {
        return this.taskClassDefinitions;
    }

    public Hashtable getUserProperties() {
        return this.userProperties;
    }

    public String getUserProperty(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)this.userProperties.get(string);
        return string2;
    }

    public void init() throws BuildException {
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.setJavaVersionProperty();
        String string2 = "/org/apache/tools/ant/taskdefs/defaults.properties";
        try {
            object5 = new Properties();
            object4 = this.getClass().getResourceAsStream(string2);
            if (object4 == null) {
                throw new BuildException("Can't load default task list");
            }
            ((Properties)object5).load((InputStream)object4);
            ((InputStream)object4).close();
            object3 = ((Properties)object5).propertyNames();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                string = ((Properties)object5).getProperty((String)object2);
                try {
                    object = Class.forName(string);
                    this.addTaskDefinition((String)object2, (Class)object);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Can't load default task list");
        }
        object5 = "/org/apache/tools/ant/types/defaults.properties";
        try {
            object4 = new Properties();
            object3 = this.getClass().getResourceAsStream((String)object5);
            if (object3 == null) {
                throw new BuildException("Can't load default datatype list");
            }
            ((Properties)object4).load((InputStream)object3);
            ((InputStream)object3).close();
            object2 = ((Properties)object4).propertyNames();
            while (object2.hasMoreElements()) {
                string = (String)object2.nextElement();
                object = ((Properties)object4).getProperty(string);
                try {
                    Class<?> clazz = Class.forName((String)object);
                    this.addDataTypeDefinition(string, clazz);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Can't load default datatype list");
        }
        this.setSystemProperties();
    }

    public void log(String string) {
        this.log(string, 2);
    }

    public void log(String string, int n) {
        this.fireMessageLogged(this, string, n);
    }

    public void log(Target target, String string, int n) {
        this.fireMessageLogged(target, string, n);
    }

    public void log(Task task, String string, int n) {
        this.fireMessageLogged(task, string, n);
    }

    private static BuildException makeCircularException(String string, Stack stack) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer("Circular dependency: ");
        stringBuffer.append(string);
        do {
            string2 = (String)stack.pop();
            stringBuffer.append(" <- ");
            stringBuffer.append(string2);
        } while (!string2.equals(string));
        return new BuildException(new String(stringBuffer));
    }

    public void removeBuildListener(BuildListener buildListener) {
        this.listeners.removeElement(buildListener);
    }

    public File resolveFile(String string) {
        return this.fileUtils.resolveFile(this.baseDir, string);
    }

    public File resolveFile(String string, File file) {
        return this.fileUtils.resolveFile(file, string);
    }

    public void setBaseDir(File file) throws BuildException {
        if (!(file = this.fileUtils.normalize(file.getAbsolutePath())).exists()) {
            throw new BuildException("Basedir " + file.getAbsolutePath() + " does not exist");
        }
        if (!file.isDirectory()) {
            throw new BuildException("Basedir " + file.getAbsolutePath() + " is not a directory");
        }
        this.baseDir = file;
        this.setProperty("basedir", this.baseDir.getPath());
        String string = "Project base dir set to: " + this.baseDir;
        this.log(string, 3);
    }

    public void setBasedir(String string) throws BuildException {
        this.setBaseDir(new File(string));
    }

    public void setCoreLoader(ClassLoader classLoader) {
        this.coreLoader = classLoader;
    }

    public void setDefault(String string) {
        this.defaultTarget = string;
    }

    public void setDefaultTarget(String string) {
        this.defaultTarget = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setFileLastModified(File file, long l) throws BuildException {
        if (Project.getJavaVersion() == JAVA_1_1) {
            this.log("Cannot change the modification time of " + file + " in JDK 1.1", 1);
            return;
        }
        this.fileUtils.setFileLastModified(file, l);
        this.log("Setting modification time for " + file, 3);
    }

    public void setJavaVersionProperty() {
        this.setProperty("ant.java.version", javaVersion);
        if (javaVersion == JAVA_1_0) {
            throw new BuildException("Ant cannot work on Java 1.0");
        }
        this.log("Detected Java version: " + javaVersion + " in: " + System.getProperty("java.home"), 3);
        this.log("Detected OS: " + System.getProperty("os.name"), 3);
    }

    public void setName(String string) {
        this.setUserProperty("ant.project.name", string);
        this.name = string;
    }

    public void setProperty(String string, String string2) {
        if (this.userProperties.get(string) != null) {
            this.log("Override ignored for user property " + string, 3);
            return;
        }
        this.log("Setting project property: " + string + " -> " + string2, 4);
        this.properties.put(string, string2);
    }

    public void setSystemProperties() {
        Properties properties = System.getProperties();
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            String string = ((Hashtable)properties).get(k).toString();
            this.setProperty(k.toString(), string);
        }
    }

    public void setUserProperty(String string, String string2) {
        this.log("Setting ro project property: " + string + " -> " + string2, 4);
        this.userProperties.put(string, string2);
        this.properties.put(string, string2);
    }

    public static boolean toBoolean(String string) {
        return string.equalsIgnoreCase("on") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
    }

    public final Vector topoSort(String string, Hashtable hashtable) throws BuildException {
        Vector vector = new Vector();
        Hashtable hashtable2 = new Hashtable();
        Stack stack = new Stack();
        this.tsort(string, hashtable, hashtable2, stack, vector);
        this.log("Build sequence for target `" + string + "' is " + vector, 3);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable2.get(string2);
            if (string3 == null) {
                this.tsort(string2, hashtable, hashtable2, stack, vector);
                continue;
            }
            if (string3 != VISITING) continue;
            throw new RuntimeException("Unexpected node in visiting state: " + string2);
        }
        this.log("Complete build sequence is " + vector, 3);
        return vector;
    }

    public static String translatePath(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 50);
        PathTokenizer pathTokenizer = new PathTokenizer(string);
        while (pathTokenizer.hasMoreTokens()) {
            String string2 = pathTokenizer.nextToken();
            string2 = string2.replace('/', File.separatorChar);
            string2 = string2.replace('\\', File.separatorChar);
            if (stringBuffer.length() != 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private final void tsort(String string, Hashtable hashtable, Hashtable hashtable2, Stack stack, Vector vector) throws BuildException {
        String string2;
        hashtable2.put(string, VISITING);
        stack.push(string);
        Target target = (Target)hashtable.get(string);
        if (target == null) {
            StringBuffer stringBuffer = new StringBuffer("Target `");
            stringBuffer.append(string);
            stringBuffer.append("' does not exist in this project. ");
            stack.pop();
            if (!stack.empty()) {
                String string3 = (String)stack.peek();
                stringBuffer.append("It is used from target `");
                stringBuffer.append(string3);
                stringBuffer.append("'.");
            }
            throw new BuildException(new String(stringBuffer));
        }
        Enumeration enumeration = target.getDependencies();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            String string4 = (String)hashtable2.get(string2);
            if (string4 == null) {
                this.tsort(string2, hashtable, hashtable2, stack, vector);
                continue;
            }
            if (string4 != VISITING) continue;
            throw Project.makeCircularException(string2, stack);
        }
        string2 = (String)stack.pop();
        if (string != string2) {
            throw new RuntimeException("Unexpected internal error: expected to pop " + string + " but got " + string2);
        }
        hashtable2.put(string, VISITED);
        vector.addElement(target);
    }
}

