/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;

public abstract class Task
extends ProjectComponent {
    protected Target target = null;
    protected String description = null;
    protected Location location = Location.UNKNOWN_LOCATION;
    protected String taskName = null;
    protected String taskType = null;
    protected RuntimeConfigurable wrapper;

    public void execute() throws BuildException {
    }

    public String getDescription() {
        return this.description;
    }

    public Location getLocation() {
        return this.location;
    }

    public Target getOwningTarget() {
        return this.target;
    }

    public RuntimeConfigurable getRuntimeConfigurableWrapper() {
        if (this.wrapper == null) {
            this.wrapper = new RuntimeConfigurable(this, this.getTaskName());
        }
        return this.wrapper;
    }

    public String getTaskName() {
        return this.taskName;
    }

    protected void handleErrorOutput(String string) {
        this.log(string, 0);
    }

    protected void handleOutput(String string) {
        this.log(string, 2);
    }

    public void init() throws BuildException {
    }

    public void log(String string) {
        this.log(string, 2);
    }

    public void log(String string, int n) {
        this.project.log(this, string, n);
    }

    public void maybeConfigure() throws BuildException {
        if (this.wrapper != null) {
            this.wrapper.maybeConfigure(this.project);
        }
    }

    public final void perform() {
        try {
            this.project.fireTaskStarted(this);
            this.maybeConfigure();
            this.execute();
            this.project.fireTaskFinished(this, null);
        }
        catch (RuntimeException runtimeException) {
            BuildException buildException;
            if (runtimeException instanceof BuildException && (buildException = (BuildException)runtimeException).getLocation() == Location.UNKNOWN_LOCATION) {
                buildException.setLocation(this.getLocation());
            }
            this.project.fireTaskFinished(this, runtimeException);
            throw runtimeException;
        }
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setOwningTarget(Target target) {
        this.target = target;
    }

    protected void setRuntimeConfigurableWrapper(RuntimeConfigurable runtimeConfigurable) {
        this.wrapper = runtimeConfigurable;
    }

    public void setTaskName(String string) {
        this.taskName = string;
    }

    void setTaskType(String string) {
        this.taskType = string;
    }
}

