/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteOn;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class Chmod
extends ExecuteOn {
    private FileSet defaultSet = new FileSet();
    private boolean defaultSetDefined = false;
    private boolean havePerm = false;

    public Chmod() {
        super.setExecutable("chmod");
        super.setParallel(true);
        super.setSkipEmptyFilesets(true);
    }

    protected void checkConfiguration() {
        if (!this.havePerm) {
            throw new BuildException("Required attribute perm not set in chmod", this.location);
        }
        if (this.defaultSetDefined && this.defaultSet.getDir(this.project) != null) {
            this.addFileset(this.defaultSet);
        }
        super.checkConfiguration();
    }

    public PatternSet.NameEntry createExclude() {
        this.defaultSetDefined = true;
        return this.defaultSet.createExclude();
    }

    public PatternSet.NameEntry createInclude() {
        this.defaultSetDefined = true;
        return this.defaultSet.createInclude();
    }

    public PatternSet createPatternSet() {
        this.defaultSetDefined = true;
        return this.defaultSet.createPatternSet();
    }

    public void execute() throws BuildException {
        if (this.defaultSetDefined || this.defaultSet.getDir(this.project) == null) {
            super.execute();
        } else if (this.isValidOs()) {
            this.createArg().setValue(this.defaultSet.getDir(this.project).getPath());
            Execute execute = this.prepareExec();
            try {
                try {
                    execute.setCommandline(this.cmdl.getCommandline());
                    this.runExecute(execute);
                }
                catch (IOException iOException) {
                    throw new BuildException("Execute failed: " + iOException, iOException, this.location);
                }
                Object var3_3 = null;
                this.logFlush();
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.logFlush();
                throw throwable;
            }
        }
    }

    protected boolean isValidOs() {
        return System.getProperty("path.separator").equals(":") && (!System.getProperty("os.name").startsWith("Mac") || System.getProperty("os.name").endsWith("X")) && super.isValidOs();
    }

    public void setCommand(String string) {
        throw new BuildException(String.valueOf(this.taskType) + " doesn't support the command attribute", this.location);
    }

    public void setDefaultexcludes(boolean bl) {
        this.defaultSetDefined = true;
        this.defaultSet.setDefaultexcludes(bl);
    }

    public void setDir(File file) {
        this.defaultSet.setDir(file);
    }

    public void setExcludes(String string) {
        this.defaultSetDefined = true;
        this.defaultSet.setExcludes(string);
    }

    public void setExecutable(String string) {
        throw new BuildException(String.valueOf(this.taskType) + " doesn't support the executable attribute", this.location);
    }

    public void setFile(File file) {
        FileSet fileSet = new FileSet();
        fileSet.setDir(new File(file.getParent()));
        fileSet.createInclude().setName(file.getName());
        this.addFileset(fileSet);
    }

    public void setIncludes(String string) {
        this.defaultSetDefined = true;
        this.defaultSet.setIncludes(string);
    }

    public void setPerm(String string) {
        this.createArg().setValue(string);
        this.havePerm = true;
    }

    public void setSkipEmptyFilesets(boolean bl) {
        throw new BuildException(String.valueOf(this.taskType) + " doesn't support the skipemptyfileset attribute", this.location);
    }
}

