/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;

public class Cvs
extends Task {
    private Commandline cmd = new Commandline();
    private String cvsRoot;
    private String pack;
    private String command = "checkout";
    private boolean quiet = false;
    private boolean noexec = false;
    private int port = 0;
    private File passFile = null;
    private File dest;
    private File output;
    private File error;
    private boolean failOnError = false;

    public void execute() throws BuildException {
        OutputStream outputStream;
        block31: {
            Object object;
            Commandline commandline = new Commandline();
            commandline.setExecutable("cvs");
            if (this.cvsRoot != null) {
                commandline.createArgument().setValue("-d");
                commandline.createArgument().setValue(this.cvsRoot);
            }
            if (this.noexec) {
                commandline.createArgument().setValue("-n");
            }
            if (this.quiet) {
                commandline.createArgument().setValue("-q");
            }
            commandline.createArgument().setLine(this.command);
            commandline.addArguments(this.cmd.getCommandline());
            if (this.pack != null) {
                commandline.createArgument().setLine(this.pack);
            }
            Environment environment = new Environment();
            if (this.port > 0) {
                object = new Environment.Variable();
                ((Environment.Variable)object).setKey("CVS_CLIENT_PORT");
                ((Environment.Variable)object).setValue(String.valueOf(this.port));
                environment.addVariable((Environment.Variable)object);
            }
            if (this.passFile != null) {
                object = new Environment.Variable();
                ((Environment.Variable)object).setKey("CVS_PASSFILE");
                ((Environment.Variable)object).setValue(String.valueOf(this.passFile));
                environment.addVariable((Environment.Variable)object);
            }
            object = null;
            OutputStream outputStream2 = null;
            outputStream = null;
            if (this.error == null && this.output == null) {
                object = new LogStreamHandler(this, 2, 1);
            } else {
                if (this.output != null) {
                    try {
                        outputStream2 = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.output)));
                    }
                    catch (IOException iOException) {
                        throw new BuildException(iOException, this.location);
                    }
                } else {
                    outputStream2 = new LogOutputStream(this, 2);
                }
                if (this.error != null) {
                    try {
                        outputStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.error)));
                    }
                    catch (IOException iOException) {
                        throw new BuildException(iOException, this.location);
                    }
                } else {
                    outputStream = new LogOutputStream(this, 1);
                }
                object = new PumpStreamHandler(outputStream2, outputStream);
            }
            Execute execute = new Execute((ExecuteStreamHandler)object, null);
            execute.setAntRun(this.project);
            if (this.dest == null) {
                this.dest = this.project.getBaseDir();
            }
            execute.setWorkingDirectory(this.dest);
            execute.setCommandline(commandline.getCommandline());
            execute.setEnvironment(environment.getVariables());
            try {
                try {
                    int n = execute.execute();
                    if (this.failOnError && n != 0) {
                        throw new BuildException("cvs exited with error code " + n);
                    }
                }
                catch (IOException iOException) {
                    throw new BuildException(iOException, this.location);
                }
                Object var8_11 = null;
                if (this.output == null) break block31;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                if (this.output != null) {
                    try {
                        outputStream2.close();
                    }
                    catch (IOException iOException) {}
                }
                if (this.error != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                outputStream2.close();
            }
            catch (IOException iOException) {}
        }
        if (this.error != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public void setCvsRoot(String string) {
        if (string != null && string.trim().equals("")) {
            string = null;
        }
        this.cvsRoot = string;
    }

    public void setDate(String string) {
        if (string != null && string.trim().length() > 0) {
            this.cmd.createArgument().setValue("-D");
            this.cmd.createArgument().setValue(string);
        }
    }

    public void setDest(File file) {
        this.dest = file;
    }

    public void setError(File file) {
        this.error = file;
    }

    public void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    public void setNoexec(boolean bl) {
        this.noexec = bl;
    }

    public void setOutput(File file) {
        this.output = file;
    }

    public void setPackage(String string) {
        this.pack = string;
    }

    public void setPassfile(File file) {
        this.passFile = file;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    public void setTag(String string) {
        if (string != null && string.trim().length() > 0) {
            this.cmd.createArgument().setValue("-r");
            this.cmd.createArgument().setValue(string);
        }
    }
}

