/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;

public class ExecuteJava {
    private Commandline javaCommand = null;
    private Path classpath = null;
    private CommandlineJava.SysProperties sysProperties = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(Project project) throws BuildException {
        String string = this.javaCommand.getExecutable();
        Object[] objectArray = new Object[]{this.javaCommand.getArguments()};
        AntClassLoader antClassLoader = null;
        try {
            try {
                if (this.sysProperties != null) {
                    this.sysProperties.setSystem();
                }
                Class[] classArray = new Class[]{Class.forName("[Ljava.lang.String;")};
                Class clazz = null;
                if (this.classpath == null) {
                    clazz = Class.forName(string);
                } else {
                    antClassLoader = new AntClassLoader(project.getCoreLoader(), project, this.classpath, false);
                    antClassLoader.setIsolated(true);
                    antClassLoader.setThreadContextLoader();
                    clazz = antClassLoader.forceLoadClass(string);
                    AntClassLoader.initializeClass(clazz);
                }
                Method method = clazz.getMethod("main", classArray);
                method.invoke(null, objectArray);
            }
            catch (NullPointerException nullPointerException) {
                throw new BuildException("Could not find main() method in " + string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new BuildException("Could not find " + string + ". Make sure you have it in your classpath");
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SecurityException) throw (SecurityException)throwable;
                throw new BuildException(throwable);
            }
            catch (Exception exception) {
                throw new BuildException(exception);
            }
            Object var6_11 = null;
            if (antClassLoader != null) {
                antClassLoader.resetThreadContextLoader();
                antClassLoader.cleanup();
            }
            if (this.sysProperties == null) return;
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            if (antClassLoader != null) {
                antClassLoader.resetThreadContextLoader();
                antClassLoader.cleanup();
            }
            if (this.sysProperties == null) throw throwable;
            this.sysProperties.restoreSystem();
            throw throwable;
        }
        this.sysProperties.restoreSystem();
    }

    public void setClasspath(Path path) {
        this.classpath = path;
    }

    public void setJavaCommand(Commandline commandline) {
        this.javaCommand = commandline;
    }

    public void setOutput(PrintStream printStream) {
    }

    public void setSystemProperties(CommandlineJava.SysProperties sysProperties) {
        this.sysProperties = sysProperties;
    }
}

