/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class FixCRLF
extends MatchingTask {
    private static final int UNDEF = -1;
    private static final int NOTJAVA = 0;
    private static final int LOOKING = 1;
    private static final int IN_CHAR_CONST = 2;
    private static final int IN_STR_CONST = 3;
    private static final int IN_SINGLE_COMMENT = 4;
    private static final int IN_MULTI_COMMENT = 5;
    private static final int ASIS = 0;
    private static final int CR = 1;
    private static final int LF = 2;
    private static final int CRLF = 3;
    private static final int ADD = 1;
    private static final int REMOVE = -1;
    private static final int SPACES = -1;
    private static final int TABS = 1;
    private static final int INBUFLEN = 8192;
    private static final int LINEBUFLEN = 200;
    private static final char CTRLZ = '\u001a';
    private int tablength = 8;
    private String spaces = "        ";
    private StringBuffer linebuf = new StringBuffer(1024);
    private StringBuffer linebuf2 = new StringBuffer(1024);
    private int eol;
    private String eolstr;
    private int ctrlz;
    private int tabs = 0;
    private boolean javafiles = false;
    private File srcDir;
    private File destDir = null;

    public FixCRLF() {
        if (System.getProperty("path.separator").equals(":")) {
            this.ctrlz = -1;
            if (System.getProperty("os.name").indexOf("Mac") > -1) {
                this.eol = 1;
                this.eolstr = "\r";
            } else {
                this.eol = 2;
                this.eolstr = "\n";
            }
        } else {
            this.ctrlz = 0;
            this.eol = 3;
            this.eolstr = "\r\n";
        }
    }

    private File createTempFile() {
        String string = "fixcrlf" + new Random(System.currentTimeMillis()).nextLong();
        if (this.destDir == null) {
            return new File(this.srcDir, string);
        }
        return new File(this.destDir, string);
    }

    private void endOfCharConst(OneLiner.BufferLine bufferLine, char c) throws BuildException {
        int n = bufferLine.getNext();
        int n2 = bufferLine.length();
        ++n;
        while (n < n2) {
            char c2;
            if ((c2 = bufferLine.getChar(n++)) == '\\') {
                ++n;
                continue;
            }
            if (c2 != c) continue;
            bufferLine.setLookahead(n);
            return;
        }
        throw new BuildException("endOfCharConst: unterminated char constant");
    }

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            throw new BuildException("srcdir attribute must be set!");
        }
        if (!this.srcDir.exists()) {
            throw new BuildException("srcdir does not exist!");
        }
        if (!this.srcDir.isDirectory()) {
            throw new BuildException("srcdir is not a directory!");
        }
        if (this.destDir != null) {
            if (!this.destDir.exists()) {
                throw new BuildException("destdir does not exist!");
            }
            if (!this.destDir.isDirectory()) {
                throw new BuildException("destdir is not a directory!");
            }
        }
        this.log("options: eol=" + (this.eol == 0 ? "asis" : (this.eol == 1 ? "cr" : (this.eol == 2 ? "lf" : "crlf"))) + " tab=" + (this.tabs == 1 ? "add" : (this.tabs == 0 ? "asis" : "remove")) + " eof=" + (this.ctrlz == 1 ? "add" : (this.ctrlz == 0 ? "asis" : "remove")) + " tablength=" + this.tablength, 3);
        DirectoryScanner directoryScanner = super.getDirectoryScanner(this.srcDir);
        String[] stringArray = directoryScanner.getIncludedFiles();
        int n = 0;
        while (n < stringArray.length) {
            this.processFile(stringArray[n]);
            ++n;
        }
    }

    private boolean filesEqual(File file, File file2) {
        char[] cArray = new char[8192];
        char[] cArray2 = new char[8192];
        if (file.length() != file2.length()) {
            return false;
        }
        try {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file), 8192);
            BufferedReader bufferedReader2 = new BufferedReader(new FileReader(file2), 8192);
            while ((n = bufferedReader.read(cArray, 0, 8192)) != -1) {
                bufferedReader2.read(cArray2, 0, 8192);
                int n2 = 0;
                while (n2 < n) {
                    if (cArray[n2] != cArray2[n2]) {
                        bufferedReader.close();
                        bufferedReader2.close();
                        return false;
                    }
                    ++n2;
                }
            }
            bufferedReader.close();
            bufferedReader2.close();
            return true;
        }
        catch (IOException iOException) {
            throw new BuildException("IOException in filesEqual: " + file + " : " + file2);
        }
    }

    private void nextStateChange(OneLiner.BufferLine bufferLine) throws BuildException {
        int n = bufferLine.length();
        int n2 = bufferLine.getNext();
        while (n2 < n) {
            switch (bufferLine.getChar(n2++)) {
                case '\'': {
                    bufferLine.setState(2);
                    bufferLine.setLookahead(--n2);
                    return;
                }
                case '\"': {
                    bufferLine.setState(3);
                    bufferLine.setLookahead(--n2);
                    return;
                }
                case '/': {
                    if (n2 >= n) break;
                    if (bufferLine.getChar(n2) == '*') {
                        bufferLine.setState(5);
                        bufferLine.setLookahead(--n2);
                        return;
                    }
                    if (bufferLine.getChar(n2) != '/') break;
                    bufferLine.setState(4);
                    bufferLine.setLookahead(--n2);
                    return;
                }
            }
        }
        bufferLine.setLookahead(n2);
    }

    private void notInConstant(OneLiner.BufferLine bufferLine, int n, BufferedWriter bufferedWriter) {
        int n2;
        String string = bufferLine.substring(bufferLine.getNext(), n);
        int n3 = 0;
        int n4 = bufferLine.getColumn();
        this.linebuf.setLength(0);
        while ((n2 = string.indexOf(9, n3)) >= 0) {
            this.linebuf.append(string.substring(n3, n2));
            int n5 = this.tablength - (n4 += n2 - n3) % this.tablength;
            this.linebuf.append(this.spaces.substring(0, n5));
            n4 += n5;
            n3 = n2 + 1;
        }
        this.linebuf.append(string.substring(n3, string.length()));
        String string2 = new String(this.linebuf.toString());
        if (this.tabs == -1) {
            try {
                bufferedWriter.write(string2);
            }
            catch (IOException iOException) {
                throw new BuildException(iOException);
            }
        }
        this.linebuf2.setLength(0);
        n3 = 0;
        int n6 = n4 = bufferLine.getColumn();
        int n7 = n4 + (this.tablength - n4 % this.tablength);
        if (n7 - n4 < 2) {
            this.linebuf2.append(string2.substring(n3, n7 - n6));
            n3 = n7 - n6;
            n7 += this.tablength;
        }
        while (n7 - n6 <= string2.length()) {
            int n8 = n7;
            while (--n8 - n6 >= n3 && string2.charAt(n8 - n6) == ' ') {
            }
            if (n7 - n8 > 2) {
                this.linebuf2.append(string2.substring(n3, ++n8 - n6));
                this.linebuf2.append('\t');
            } else {
                this.linebuf2.append(string2.substring(n3, n7 - n6));
            }
            n3 = n7 - n6;
            n7 += this.tablength;
        }
        this.linebuf2.append(string2.substring(n3, string2.length()));
        try {
            bufferedWriter.write(this.linebuf2.toString());
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
        bufferLine.setColumn(bufferLine.getColumn() + string2.length());
        bufferLine.setNext(n);
    }

    /*
     * Unable to fully structure code
     */
    private void processFile(String var1_1) throws BuildException {
        var2_2 = new File(this.srcDir, var1_1);
        var3_3 = null;
        var6_4 = new OneLiner(var2_2);
        try {
            try {
                var3_3 = this.createTempFile();
                var9_5 = new FileWriter(var3_3);
                var4_9 = new BufferedWriter((Writer)var9_5);
                if (true) ** GOTO lbl71
            }
            catch (IOException var9_6) {
                throw new BuildException(var9_6);
            }
            do {
                try {
                    var5_10 = (OneLiner.BufferLine)var6_4.nextElement();
                }
                catch (NoSuchElementException var10_12) {
                    throw new BuildException(var10_12);
                }
                var10_11 = var5_10.getLineString();
                var11_13 = var5_10.length();
                if (this.tabs != 0) ** GOTO lbl65
                try {
                    var4_9.write(var10_11);
                }
                catch (IOException var12_15) {
                    throw new BuildException(var12_15);
                }
lbl-1000:
                // 1 sources

                {
                    switch (var6_4.getState()) {
                        case 0: {
                            this.notInConstant(var5_10, var5_10.length(), var4_9);
                            break;
                        }
                        case 5: {
                            var9_7 = var10_11.indexOf("*/", var5_10.getNext());
                            if (var9_7 >= 0) {
                                var9_7 += 2;
                                var6_4.setState(1);
                            } else {
                                var9_7 = var11_13;
                            }
                            this.notInConstant(var5_10, var9_7, var4_9);
                            break;
                        }
                        case 4: {
                            this.notInConstant(var5_10, var5_10.length(), var4_9);
                            var6_4.setState(1);
                            break;
                        }
                        case 2: 
                        case 3: {
                            var13_17 = var5_10.getNext();
                            var14_18 = var6_4.getState() == 3 ? '\"' : '\'';
                            this.endOfCharConst(var5_10, var14_18);
                            while (var5_10.getNext() < var5_10.getLookahead()) {
                                if (var5_10.getNextCharInc() == '\t') {
                                    var5_10.setColumn(var5_10.getColumn() + this.tablength - var5_10.getColumn() % this.tablength);
                                    continue;
                                }
                                var5_10.incColumn();
                            }
                            try {
                                var4_9.write(var5_10.substring(var13_17, var5_10.getNext()));
                            }
                            catch (IOException var15_19) {
                                throw new BuildException(var15_19);
                            }
                            var6_4.setState(1);
                            break;
                        }
                        case 1: {
                            this.nextStateChange(var5_10);
                            this.notInConstant(var5_10, var5_10.getLookahead(), var4_9);
                            break;
                        }
                    }
lbl65:
                    // 7 sources

                    ** while ((var12_14 = var5_10.getNext()) < var11_13)
                }
lbl66:
                // 2 sources

                try {
                    var4_9.write(this.eolstr);
                }
                catch (IOException var12_16) {
                    throw new BuildException(var12_16);
                }
lbl71:
                // 2 sources

            } while (var6_4.hasMoreElements());
            try {
                if (this.ctrlz == 0) {
                    var4_9.write(var6_4.getEofStr());
                } else if (this.ctrlz == 1) {
                    var4_9.write(26);
                }
                var4_9.close();
            }
            catch (IOException var9_8) {
                throw new BuildException(var9_8);
            }
            var9_5 = new File(this.destDir == null ? this.srcDir : this.destDir, var1_1);
            try {
                var6_4.close();
                var6_4 = null;
            }
            catch (IOException v0) {
                throw new BuildException("Unable to close source file " + var2_2);
            }
            if (var9_5.exists()) {
                this.log("destFile exists", 4);
                if (!this.filesEqual((File)var9_5, var3_3)) {
                    this.log(String.valueOf(String.valueOf(var9_5)) + " is being written", 4);
                    if (!var9_5.delete()) {
                        throw new BuildException("Unable to delete " + var9_5);
                    }
                    if (!var3_3.renameTo((File)var9_5)) {
                        throw new BuildException("Failed to transform " + var2_2 + " to " + var9_5 + ". Couldn't rename temporary file: " + var3_3);
                    }
                } else {
                    this.log(String.valueOf(String.valueOf(var9_5)) + " is not written, as the contents are identical", 4);
                    if (!var3_3.delete()) {
                        throw new BuildException("Unable to delete " + var3_3);
                    }
                }
            } else {
                this.log("destFile does not exist", 4);
                if (!var3_3.renameTo((File)var9_5)) {
                    throw new BuildException("Failed to transform " + var2_2 + " to " + var9_5 + ". Couldn't rename temporary file: " + var3_3);
                }
            }
            var3_3 = null;
        }
        catch (Throwable var7_22) {
            var8_21 = null;
            try {
                if (var6_4 != null) {
                    var6_4.close();
                }
            }
            catch (IOException v1) {
                this.log("Error closing " + var2_2, 0);
            }
            if (var3_3 != null) {
                var3_3.delete();
            }
            throw var7_22;
        }
        var8_20 = null;
        try {
            if (var6_4 != null) {
                var6_4.close();
            }
        }
        catch (IOException v2) {
            this.log("Error closing " + var2_2, 0);
        }
        if (var3_3 != null) {
            var3_3.delete();
        }
    }

    public void setCr(AddAsisRemove addAsisRemove) {
        this.log("DEPRECATED: The cr attribute has been deprecated,", 1);
        this.log("Please us the eol attribute instead", 1);
        String string = addAsisRemove.getValue();
        CrLf crLf = new CrLf();
        if (string.equals("remove")) {
            crLf.setValue("lf");
        } else if (string.equals("asis")) {
            crLf.setValue("asis");
        } else {
            crLf.setValue("crlf");
        }
        this.setEol(crLf);
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setEof(AddAsisRemove addAsisRemove) {
        String string = addAsisRemove.getValue();
        this.ctrlz = string.equals("remove") ? -1 : (string.equals("asis") ? 0 : 1);
    }

    public void setEol(CrLf crLf) {
        String string = crLf.getValue();
        if (string.equals("asis")) {
            this.eol = 0;
        } else if (string.equals("cr")) {
            this.eol = 1;
            this.eolstr = "\r";
        } else if (string.equals("lf")) {
            this.eol = 2;
            this.eolstr = "\n";
        } else {
            this.eol = 3;
            this.eolstr = "\r\n";
        }
    }

    public void setJavafiles(boolean bl) {
        this.javafiles = bl;
    }

    public void setSrcdir(File file) {
        this.srcDir = file;
    }

    public void setTab(AddAsisRemove addAsisRemove) {
        String string = addAsisRemove.getValue();
        this.tabs = string.equals("remove") ? -1 : (string.equals("asis") ? 0 : 1);
    }

    public void setTablength(int n) throws BuildException {
        if (n < 2 || n > 80) {
            throw new BuildException("tablength must be between 2 and 80", this.location);
        }
        this.tablength = n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this.tablength) {
            stringBuffer.append(' ');
            ++n2;
        }
        this.spaces = stringBuffer.toString();
    }

    class OneLiner
    implements Enumeration {
        private int state;
        private StringBuffer eolStr;
        private StringBuffer eofStr;
        private BufferedReader reader;
        private String line;

        public OneLiner(File file) throws BuildException {
            this.state = FixCRLF.this.javafiles ? 1 : 0;
            this.eolStr = new StringBuffer(200);
            this.eofStr = new StringBuffer();
            try {
                this.reader = new BufferedReader(new FileReader(file), 8192);
                this.nextLine();
            }
            catch (IOException iOException) {
                throw new BuildException(iOException);
            }
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }

        public String getEofStr() {
            return this.eofStr.toString();
        }

        public int getState() {
            return this.state;
        }

        public boolean hasMoreElements() {
            return this.line != null;
        }

        public Object nextElement() throws NoSuchElementException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("OneLiner");
            }
            BufferLine bufferLine = new BufferLine(this.line, this.eolStr.toString());
            this.nextLine();
            return bufferLine;
        }

        /*
         * Exception decompiling
         */
        protected void nextLine() throws BuildException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void setState(int n) {
            this.state = n;
        }

        class BufferLine {
            private int next = 0;
            private int column = 0;
            private int lookahead = -1;
            private String line;
            private String eolStr;

            public BufferLine(String string, String string2) throws BuildException {
                this.line = string;
                this.eolStr = string2;
            }

            public char getChar(int n) {
                return this.line.charAt(n);
            }

            public int getColumn() {
                return this.column;
            }

            public String getEol() {
                return this.eolStr;
            }

            public int getEolLength() {
                return this.eolStr.length();
            }

            public String getLineString() {
                return this.line;
            }

            public int getLookahead() {
                return this.lookahead;
            }

            public int getNext() {
                return this.next;
            }

            public char getNextChar() {
                return this.getChar(this.next);
            }

            public char getNextCharInc() {
                return this.getChar(this.next++);
            }

            public int getState() {
                return OneLiner.this.getState();
            }

            public int incColumn() {
                return this.column++;
            }

            public int length() {
                return this.line.length();
            }

            public void setColumn(int n) {
                this.column = n;
            }

            public void setLookahead(int n) {
                this.lookahead = n;
            }

            public void setNext(int n) {
                this.next = n;
            }

            public void setState(int n) {
                OneLiner.this.setState(n);
            }

            public String substring(int n) {
                return this.line.substring(n);
            }

            public String substring(int n, int n2) {
                return this.line.substring(n, n2);
            }
        }
    }

    public static class AddAsisRemove
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"add", "asis", "remove"};
        }
    }

    public static class CrLf
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"asis", "cr", "lf", "crlf"};
        }
    }
}

