/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class GZip
extends Task {
    private File zipFile;
    private File source;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        if (this.zipFile == null) {
            throw new BuildException("zipfile attribute is required", this.location);
        }
        if (this.source == null) {
            throw new BuildException("src attribute is required", this.location);
        }
        this.log("Building gzip: " + this.zipFile.getAbsolutePath());
        GZIPOutputStream gZIPOutputStream = null;
        try {
            try {
                gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(this.zipFile));
                if (this.source.isDirectory()) {
                    this.log("Cannot Gzip a directory!", 0);
                } else {
                    this.zipFile(this.source, gZIPOutputStream);
                }
            }
            catch (IOException iOException) {
                String string = "Problem creating gzip " + iOException.getMessage();
                throw new BuildException(string, iOException, this.location);
            }
            Object var3_4 = null;
            if (gZIPOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            if (gZIPOutputStream == null) throw throwable;
            try {
                gZIPOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            gZIPOutputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public void setSrc(File file) {
        this.source = file;
    }

    public void setZipfile(File file) {
        this.zipFile = file;
    }

    private void zipFile(File file, GZIPOutputStream gZIPOutputStream) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.zipFile(fileInputStream, gZIPOutputStream);
        }
        finally {
            Object var5_4 = null;
            fileInputStream.close();
        }
    }

    private void zipFile(InputStream inputStream, GZIPOutputStream gZIPOutputStream) throws IOException {
        byte[] byArray = new byte[8192];
        int n = 0;
        do {
            gZIPOutputStream.write(byArray, 0, n);
        } while ((n = inputStream.read(byArray, 0, byArray.length)) != -1);
    }
}

