/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Commandline;

public class GenerateKey
extends Task {
    protected String alias;
    protected String keystore;
    protected String storepass;
    protected String storetype;
    protected String keypass;
    protected String sigalg;
    protected String keyalg;
    protected String dname;
    protected DistinguishedName expandedDname;
    protected int keysize;
    protected int validity;
    protected boolean verbose;

    public DistinguishedName createDname() throws BuildException {
        if (this.expandedDname != null) {
            throw new BuildException("DName sub-element can only be specified once.");
        }
        if (this.dname != null) {
            throw new BuildException("It is not possible to specify dname both as attribute and element.");
        }
        this.expandedDname = new DistinguishedName();
        return this.expandedDname;
    }

    public void execute() throws BuildException {
        if (Project.getJavaVersion().equals("1.1")) {
            throw new BuildException("The genkey task is only available on JDK versions 1.2 or greater");
        }
        if (this.alias == null) {
            throw new BuildException("alias attribute must be set");
        }
        if (this.storepass == null) {
            throw new BuildException("storepass attribute must be set");
        }
        if (this.dname == null && this.expandedDname == null) {
            throw new BuildException("dname must be set");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("keytool -genkey ");
        if (this.verbose) {
            stringBuffer.append("-v ");
        }
        stringBuffer.append("-alias \"");
        stringBuffer.append(this.alias);
        stringBuffer.append("\" ");
        if (this.dname != null) {
            stringBuffer.append("-dname \"");
            stringBuffer.append(this.dname);
            stringBuffer.append("\" ");
        }
        if (this.expandedDname != null) {
            stringBuffer.append("-dname \"");
            stringBuffer.append(this.expandedDname);
            stringBuffer.append("\" ");
        }
        if (this.keystore != null) {
            stringBuffer.append("-keystore \"");
            stringBuffer.append(this.keystore);
            stringBuffer.append("\" ");
        }
        if (this.storepass != null) {
            stringBuffer.append("-storepass \"");
            stringBuffer.append(this.storepass);
            stringBuffer.append("\" ");
        }
        if (this.storetype != null) {
            stringBuffer.append("-storetype \"");
            stringBuffer.append(this.storetype);
            stringBuffer.append("\" ");
        }
        stringBuffer.append("-keypass \"");
        if (this.keypass != null) {
            stringBuffer.append(this.keypass);
        } else {
            stringBuffer.append(this.storepass);
        }
        stringBuffer.append("\" ");
        if (this.sigalg != null) {
            stringBuffer.append("-sigalg \"");
            stringBuffer.append(this.sigalg);
            stringBuffer.append("\" ");
        }
        if (this.keyalg != null) {
            stringBuffer.append("-keyalg \"");
            stringBuffer.append(this.keyalg);
            stringBuffer.append("\" ");
        }
        if (this.keysize > 0) {
            stringBuffer.append("-keysize \"");
            stringBuffer.append(this.keysize);
            stringBuffer.append("\" ");
        }
        if (this.validity > 0) {
            stringBuffer.append("-validity \"");
            stringBuffer.append(this.validity);
            stringBuffer.append("\" ");
        }
        this.log("Generating Key for " + this.alias);
        ExecTask execTask = (ExecTask)this.project.createTask("exec");
        execTask.setCommand(new Commandline(stringBuffer.toString()));
        execTask.setFailonerror(true);
        execTask.setTaskName(this.getTaskName());
        execTask.execute();
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public void setDname(String string) {
        if (this.expandedDname != null) {
            throw new BuildException("It is not possible to specify dname both as attribute and element.");
        }
        this.dname = string;
    }

    public void setKeyalg(String string) {
        this.keyalg = string;
    }

    public void setKeypass(String string) {
        this.keypass = string;
    }

    public void setKeysize(String string) throws BuildException {
        try {
            this.keysize = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BuildException("KeySize attribute should be a integer");
        }
    }

    public void setKeystore(String string) {
        this.keystore = string;
    }

    public void setSigalg(String string) {
        this.sigalg = string;
    }

    public void setStorepass(String string) {
        this.storepass = string;
    }

    public void setStoretype(String string) {
        this.storetype = string;
    }

    public void setValidity(String string) throws BuildException {
        try {
            this.validity = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BuildException("Validity attribute should be a integer");
        }
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public static class DnameParam {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setValue(String string) {
            this.value = string;
        }
    }

    public static class DistinguishedName {
        private String name;
        private String path;
        private Vector params = new Vector();

        public Object createParam() {
            DnameParam dnameParam = new DnameParam();
            this.params.addElement(dnameParam);
            return dnameParam;
        }

        public String encode(String string) {
            int n = string.indexOf(44);
            if (n == -1) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n != -1) {
                stringBuffer.append(string.substring(n2, n));
                stringBuffer.append("\\,");
                n2 = n + 1;
                n = string.indexOf(44, n2);
            }
            stringBuffer.append(string.substring(n2));
            return stringBuffer.toString();
        }

        public Enumeration getParams() {
            return this.params.elements();
        }

        public String toString() {
            int n = this.params.size();
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            int n2 = 0;
            while (n2 < n) {
                if (!bl) {
                    stringBuffer.append(" ,");
                }
                bl = false;
                DnameParam dnameParam = (DnameParam)this.params.elementAt(n2);
                stringBuffer.append(this.encode(dnameParam.getName()));
                stringBuffer.append('=');
                stringBuffer.append(this.encode(dnameParam.getValue()));
                ++n2;
            }
            return stringBuffer.toString();
        }
    }
}

