/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Touch;

public class Get
extends Task {
    private URL source;
    private File dest;
    private boolean verbose = false;
    private boolean useTimestamp = false;
    private boolean ignoreErrors = false;

    public void execute() throws BuildException {
        if (this.source == null) {
            throw new BuildException("src attribute is required", this.location);
        }
        if (this.dest == null) {
            throw new BuildException("dest attribute is required", this.location);
        }
        if (this.dest.exists() && this.dest.isDirectory()) {
            throw new BuildException("The specified destination is a directory", this.location);
        }
        if (this.dest.exists() && !this.dest.canWrite()) {
            throw new BuildException("Can't write to " + this.dest.getAbsolutePath(), this.location);
        }
        try {
            int n;
            Object object;
            Object object2;
            this.log("Getting: " + this.source);
            long l = 0L;
            boolean bl = false;
            if (this.useTimestamp && this.dest.exists()) {
                l = this.dest.lastModified();
                if (this.verbose) {
                    object2 = new Date(l);
                    this.log("local file date : " + ((Date)object2).toString());
                }
                bl = true;
            }
            object2 = this.source.openConnection();
            if (this.useTimestamp && bl) {
                ((URLConnection)object2).setIfModifiedSince(l);
            }
            ((URLConnection)object2).connect();
            if (object2 instanceof HttpURLConnection && ((HttpURLConnection)(object = (HttpURLConnection)object2)).getResponseCode() == 304) {
                this.log("Not modified - so not downloaded");
                return;
            }
            object = new FileOutputStream(this.dest);
            InputStream inputStream = null;
            int n2 = 0;
            while (n2 < 3) {
                try {
                    inputStream = ((URLConnection)object2).getInputStream();
                    break;
                }
                catch (IOException iOException) {
                    this.log("Error opening connection " + iOException);
                    ++n2;
                }
            }
            if (inputStream == null) {
                this.log("Can't get " + this.source + " to " + this.dest);
                if (this.ignoreErrors) {
                    return;
                }
                throw new BuildException("Can't get " + this.source + " to " + this.dest, this.location);
            }
            byte[] byArray = new byte[102400];
            while ((n = inputStream.read(byArray)) >= 0) {
                ((FileOutputStream)object).write(byArray, 0, n);
                if (!this.verbose) continue;
                System.out.print(".");
            }
            if (this.verbose) {
                System.out.println();
            }
            ((FileOutputStream)object).close();
            inputStream.close();
            if (this.useTimestamp) {
                long l2 = ((URLConnection)object2).getLastModified();
                if (this.verbose) {
                    Date date = new Date(l2);
                    this.log("last modified = " + date.toString() + (l2 == 0L ? " - using current time instead" : ""));
                }
                if (l2 != 0L) {
                    this.touchFile(this.dest, l2);
                }
            }
        }
        catch (IOException iOException) {
            this.log("Error getting " + this.source + " to " + this.dest);
            if (this.ignoreErrors) {
                return;
            }
            throw new BuildException(iOException, this.location);
        }
    }

    public void setDest(File file) {
        this.dest = file;
    }

    public void setIgnoreErrors(boolean bl) {
        this.ignoreErrors = bl;
    }

    public void setSrc(URL uRL) {
        this.source = uRL;
    }

    public void setUseTimestamp(boolean bl) {
        if (Project.getJavaVersion() != "1.1") {
            this.useTimestamp = bl;
        }
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    protected boolean touchFile(File file, long l) throws BuildException {
        if (Project.getJavaVersion() != "1.1") {
            Touch touch = (Touch)this.project.createTask("touch");
            touch.setOwningTarget(this.target);
            touch.setTaskName(this.getTaskName());
            touch.setLocation(this.getLocation());
            touch.setFile(file);
            touch.setMillis(l);
            touch.touch();
            return true;
        }
        return false;
    }
}

