/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.zip.ZipOutputStream;

public class Jar
extends Zip {
    private File manifestFile;
    private Manifest manifest;
    private Manifest execManifest;
    private boolean buildFileManifest = false;

    public Jar() {
        this.archiveType = "jar";
        this.emptyBehavior = "create";
        this.setEncoding("UTF8");
    }

    public void addConfiguredManifest(Manifest manifest) throws ManifestException {
        if (this.manifest == null) {
            this.manifest = this.getDefaultManifest();
        }
        this.manifest.merge(manifest);
        this.buildFileManifest = true;
    }

    public void addMetainf(ZipFileSet zipFileSet) {
        zipFileSet.setPrefix("META-INF/");
        super.addFileset(zipFileSet);
    }

    protected void cleanUp() {
        super.cleanUp();
    }

    protected boolean createEmptyZip(File file) {
        return false;
    }

    private Manifest getDefaultManifest() {
        try {
            String string = "/org/apache/tools/ant/defaultManifest.mf";
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                throw new BuildException("Could not find default manifest: " + string);
            }
            return new Manifest(inputStream);
        }
        catch (ManifestException manifestException) {
            throw new BuildException("Default manifest is invalid !!");
        }
        catch (IOException iOException) {
            throw new BuildException("Unable to read default manifest", iOException);
        }
    }

    protected void initZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
        try {
            this.execManifest = this.getDefaultManifest();
            if (this.manifest != null) {
                this.execManifest.merge(this.manifest);
            }
            Enumeration enumeration = this.execManifest.getWarnings();
            while (enumeration.hasMoreElements()) {
                this.log("Manifest warning: " + (String)enumeration.nextElement(), 1);
            }
            this.zipDir(null, zipOutputStream, "META-INF/");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            this.execManifest.write(printWriter);
            printWriter.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            super.zipFile(byteArrayInputStream, zipOutputStream, "META-INF/MANIFEST.MF", System.currentTimeMillis());
            super.initZipOutputStream(zipOutputStream);
        }
        catch (ManifestException manifestException) {
            this.log("Manifest is invalid: " + manifestException.getMessage(), 0);
            throw new BuildException("Invalid Manifest", manifestException, this.getLocation());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isUpToDate(FileScanner[] fileScannerArray, File file) throws BuildException {
        ZipFile zipFile;
        block14: {
            boolean bl;
            block15: {
                boolean bl2;
                block13: {
                    if (!this.buildFileManifest && this.manifestFile != null) {
                        if (this.manifestFile.lastModified() <= file.lastModified()) return super.isUpToDate(fileScannerArray, file);
                        return false;
                    }
                    zipFile = null;
                    try {
                        try {
                            zipFile = new ZipFile(file);
                            ZipEntry zipEntry = zipFile.getEntry("META-INF/MANIFEST.MF");
                            if (zipEntry == null) {
                                this.log("Updating jar since the current jar has no manifest", 3);
                                bl2 = false;
                                Object var6_9 = null;
                                if (zipFile == null) return bl2;
                                break block13;
                            }
                            Manifest manifest = new Manifest(zipFile.getInputStream(zipEntry));
                            if (this.manifest == null) {
                                this.manifest = this.getDefaultManifest();
                            }
                            if (manifest.equals(this.manifest)) break block14;
                            this.log("Updating jar since jar manifest has changed", 3);
                            bl = false;
                            break block15;
                        }
                        catch (Exception exception) {
                            this.log("Updating jar since cannot read current jar manifest: " + exception.getClass().getName() + exception.getMessage(), 3);
                            boolean bl3 = false;
                            Object var6_11 = null;
                            if (zipFile == null) return bl3;
                            try {
                                zipFile.close();
                                return bl3;
                            }
                            catch (IOException iOException) {}
                            return bl3;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_13 = null;
                        if (zipFile == null) throw throwable;
                        try {}
                        catch (IOException iOException) {}
                        zipFile.close();
                        throw throwable;
                        throw throwable;
                    }
                }
                try {}
                catch (IOException iOException) {}
                zipFile.close();
                return bl2;
            }
            Object var6_10 = null;
            if (zipFile == null) return bl;
            try {}
            catch (IOException iOException) {}
            zipFile.close();
            return bl;
        }
        Object var6_12 = null;
        if (zipFile == null) return super.isUpToDate(fileScannerArray, file);
        try {}
        catch (IOException iOException) {
            return super.isUpToDate(fileScannerArray, file);
        }
        zipFile.close();
        return super.isUpToDate(fileScannerArray, file);
    }

    public void setJarfile(File file) {
        super.setZipfile(file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setManifest(File file) {
        if (!file.exists()) {
            throw new BuildException("Manifest file: " + file + " does not exist.", this.getLocation());
        }
        this.manifestFile = file;
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                Manifest manifest = new Manifest(fileInputStream);
                if (this.manifest == null) {
                    this.manifest = this.getDefaultManifest();
                }
                this.manifest.merge(manifest);
            }
            catch (ManifestException manifestException) {
                this.log("Manifest is invalid: " + manifestException.getMessage(), 0);
                throw new BuildException("Invalid Manifest: " + file, manifestException, this.getLocation());
            }
            catch (IOException iOException) {
                throw new BuildException("Unable to read manifest file: " + file, iOException);
            }
            Object var4_6 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            if (fileInputStream == null) throw throwable;
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)fileInputStream).close();
            return;
        }
        catch (IOException iOException) {}
    }

    protected void zipFile(File file, ZipOutputStream zipOutputStream, String string) throws IOException {
        if (string.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
            this.log("Warning: selected " + this.archiveType + " files include a META-INF/MANIFEST.MF which will be ignored " + "(please use manifest attribute to " + this.archiveType + " task)", 1);
        } else {
            super.zipFile(file, zipOutputStream, string);
        }
    }

    protected void zipFile(InputStream inputStream, ZipOutputStream zipOutputStream, String string, long l) throws IOException {
        if (string.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
            try {
                this.zipManifestEntry(inputStream);
            }
            catch (IOException iOException) {
                throw new BuildException("Unable to read manifest file: ", iOException);
            }
        } else {
            super.zipFile(inputStream, zipOutputStream, string, l);
        }
    }

    private void zipManifestEntry(InputStream inputStream) throws IOException {
        try {
            if (this.execManifest == null) {
                this.execManifest = new Manifest(inputStream);
            } else if (this.isAddingNewFiles()) {
                this.execManifest.merge(new Manifest(inputStream));
            }
        }
        catch (ManifestException manifestException) {
            this.log("Manifest is invalid: " + manifestException.getMessage(), 0);
            throw new BuildException("Invalid Manifest", manifestException, this.getLocation());
        }
    }
}

