/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapterFactory;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class Javac
extends MatchingTask {
    private static final String FAIL_MSG = "Compile failed, messages should have been provided.";
    private Path src;
    private File destDir;
    private Path compileClasspath;
    private String encoding;
    private boolean debug = false;
    private boolean optimize = false;
    private boolean deprecation = false;
    private boolean depend = false;
    private boolean verbose = false;
    private String target;
    private Path bootclasspath;
    private Path extdirs;
    private boolean includeAntRuntime = true;
    private boolean includeJavaRuntime = false;
    private boolean fork = false;
    private boolean nowarn = false;
    private String memoryInitialSize;
    private String memoryMaximumSize;
    protected boolean failOnError = true;
    protected File[] compileList = new File[0];
    private String source;

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(this.project);
        }
        return this.bootclasspath.createPath();
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.project);
        }
        return this.compileClasspath.createPath();
    }

    public Path createExtdirs() {
        if (this.extdirs == null) {
            this.extdirs = new Path(this.project);
        }
        return this.extdirs.createPath();
    }

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.project);
        }
        return this.src.createPath();
    }

    public void execute() throws BuildException {
        Object object;
        Object object2;
        if (this.src == null) {
            throw new BuildException("srcdir attribute must be set!", this.location);
        }
        String[] stringArray = this.src.list();
        if (stringArray.length == 0) {
            throw new BuildException("srcdir attribute must be set!", this.location);
        }
        if (this.destDir != null && !this.destDir.isDirectory()) {
            throw new BuildException("destination directory \"" + this.destDir + "\" does not exist or is not a directory", this.location);
        }
        this.resetFileLists();
        int n = 0;
        while (n < stringArray.length) {
            object2 = this.project.resolveFile(stringArray[n]);
            if (!((File)object2).exists()) {
                throw new BuildException("srcdir \"" + ((File)object2).getPath() + "\" does not exist!", this.location);
            }
            object = this.getDirectoryScanner((File)object2);
            String[] stringArray2 = ((DirectoryScanner)object).getIncludedFiles();
            this.scanDir((File)object2, (File)(this.destDir != null ? this.destDir : object2), stringArray2);
            ++n;
        }
        object2 = this.project.getProperty("build.compiler");
        if (this.fork) {
            if (object2 != null) {
                if (this.isJdkCompiler((String)object2)) {
                    this.log("Since fork is true, ignoring build.compiler setting.", 1);
                    object2 = "extJavac";
                } else {
                    this.log("Since build.compiler setting isn't classic or modern, ignoring fork setting.", 1);
                }
            } else {
                object2 = "extJavac";
            }
        }
        if (object2 == null) {
            object2 = Project.getJavaVersion() != "1.1" && Project.getJavaVersion() != "1.2" ? "modern" : "classic";
        }
        if (this.compileList.length > 0) {
            object = CompilerAdapterFactory.getCompiler((String)object2, this);
            this.log("Compiling " + this.compileList.length + " source file" + (this.compileList.length == 1 ? "" : "s") + (this.destDir != null ? " to " + this.destDir : ""));
            object.setJavac(this);
            if (!object.execute()) {
                if (this.failOnError) {
                    throw new BuildException(FAIL_MSG, this.location);
                }
                this.log(FAIL_MSG, 0);
            }
        }
    }

    public Path getBootclasspath() {
        return this.bootclasspath;
    }

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public boolean getDepend() {
        return this.depend;
    }

    public boolean getDeprecation() {
        return this.deprecation;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Path getExtdirs() {
        return this.extdirs;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public File[] getFileList() {
        return this.compileList;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    public String getMemoryInitialSize() {
        return this.memoryInitialSize;
    }

    public String getMemoryMaximumSize() {
        return this.memoryMaximumSize;
    }

    public boolean getNowarn() {
        return this.nowarn;
    }

    public boolean getOptimize() {
        return this.optimize;
    }

    public String getSource() {
        return this.source;
    }

    public Path getSrcdir() {
        return this.src;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public boolean isForkedJavac() {
        return this.fork || "extJavac".equals(this.project.getProperty("build.compiler"));
    }

    protected boolean isJdkCompiler(String string) {
        return "modern".equals(string) || "classic".equals(string) || "javac1.1".equals(string) || "javac1.2".equals(string) || "javac1.3".equals(string) || "javac1.4".equals(string);
    }

    protected void resetFileLists() {
        this.compileList = new File[0];
    }

    protected void scanDir(File file, File file2, String[] stringArray) {
        GlobPatternMapper globPatternMapper = new GlobPatternMapper();
        globPatternMapper.setFrom("*.java");
        globPatternMapper.setTo("*.class");
        SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
        File[] fileArray = sourceFileScanner.restrictAsFiles(stringArray, file, file2, globPatternMapper);
        if (fileArray.length > 0) {
            File[] fileArray2 = new File[this.compileList.length + fileArray.length];
            System.arraycopy(this.compileList, 0, fileArray2, 0, this.compileList.length);
            System.arraycopy(fileArray, 0, fileArray2, this.compileList.length, fileArray.length);
            this.compileList = fileArray2;
        }
    }

    public void setBootClasspathRef(Reference reference) {
        this.createBootclasspath().setRefid(reference);
    }

    public void setBootclasspath(Path path) {
        if (this.bootclasspath == null) {
            this.bootclasspath = path;
        } else {
            this.bootclasspath.append(path);
        }
    }

    public void setClasspath(Path path) {
        if (this.compileClasspath == null) {
            this.compileClasspath = path;
        } else {
            this.compileClasspath.append(path);
        }
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setDepend(boolean bl) {
        this.depend = bl;
    }

    public void setDeprecation(boolean bl) {
        this.deprecation = bl;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setExtdirs(Path path) {
        if (this.extdirs == null) {
            this.extdirs = path;
        } else {
            this.extdirs.append(path);
        }
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    public void setFork(boolean bl) {
        this.fork = bl;
    }

    public void setIncludeantruntime(boolean bl) {
        this.includeAntRuntime = bl;
    }

    public void setIncludejavaruntime(boolean bl) {
        this.includeJavaRuntime = bl;
    }

    public void setMemoryInitialSize(String string) {
        this.memoryInitialSize = string;
    }

    public void setMemoryMaximumSize(String string) {
        this.memoryMaximumSize = string;
    }

    public void setNowarn(boolean bl) {
        this.nowarn = bl;
    }

    public void setOptimize(boolean bl) {
        this.optimize = bl;
    }

    public void setProceed(boolean bl) {
        this.failOnError = bl ^ true;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public void setSrcdir(Path path) {
        if (this.src == null) {
            this.src = path;
        } else {
            this.src.append(path);
        }
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }
}

