/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public class Parallel
extends Task
implements TaskContainer {
    private Vector nestedTasks = new Vector();

    public void addTask(Task task) throws BuildException {
        this.nestedTasks.addElement(task);
    }

    public void execute() throws BuildException {
        TaskThread[] taskThreadArray = new TaskThread[this.nestedTasks.size()];
        int n = 0;
        Enumeration enumeration = this.nestedTasks.elements();
        while (enumeration.hasMoreElements()) {
            Task task = (Task)enumeration.nextElement();
            taskThreadArray[n] = new TaskThread(n, task);
            ++n;
        }
        int n2 = 0;
        while (n2 < taskThreadArray.length) {
            taskThreadArray[n2].start();
            ++n2;
        }
        int n3 = 0;
        while (n3 < taskThreadArray.length) {
            try {
                taskThreadArray[n3].join();
            }
            catch (InterruptedException interruptedException) {}
            ++n3;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        int n4 = 0;
        Throwable throwable = null;
        Location location = Location.UNKNOWN_LOCATION;
        int n5 = 0;
        while (n5 < taskThreadArray.length) {
            Throwable throwable2 = taskThreadArray[n5].getException();
            if (throwable2 != null) {
                ++n4;
                if (throwable == null) {
                    throwable = throwable2;
                }
                if (throwable2 instanceof BuildException && location == Location.UNKNOWN_LOCATION) {
                    location = ((BuildException)throwable2).getLocation();
                }
                stringBuffer.append(string);
                stringBuffer.append(throwable2.getMessage());
            }
            ++n5;
        }
        if (n4 == 1) {
            if (throwable instanceof BuildException) {
                throw (BuildException)throwable;
            }
            throw new BuildException(throwable);
        }
        if (n4 > 1) {
            throw new BuildException(stringBuffer.toString(), location);
        }
    }

    class TaskThread
    extends Thread {
        private Throwable exception;
        private Task task;
        private int taskNumber;

        TaskThread(int n, Task task) {
            this.task = task;
            this.taskNumber = n;
        }

        public Throwable getException() {
            return this.exception;
        }

        public void run() {
            try {
                this.task.perform();
            }
            catch (Throwable throwable) {
                this.exception = throwable;
            }
        }
    }
}

