/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class SQLExec
extends Task {
    private int goodSql = 0;
    private int totalSql = 0;
    private Path classpath;
    private AntClassLoader loader;
    private Vector filesets = new Vector();
    private Connection conn = null;
    private boolean autocommit = false;
    private Statement statement = null;
    private String driver = null;
    private String url = null;
    private String userId = null;
    private String password = null;
    private File srcFile = null;
    private String sqlCommand = "";
    private Vector transactions = new Vector();
    private String delimiter = ";";
    private String delimiterType = "normal";
    private boolean print = false;
    private boolean showheaders = true;
    private File output = null;
    private String rdbms = null;
    private String version = null;
    private String onError = "abort";

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void addText(String string) {
        this.sqlCommand = String.valueOf(this.sqlCommand) + string;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public Transaction createTransaction() {
        Transaction transaction = new Transaction();
        this.transactions.addElement(transaction);
        return transaction;
    }

    protected void execSQL(String string, PrintStream printStream) throws SQLException {
        if ("".equals(string.trim())) {
            return;
        }
        try {
            ++this.totalSql;
            if (!this.statement.execute(string)) {
                this.log(String.valueOf(this.statement.getUpdateCount()) + " rows affected", 3);
            } else if (this.print) {
                this.printResults(printStream);
            }
            SQLWarning sQLWarning = this.conn.getWarnings();
            while (sQLWarning != null) {
                this.log(String.valueOf(String.valueOf(sQLWarning)) + " sql warning", 3);
                sQLWarning = sQLWarning.getNextWarning();
            }
            this.conn.clearWarnings();
            ++this.goodSql;
        }
        catch (SQLException sQLException) {
            this.log("Failed to execute: " + string, 0);
            if (!this.onError.equals("continue")) {
                throw sQLException;
            }
            this.log(sQLException.toString(), 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        DirectoryScanner directoryScanner;
        block44: {
            block43: {
                Transaction transaction;
                Object object;
                Serializable serializable;
                Class<?> clazz;
                this.sqlCommand = this.sqlCommand.trim();
                if (this.srcFile == null && this.sqlCommand.length() == 0 && this.filesets.isEmpty()) {
                    if (this.transactions.size() == 0) {
                        throw new BuildException("Source file or fileset, transactions or sql statement must be set!", this.location);
                    }
                } else {
                    int n = 0;
                    block20: while (true) {
                        if (n >= this.filesets.size()) {
                            clazz = this.createTransaction();
                            ((Transaction)((Object)clazz)).setSrc(this.srcFile);
                            ((Transaction)((Object)clazz)).addText(this.sqlCommand);
                            break;
                        }
                        clazz = (FileSet)this.filesets.elementAt(n);
                        directoryScanner = ((FileSet)((Object)clazz)).getDirectoryScanner(this.project);
                        serializable = ((FileSet)((Object)clazz)).getDir(this.project);
                        object = directoryScanner.getIncludedFiles();
                        int n2 = 0;
                        while (true) {
                            if (n2 >= ((String[])object).length) {
                                ++n;
                                continue block20;
                            }
                            transaction = this.createTransaction();
                            transaction.setSrc(new File((File)serializable, object[n2]));
                            ++n2;
                        }
                        break;
                    }
                }
                if (this.driver == null) {
                    throw new BuildException("Driver attribute must be set!", this.location);
                }
                if (this.userId == null) {
                    throw new BuildException("User Id attribute must be set!", this.location);
                }
                if (this.password == null) {
                    throw new BuildException("Password attribute must be set!", this.location);
                }
                if (this.url == null) {
                    throw new BuildException("Url attribute must be set!", this.location);
                }
                if (this.srcFile != null && !this.srcFile.exists()) {
                    throw new BuildException("Source file does not exist!", this.location);
                }
                Driver driver = null;
                try {
                    if (this.classpath != null) {
                        this.log("Loading " + this.driver + " using AntClassLoader with classpath " + this.classpath, 3);
                        this.loader = new AntClassLoader(this.project, this.classpath);
                        clazz = this.loader.loadClass(this.driver);
                    } else {
                        this.log("Loading " + this.driver + " using system loader.", 3);
                        clazz = Class.forName(this.driver);
                    }
                    driver = (Driver)clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new BuildException("Class Not Found: JDBC driver " + this.driver + " could not be loaded", this.location);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new BuildException("Illegal Access: JDBC driver " + this.driver + " could not be loaded", this.location);
                }
                catch (InstantiationException instantiationException) {
                    throw new BuildException("Instantiation Exception: JDBC driver " + this.driver + " could not be loaded", this.location);
                }
                try {
                    try {
                        this.log("connecting to " + this.url, 3);
                        serializable = new Properties();
                        ((Hashtable)serializable).put("user", this.userId);
                        ((Hashtable)serializable).put("password", this.password);
                        this.conn = driver.connect(this.url, (Properties)serializable);
                        if (this.conn == null) {
                            throw new SQLException("No suitable Driver for " + this.url);
                        }
                        if (!this.isValidRdbms(this.conn)) {
                            directoryScanner = null;
                            break block43;
                        }
                        this.conn.setAutoCommit(this.autocommit);
                        this.statement = this.conn.createStatement();
                        object = System.out;
                        try {
                            if (this.output != null) {
                                this.log("Opening PrintStream to output file " + this.output, 3);
                                object = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.output)));
                            }
                            Enumeration enumeration = this.transactions.elements();
                            while (enumeration.hasMoreElements()) {
                                ((Transaction)enumeration.nextElement()).runTransaction((PrintStream)object);
                                if (this.autocommit) continue;
                                this.log("Commiting transaction", 3);
                                this.conn.commit();
                            }
                            break block44;
                        }
                        finally {
                            transaction = null;
                            if (object != null && object != System.out) {
                                ((PrintStream)object).close();
                            }
                        }
                    }
                    catch (IOException iOException) {
                        if (this.autocommit) throw new BuildException(iOException, this.location);
                        if (this.conn == null) throw new BuildException(iOException, this.location);
                        if (!this.onError.equals("abort")) throw new BuildException(iOException, this.location);
                        try {
                            this.conn.rollback();
                            throw new BuildException(iOException, this.location);
                        }
                        catch (SQLException sQLException) {}
                        throw new BuildException(iOException, this.location);
                    }
                    catch (SQLException sQLException) {
                        if (this.autocommit) throw new BuildException(sQLException, this.location);
                        if (this.conn == null) throw new BuildException(sQLException, this.location);
                        if (!this.onError.equals("abort")) throw new BuildException(sQLException, this.location);
                        try {
                            this.conn.rollback();
                            throw new BuildException(sQLException, this.location);
                        }
                        catch (SQLException sQLException2) {}
                        throw new BuildException(sQLException, this.location);
                    }
                }
                catch (Throwable throwable) {
                    directoryScanner = null;
                    try {
                        if (this.statement != null) {
                            this.statement.close();
                        }
                        if (this.conn == null) throw throwable;
                        this.conn.close();
                        throw throwable;
                    }
                    catch (SQLException sQLException) {}
                    throw throwable;
                }
            }
            try {}
            catch (SQLException sQLException) {}
            if (this.statement != null) {
                this.statement.close();
            }
            if (this.conn == null) return;
            this.conn.close();
            return;
        }
        directoryScanner = null;
        try {}
        catch (SQLException sQLException) {}
        if (this.statement != null) {
            this.statement.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
        this.log(String.valueOf(this.goodSql) + " of " + this.totalSql + " SQL statements executed successfully");
    }

    protected boolean isValidRdbms(Connection connection) {
        if (this.rdbms == null && this.version == null) {
            return true;
        }
        try {
            String string;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (this.rdbms != null) {
                string = databaseMetaData.getDatabaseProductName().toLowerCase();
                this.log("RDBMS = " + string, 3);
                if (string == null || string.indexOf(this.rdbms) < 0) {
                    this.log("Not the required RDBMS: " + this.rdbms, 3);
                    return false;
                }
            }
            if (this.version != null) {
                string = databaseMetaData.getDatabaseProductVersion().toLowerCase();
                this.log("Version = " + string, 3);
                if (string == null || !string.startsWith(this.version) && string.indexOf(" " + this.version) < 0) {
                    this.log("Not the required version: \"" + this.version + "\"", 3);
                    return false;
                }
            }
        }
        catch (SQLException sQLException) {
            this.log("Failed to obtain required RDBMS information", 0);
            return false;
        }
        return true;
    }

    protected void printResults(PrintStream printStream) throws SQLException {
        ResultSet resultSet = null;
        do {
            int n;
            if ((resultSet = this.statement.getResultSet()) == null) continue;
            this.log("Processing new result set.", 3);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            StringBuffer stringBuffer = new StringBuffer();
            if (this.showheaders) {
                n = 1;
                while (n < n2) {
                    stringBuffer.append(resultSetMetaData.getColumnName(n));
                    stringBuffer.append(",");
                    ++n;
                }
                stringBuffer.append(resultSetMetaData.getColumnName(n2));
                printStream.println(stringBuffer);
                stringBuffer.setLength(0);
            }
            while (resultSet.next()) {
                n = 1;
                int n3 = 1;
                while (n3 <= n2) {
                    String string = resultSet.getString(n3);
                    if (string != null) {
                        string = string.trim();
                    }
                    if (n != 0) {
                        n = 0;
                    } else {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(string);
                    ++n3;
                }
                printStream.println(stringBuffer);
                stringBuffer.setLength(0);
            }
        } while (this.statement.getMoreResults());
        printStream.println();
    }

    protected void runStatements(Reader reader, PrintStream printStream) throws SQLException, IOException {
        String string = "";
        String string2 = "";
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string2 = bufferedReader.readLine()) != null) {
            String string3;
            StringTokenizer stringTokenizer;
            string2 = string2.trim();
            if ((string2 = ProjectHelper.replaceProperties(this.project, string2, this.project.getProperties())).startsWith("//") || string2.startsWith("--") || (stringTokenizer = new StringTokenizer(string2)).hasMoreTokens() && "REM".equalsIgnoreCase(string3 = stringTokenizer.nextToken())) continue;
            string = String.valueOf(string) + " " + string2;
            string = string.trim();
            if (string2.indexOf("--") >= 0) {
                string = String.valueOf(string) + "\n";
            }
            if ((!this.delimiterType.equals("normal") || !string.endsWith(this.delimiter)) && (!this.delimiterType.equals("row") || !string2.equals(this.delimiter))) continue;
            this.log("SQL: " + string, 3);
            this.execSQL(string.substring(0, string.length() - this.delimiter.length()), printStream);
            string = "";
        }
        if (!string.equals("")) {
            this.execSQL(string, printStream);
        }
    }

    public void setAutocommit(boolean bl) {
        this.autocommit = bl;
    }

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public void setDelimiterType(DelimiterType delimiterType) {
        this.delimiterType = delimiterType.getValue();
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public void setOnerror(OnError onError) {
        this.onError = onError.getValue();
    }

    public void setOutput(File file) {
        this.output = file;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setPrint(boolean bl) {
        this.print = bl;
    }

    public void setRdbms(String string) {
        this.rdbms = string.toLowerCase();
    }

    public void setShowheaders(boolean bl) {
        this.showheaders = bl;
    }

    public void setSrc(File file) {
        this.srcFile = file;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setUserid(String string) {
        this.userId = string;
    }

    public void setVersion(String string) {
        this.version = string.toLowerCase();
    }

    public static class DelimiterType
    extends EnumeratedAttribute {
        public static final String NORMAL = "normal";
        public static final String ROW = "row";

        public String[] getValues() {
            return new String[]{NORMAL, ROW};
        }
    }

    public static class OnError
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"continue", "stop", "abort"};
        }
    }

    public class Transaction {
        private File tSrcFile = null;
        private String tSqlCommand = "";

        public void addText(String string) {
            this.tSqlCommand = String.valueOf(this.tSqlCommand) + string;
        }

        private void runTransaction(PrintStream printStream) throws IOException, SQLException {
            if (this.tSqlCommand.length() != 0) {
                SQLExec.this.log("Executing commands", 2);
                SQLExec.this.runStatements(new StringReader(this.tSqlCommand), printStream);
            }
            if (this.tSrcFile != null) {
                SQLExec.this.log("Executing file: " + this.tSrcFile.getAbsolutePath(), 2);
                FileReader fileReader = new FileReader(this.tSrcFile);
                SQLExec.this.runStatements(fileReader, printStream);
                fileReader.close();
            }
        }

        public void setSrc(File file) {
            this.tSrcFile = file;
        }
    }
}

