/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.FileSet;

public class SignJar
extends Task {
    protected String jar;
    protected String alias;
    protected String keystore;
    protected String storepass;
    protected String storetype;
    protected String keypass;
    protected String sigfile;
    protected String signedjar;
    protected boolean verbose;
    protected boolean internalsf;
    protected boolean sectionsonly;
    protected Vector filesets = new Vector();
    protected boolean lazy;

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    private void doOneJar(String string, String string2) throws BuildException {
        if (Project.getJavaVersion().equals("1.1")) {
            throw new BuildException("The signjar task is only available on JDK versions 1.2 or greater");
        }
        if (this.alias == null) {
            throw new BuildException("alias attribute must be set");
        }
        if (this.storepass == null) {
            throw new BuildException("storepass attribute must be set");
        }
        if (this.isUpToDate(string, string2)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        ExecTask execTask = (ExecTask)this.project.createTask("exec");
        execTask.setExecutable("jarsigner");
        if (this.keystore != null) {
            execTask.createArg().setValue("-keystore");
            execTask.createArg().setValue(this.keystore);
        }
        if (this.storepass != null) {
            execTask.createArg().setValue("-storepass");
            execTask.createArg().setValue(this.storepass);
        }
        if (this.storetype != null) {
            execTask.createArg().setValue("-storetype");
            execTask.createArg().setValue(this.storetype);
        }
        if (this.keypass != null) {
            execTask.createArg().setValue("-keypass");
            execTask.createArg().setValue(this.keypass);
        }
        if (this.sigfile != null) {
            execTask.createArg().setValue("-sigfile");
            execTask.createArg().setValue(this.sigfile);
        }
        if (string2 != null) {
            execTask.createArg().setValue("-signedjar");
            execTask.createArg().setValue(string2);
        }
        if (this.verbose) {
            execTask.createArg().setValue("-verbose");
        }
        if (this.internalsf) {
            execTask.createArg().setValue("-internalsf");
        }
        if (this.sectionsonly) {
            execTask.createArg().setValue("-sectionsonly");
        }
        execTask.createArg().setValue(string);
        execTask.createArg().setValue(this.alias);
        this.log("Signing Jar : " + new File(string).getAbsolutePath());
        execTask.setFailonerror(true);
        execTask.setTaskName(this.getTaskName());
        execTask.execute();
    }

    public void execute() throws BuildException {
        if (this.jar == null && this.filesets == null) {
            throw new BuildException("jar must be set through jar attribute or nested filesets");
        }
        if (this.jar != null) {
            this.doOneJar(this.jar, this.signedjar);
            return;
        }
        int n = 0;
        while (n < this.filesets.size()) {
            FileSet fileSet = (FileSet)this.filesets.elementAt(n);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
            String[] stringArray = directoryScanner.getIncludedFiles();
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.doOneJar(stringArray[n2], null);
                ++n2;
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isSigned(String string) {
        boolean bl;
        String string2 = "META-INF/";
        String string3 = ".SF";
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(file);
                if (this.alias == null) {
                    block13: {
                        String string4;
                        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                        do {
                            if (!enumeration.hasMoreElements()) break block13;
                        } while (!(string4 = enumeration.nextElement().getName()).startsWith("META-INF/") || !string4.endsWith(".SF"));
                        boolean bl2 = true;
                        Object var8_12 = null;
                        if (zipFile == null) return bl2;
                        try {
                            zipFile.close();
                            return bl2;
                        }
                        catch (IOException iOException) {}
                        return bl2;
                    }
                    boolean bl3 = false;
                    Object var8_13 = null;
                    if (zipFile == null) return bl3;
                    try {}
                    catch (IOException iOException) {}
                    zipFile.close();
                    return bl3;
                }
                bl = zipFile.getEntry("META-INF/" + this.alias.toUpperCase() + ".SF") != null;
            }
            catch (IOException iOException) {
                boolean bl4 = false;
                Object var8_15 = null;
                if (zipFile == null) return bl4;
                try {}
                catch (IOException iOException2) {}
                zipFile.close();
                return bl4;
            }
        }
        catch (Throwable throwable) {
            Object var8_16 = null;
            if (zipFile == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            zipFile.close();
            throw throwable;
        }
        Object var8_14 = null;
        if (zipFile == null) return bl;
        try {}
        catch (IOException iOException) {}
        zipFile.close();
        return bl;
    }

    protected boolean isUpToDate(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (string2 != null) {
            File file = new File(string);
            File file2 = new File(string2);
            if (!file.exists()) {
                return false;
            }
            if (!file2.exists()) {
                return false;
            }
            if (file.equals(file2)) {
                return false;
            }
            if (file2.lastModified() > file.lastModified()) {
                return true;
            }
        } else if (this.lazy) {
            return this.isSigned(string);
        }
        return false;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public void setInternalsf(boolean bl) {
        this.internalsf = bl;
    }

    public void setJar(String string) {
        this.jar = string;
    }

    public void setKeypass(String string) {
        this.keypass = string;
    }

    public void setKeystore(String string) {
        this.keystore = string;
    }

    public void setLazy(boolean bl) {
        this.lazy = bl;
    }

    public void setSectionsonly(boolean bl) {
        this.sectionsonly = bl;
    }

    public void setSigfile(String string) {
        this.sigfile = string;
    }

    public void setSignedjar(String string) {
        this.signedjar = string;
    }

    public void setStorepass(String string) {
        this.storepass = string;
    }

    public void setStoretype(String string) {
        this.storetype = string;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }
}

