/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;

public class Tar
extends MatchingTask {
    public static final String WARN = "warn";
    public static final String FAIL = "fail";
    public static final String TRUNCATE = "truncate";
    public static final String GNU = "gnu";
    public static final String OMIT = "omit";
    private String[] validModes = new String[]{"warn", "fail", "truncate", "gnu", "omit"};
    File tarFile;
    File baseDir;
    String longFileMode = "warn";
    Vector filesets = new Vector();
    Vector fileSetFiles = new Vector();
    private boolean longWarningGiven = false;

    protected boolean archiveIsUpToDate(String[] stringArray) {
        SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
        MergingMapper mergingMapper = new MergingMapper();
        mergingMapper.setTo(this.tarFile.getAbsolutePath());
        return sourceFileScanner.restrict(stringArray, this.baseDir, null, mergingMapper).length == 0;
    }

    public TarFileSet createTarFileSet() {
        TarFileSet tarFileSet = new TarFileSet();
        this.filesets.addElement(tarFileSet);
        return tarFileSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        Object object;
        if (this.tarFile == null) {
            throw new BuildException("tarfile attribute must be set!", this.location);
        }
        if (this.tarFile.exists() && this.tarFile.isDirectory()) {
            throw new BuildException("tarfile is a directory!", this.location);
        }
        if (this.tarFile.exists() && !this.tarFile.canWrite()) {
            throw new BuildException("Can not write to the specified tarfile!", this.location);
        }
        if (this.baseDir != null) {
            if (!this.baseDir.exists()) {
                throw new BuildException("basedir does not exist!", this.location);
            }
            TarFileSet tarFileSet = new TarFileSet(this.fileset);
            tarFileSet.setDir(this.baseDir);
            this.filesets.addElement(tarFileSet);
        }
        if (this.filesets.size() == 0) {
            throw new BuildException("You must supply either a basdir attribute or some nested filesets.", this.location);
        }
        boolean bl = true;
        Enumeration enumeration = this.filesets.elements();
        while (enumeration.hasMoreElements()) {
            object = (TarFileSet)enumeration.nextElement();
            String[] stringArray = ((TarFileSet)object).getFiles(this.project);
            if (!this.archiveIsUpToDate(stringArray)) {
                bl = false;
            }
            int n = 0;
            while (n < stringArray.length) {
                if (this.tarFile.equals(new File(((FileSet)object).getDir(this.project), stringArray[n]))) {
                    throw new BuildException("A tar file cannot include itself", this.location);
                }
                ++n;
            }
        }
        if (bl) {
            this.log("Nothing to do: " + this.tarFile.getAbsolutePath() + " is up to date.", 2);
            return;
        }
        this.log("Building tar: " + this.tarFile.getAbsolutePath(), 2);
        object = null;
        try {
            try {
                object = new TarOutputStream(new FileOutputStream(this.tarFile));
                ((TarOutputStream)object).setDebug(true);
                if (this.longFileMode.equalsIgnoreCase(TRUNCATE)) {
                    ((TarOutputStream)object).setLongFileMode(1);
                } else if (this.longFileMode.equalsIgnoreCase(FAIL) || this.longFileMode.equalsIgnoreCase(OMIT)) {
                    ((TarOutputStream)object).setLongFileMode(0);
                } else {
                    ((TarOutputStream)object).setLongFileMode(2);
                }
                this.longWarningGiven = false;
                Enumeration enumeration2 = this.filesets.elements();
                while (enumeration2.hasMoreElements()) {
                    TarFileSet tarFileSet = (TarFileSet)enumeration2.nextElement();
                    String[] stringArray = tarFileSet.getFiles(this.project);
                    int n = 0;
                    while (n < stringArray.length) {
                        File file = new File(tarFileSet.getDir(this.project), stringArray[n]);
                        String string = stringArray[n].replace(File.separatorChar, '/');
                        this.tarFile(file, (TarOutputStream)object, string, tarFileSet);
                        ++n;
                    }
                }
            }
            catch (IOException iOException) {
                String string = "Problem creating TAR: " + iOException.getMessage();
                throw new BuildException(string, iOException, this.location);
            }
            Object var5_8 = null;
            if (object == null) return;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (object == null) throw throwable;
            try {
                ((TarOutputStream)object).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((TarOutputStream)object).close();
            return;
        }
        catch (IOException iOException) {}
    }

    public void setBasedir(File file) {
        this.baseDir = file;
    }

    public void setLongfile(String string) {
        int n = 0;
        while (n < this.validModes.length) {
            if (string.equalsIgnoreCase(this.validModes[n])) {
                this.longFileMode = string;
                return;
            }
            ++n;
        }
        throw new BuildException("The longfile value " + string + " is not a valid value");
    }

    public void setTarfile(File file) {
        this.tarFile = file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void tarFile(File file, TarOutputStream tarOutputStream, String string, TarFileSet tarFileSet) throws IOException {
        FileInputStream fileInputStream;
        block14: {
            block13: {
                fileInputStream = null;
                if (string.length() <= 0) {
                    return;
                }
                if (file.isDirectory() && !string.endsWith("/")) {
                    string = String.valueOf(string) + "/";
                }
                try {
                    if (string.length() >= 100) {
                        if (this.longFileMode.equalsIgnoreCase(OMIT)) {
                            this.log("Omitting: " + string, 2);
                            Object var7_6 = null;
                            if (fileInputStream == null) return;
                            break block13;
                        }
                        if (this.longFileMode.equalsIgnoreCase(WARN)) {
                            this.log("Entry: " + string + " longer than " + 100 + " characters.", 1);
                            if (!this.longWarningGiven) {
                                this.log("Resulting tar file can only be processed successfully by GNU compatible tar commands", 1);
                                this.longWarningGiven = true;
                            }
                        } else if (this.longFileMode.equalsIgnoreCase(FAIL)) {
                            throw new BuildException("Entry: " + string + " longer than " + 100 + "characters.", this.location);
                        }
                    }
                    TarEntry tarEntry = new TarEntry(string);
                    tarEntry.setModTime(file.lastModified());
                    if (!file.isDirectory()) {
                        tarEntry.setSize(file.length());
                        tarEntry.setMode(tarFileSet.getMode());
                    }
                    tarEntry.setUserName(tarFileSet.getUserName());
                    tarEntry.setGroupName(tarFileSet.getGroup());
                    tarOutputStream.putNextEntry(tarEntry);
                    if (!file.isDirectory()) {
                        fileInputStream = new FileInputStream(file);
                        byte[] byArray = new byte[8192];
                        int n = 0;
                        do {
                            tarOutputStream.write(byArray, 0, n);
                        } while ((n = fileInputStream.read(byArray, 0, byArray.length)) != -1);
                    }
                    tarOutputStream.closeEntry();
                    break block14;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (fileInputStream == null) throw throwable;
                    fileInputStream.close();
                    throw throwable;
                }
            }
            fileInputStream.close();
            return;
        }
        Object var7_7 = null;
        if (fileInputStream == null) return;
        fileInputStream.close();
    }

    public static class TarFileSet
    extends FileSet {
        private String[] files = null;
        private int mode = 33188;
        private String userName = "";
        private String groupName = "";

        public TarFileSet() {
        }

        public TarFileSet(FileSet fileSet) {
            super(fileSet);
        }

        public String[] getFiles(Project project) {
            if (this.files == null) {
                DirectoryScanner directoryScanner = this.getDirectoryScanner(project);
                String[] stringArray = directoryScanner.getIncludedDirectories();
                String[] stringArray2 = directoryScanner.getIncludedFiles();
                this.files = new String[stringArray.length + stringArray2.length];
                System.arraycopy(stringArray, 0, this.files, 0, stringArray.length);
                System.arraycopy(stringArray2, 0, this.files, stringArray.length, stringArray2.length);
            }
            return this.files;
        }

        public String getGroup() {
            return this.groupName;
        }

        public int getMode() {
            return this.mode;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setGroup(String string) {
            this.groupName = string;
        }

        public void setMode(String string) {
            this.mode = 0x8000 | Integer.parseInt(string, 8);
        }

        public void setUserName(String string) {
            this.userName = string;
        }
    }
}

