/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class Tstamp
extends Task {
    private Vector customFormats = new Vector();

    public CustomFormat createFormat() {
        CustomFormat customFormat = new CustomFormat();
        this.customFormats.addElement(customFormat);
        return customFormat;
    }

    public void execute() throws BuildException {
        try {
            Date date = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
            this.project.setProperty("DSTAMP", simpleDateFormat.format(date));
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HHmm");
            this.project.setProperty("TSTAMP", simpleDateFormat2.format(date));
            SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("MMMM d yyyy", Locale.US);
            this.project.setProperty("TODAY", simpleDateFormat3.format(date));
            Enumeration enumeration = this.customFormats.elements();
            while (enumeration.hasMoreElements()) {
                CustomFormat customFormat = (CustomFormat)enumeration.nextElement();
                customFormat.execute(this.project, date, this.location);
            }
        }
        catch (Exception exception) {
            throw new BuildException(exception);
        }
    }

    public class CustomFormat {
        private String propertyName;
        private String pattern;
        private String language;
        private String country;
        private String variant;
        private int offset = 0;
        private int field = 5;

        public void execute(Project project, Date date, Location location) {
            if (this.propertyName == null) {
                throw new BuildException("property attribute must be provided", location);
            }
            if (this.pattern == null) {
                throw new BuildException("pattern attribute must be provided", location);
            }
            SimpleDateFormat simpleDateFormat = this.language == null ? new SimpleDateFormat(this.pattern) : (this.variant == null ? new SimpleDateFormat(this.pattern, new Locale(this.language, this.country)) : new SimpleDateFormat(this.pattern, new Locale(this.language, this.country, this.variant)));
            if (this.offset != 0) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(this.field, this.offset);
                date = calendar.getTime();
            }
            project.setProperty(this.propertyName, simpleDateFormat.format(date));
        }

        public void setLocale(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f,");
            try {
                this.language = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreElements()) {
                    this.country = stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreElements()) {
                        this.country = stringTokenizer.nextToken();
                        if (stringTokenizer.hasMoreElements()) {
                            throw new BuildException("bad locale format", Tstamp.this.getLocation());
                        }
                    }
                } else {
                    this.country = "";
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new BuildException("bad locale format", noSuchElementException, Tstamp.this.getLocation());
            }
        }

        public void setOffset(int n) {
            this.offset = n;
        }

        public void setPattern(String string) {
            this.pattern = string;
        }

        public void setProperty(String string) {
            this.propertyName = string;
        }

        public void setUnit(String string) {
            if (string.equalsIgnoreCase("millisecond")) {
                this.field = 14;
            } else if (string.equalsIgnoreCase("second")) {
                this.field = 13;
            } else if (string.equalsIgnoreCase("minute")) {
                this.field = 12;
            } else if (string.equalsIgnoreCase("hour")) {
                this.field = 11;
            } else if (string.equalsIgnoreCase("day")) {
                this.field = 5;
            } else if (string.equalsIgnoreCase("week")) {
                this.field = 3;
            } else if (string.equalsIgnoreCase("month")) {
                this.field = 2;
            } else if (string.equalsIgnoreCase("year")) {
                this.field = 1;
            } else {
                throw new BuildException(String.valueOf(string) + " is not a unit supported by the tstamp task", Tstamp.this.getLocation());
            }
        }
    }
}

