/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.XSLTLiaison;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileUtils;

public class XSLTProcess
extends MatchingTask {
    private File destDir = null;
    private File baseDir = null;
    private String xslFile = null;
    private String targetExtension = ".html";
    private Vector params = new Vector();
    private File inFile = null;
    private File outFile = null;
    private String processor;
    private Path classpath = null;
    private XSLTLiaison liaison;
    private boolean stylesheetLoaded = false;
    private boolean force = false;
    private FileUtils fileUtils = FileUtils.newFileUtils();

    protected void configureLiaison(File file) throws BuildException {
        if (this.stylesheetLoaded) {
            return;
        }
        this.stylesheetLoaded = true;
        try {
            this.log("Loading stylesheet " + file, 2);
            this.liaison.setStylesheet(file);
            Enumeration enumeration = this.params.elements();
            while (enumeration.hasMoreElements()) {
                Param param = (Param)enumeration.nextElement();
                this.liaison.addParam(param.getName(), param.getExpression());
            }
        }
        catch (Exception exception) {
            this.log("Failed to read stylesheet " + file, 2);
            throw new BuildException(exception);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public Param createParam() {
        Param param = new Param();
        this.params.addElement(param);
        return param;
    }

    private void ensureDirectoryFor(File file) throws BuildException {
        File file2 = new File(file.getParent());
        if (!file2.exists() && !file2.mkdirs()) {
            throw new BuildException("Unable to create directory: " + file2.getAbsolutePath());
        }
    }

    public void execute() throws BuildException {
        if (this.xslFile == null) {
            throw new BuildException("no stylesheet specified", this.location);
        }
        if (this.baseDir == null) {
            this.baseDir = this.project.resolveFile(".");
        }
        this.liaison = this.getLiaison();
        this.log("Using " + this.liaison.getClass().toString(), 3);
        File file = this.project.resolveFile(this.xslFile);
        if (!file.exists() && (file = this.fileUtils.resolveFile(this.baseDir, this.xslFile)).exists()) {
            this.log("DEPRECATED - the style attribute should be relative to the project's");
            this.log("             basedir, not the tasks's basedir.");
        }
        if (this.inFile != null && this.outFile != null) {
            this.process(this.inFile, this.outFile, file);
            return;
        }
        if (this.destDir == null) {
            String string = "destdir attributes must be set!";
            throw new BuildException(string);
        }
        DirectoryScanner directoryScanner = this.getDirectoryScanner(this.baseDir);
        this.log("Transforming into " + this.destDir, 2);
        String[] stringArray = directoryScanner.getIncludedFiles();
        int n = 0;
        while (n < stringArray.length) {
            this.process(this.baseDir, stringArray[n], this.destDir, file);
            ++n;
        }
        String[] stringArray2 = directoryScanner.getIncludedDirectories();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            stringArray = new File(this.baseDir, stringArray2[n2]).list();
            int n3 = 0;
            while (n3 < stringArray.length) {
                this.process(this.baseDir, stringArray[n3], this.destDir, file);
                ++n3;
            }
            ++n2;
        }
    }

    protected XSLTLiaison getLiaison() {
        if (this.liaison == null) {
            if (this.processor != null) {
                try {
                    this.resolveProcessor(this.processor);
                }
                catch (Exception exception) {
                    throw new BuildException(exception);
                }
            }
            try {
                this.resolveProcessor("trax");
            }
            catch (Throwable throwable) {
                try {
                    this.resolveProcessor("xslp");
                }
                catch (Throwable throwable2) {
                    try {
                        this.resolveProcessor("xalan");
                    }
                    catch (Throwable throwable3) {
                        throwable3.printStackTrace();
                        throwable2.printStackTrace();
                        throw new BuildException(throwable);
                    }
                }
            }
        }
        return this.liaison;
    }

    private Class loadClass(String string) throws Exception {
        if (this.classpath == null) {
            return Class.forName(string);
        }
        AntClassLoader antClassLoader = new AntClassLoader(this.project, this.classpath);
        Class<?> clazz = antClassLoader.loadClass(string);
        AntClassLoader.initializeClass(clazz);
        return clazz;
    }

    private void process(File file, File file2, File file3) throws BuildException {
        try {
            long l = file3.lastModified();
            this.log("In file " + file + " time: " + file.lastModified(), 4);
            this.log("Out file " + file2 + " time: " + file2.lastModified(), 4);
            this.log("Style file " + this.xslFile + " time: " + l, 4);
            if (this.force || file.lastModified() > file2.lastModified() || l > file2.lastModified()) {
                this.ensureDirectoryFor(file2);
                this.log("Processing " + file + " to " + file2, 2);
                this.configureLiaison(file3);
                this.liaison.transform(file, file2);
            }
        }
        catch (Exception exception) {
            this.log("Failed to process " + file, 2);
            if (file2 != null) {
                file2.delete();
            }
            throw new BuildException(exception);
        }
    }

    private void process(File file, String string, File file2, File file3) throws BuildException {
        String string2 = this.targetExtension;
        File file4 = null;
        File file5 = null;
        try {
            long l = file3.lastModified();
            file5 = new File(file, string);
            int n = string.lastIndexOf(46);
            file4 = n > 0 ? new File(file2, String.valueOf(string.substring(0, string.lastIndexOf(46))) + string2) : new File(file2, String.valueOf(string) + string2);
            if (this.force || file5.lastModified() > file4.lastModified() || l > file4.lastModified()) {
                this.ensureDirectoryFor(file4);
                this.log("Transforming into " + file2);
                this.configureLiaison(file3);
                this.liaison.transform(file5, file4);
            }
        }
        catch (Exception exception) {
            this.log("Failed to process " + file5, 2);
            if (file4 != null) {
                file4.delete();
            }
            throw new BuildException(exception);
        }
    }

    private void resolveProcessor(String string) throws Exception {
        if (string.equals("trax")) {
            Class clazz = this.loadClass("org.apache.tools.ant.taskdefs.optional.TraXLiaison");
            this.liaison = (XSLTLiaison)clazz.newInstance();
        } else if (string.equals("xslp")) {
            this.log("DEPRECATED - xslp processor is deprecated. Use trax or xalan instead.");
            Class clazz = this.loadClass("org.apache.tools.ant.taskdefs.optional.XslpLiaison");
            this.liaison = (XSLTLiaison)clazz.newInstance();
        } else if (string.equals("xalan")) {
            Class clazz = this.loadClass("org.apache.tools.ant.taskdefs.optional.XalanLiaison");
            this.liaison = (XSLTLiaison)clazz.newInstance();
        } else {
            this.liaison = (XSLTLiaison)this.loadClass(string).newInstance();
        }
    }

    public void setBasedir(File file) {
        this.baseDir = file;
    }

    public void setClasspath(Path path) {
        this.createClasspath().append(path);
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setExtension(String string) {
        this.targetExtension = string;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public void setIn(File file) {
        this.inFile = file;
    }

    public void setOut(File file) {
        this.outFile = file;
    }

    public void setProcessor(String string) {
        this.processor = string;
    }

    public void setStyle(String string) {
        this.xslFile = string;
    }

    public class Param {
        private String name = null;
        private String expression = null;

        public String getExpression() throws BuildException {
            if (this.expression == null) {
                throw new BuildException("Expression attribute is missing.");
            }
            return this.expression;
        }

        public String getName() throws BuildException {
            if (this.name == null) {
                throw new BuildException("Name attribute is missing.");
            }
            return this.name;
        }

        public void setExpression(String string) {
            this.expression = string;
        }

        public void setName(String string) {
            this.name = string;
        }
    }
}

