/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.ZipScanner;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class Zip
extends MatchingTask {
    private File zipFile;
    private File baseDir;
    private boolean doCompress = true;
    private boolean doUpdate = false;
    private boolean doFilesonly = false;
    protected String archiveType = "zip";
    private static long emptyCrc = new CRC32().getValue();
    protected String emptyBehavior = "skip";
    private Vector filesets = new Vector();
    private Hashtable addedDirs = new Hashtable();
    private Vector addedFiles = new Vector();
    private boolean addingNewFiles;
    private String encoding = null;

    protected void addFiles(Vector vector, ZipOutputStream zipOutputStream) throws IOException {
        int n = 0;
        while (n < vector.size()) {
            FileSet fileSet = (FileSet)vector.elementAt(n);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
            String string = "";
            String string2 = "";
            if (fileSet instanceof ZipFileSet) {
                ZipFileSet zipFileSet = (ZipFileSet)fileSet;
                string = zipFileSet.getPrefix();
                string2 = zipFileSet.getFullpath();
            }
            if (string.length() > 0 && !string.endsWith("/") && !string.endsWith("\\")) {
                string = String.valueOf(string) + "/";
            }
            if (string.length() > 0) {
                this.addParentDirs(null, string, zipOutputStream, "");
                this.zipDir(null, zipOutputStream, string);
            } else if (string2.length() > 0) {
                this.addParentDirs(null, string2, zipOutputStream, "");
            }
            if (fileSet instanceof ZipFileSet && ((ZipFileSet)fileSet).getSrc() != null) {
                this.addZipEntries((ZipFileSet)fileSet, directoryScanner, zipOutputStream, string, string2);
            } else {
                this.addFiles(directoryScanner, zipOutputStream, string, string2);
            }
            ++n;
        }
    }

    protected void addFiles(FileScanner fileScanner, ZipOutputStream zipOutputStream, String string, String string2) throws IOException {
        Object object;
        if (string.length() > 0 && string2.length() > 0) {
            throw new BuildException("Both prefix and fullpath attributes may not be set on the same fileset.");
        }
        File file = fileScanner.getBasedir();
        String[] stringArray = fileScanner.getIncludedDirectories();
        if (stringArray.length > 0 && string2.length() > 0) {
            throw new BuildException("fullpath attribute may only be specified for filesets that specify a single file.");
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!"".equals(stringArray[n])) {
                object = stringArray[n].replace(File.separatorChar, '/');
                if (!((String)object).endsWith("/")) {
                    object = String.valueOf(object) + "/";
                }
                this.addParentDirs(file, (String)object, zipOutputStream, string);
            }
            ++n;
        }
        object = fileScanner.getIncludedFiles();
        if (((String[])object).length > 1 && string2.length() > 0) {
            throw new BuildException("fullpath attribute may only be specified for filesets that specify a single file.");
        }
        int n2 = 0;
        while (n2 < ((String[])object).length) {
            File file2 = new File(file, (String)object[n2]);
            if (string2.length() > 0) {
                this.addParentDirs(null, string2, zipOutputStream, "");
                this.zipFile(file2, zipOutputStream, string2);
            } else {
                String string3 = ((String)object[n2]).replace(File.separatorChar, '/');
                this.addParentDirs(file, string3, zipOutputStream, string);
                this.zipFile(file2, zipOutputStream, String.valueOf(string) + string3);
            }
            ++n2;
        }
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    protected void addParentDirs(File file, String string, ZipOutputStream zipOutputStream, String string2) throws IOException {
        if (!this.doFilesonly) {
            String string3;
            Stack<String> stack = new Stack<String>();
            int n = string.length();
            while ((n = string.lastIndexOf(47, n - 1)) != -1) {
                string3 = string.substring(0, n + 1);
                if (this.addedDirs.get(String.valueOf(string2) + string3) != null) break;
                stack.push(string3);
            }
            while (!stack.isEmpty()) {
                string3 = (String)stack.pop();
                File file2 = null;
                file2 = file != null ? new File(file, string3) : new File(string3);
                this.zipDir(file2, zipOutputStream, String.valueOf(string2) + string3);
            }
        }
    }

    protected void addZipEntries(ZipFileSet zipFileSet, DirectoryScanner directoryScanner, ZipOutputStream zipOutputStream, String string, String string2) throws IOException {
        if (string.length() > 0 && string2.length() > 0) {
            throw new BuildException("Both prefix and fullpath attributes may not be set on the same fileset.");
        }
        ZipScanner zipScanner = (ZipScanner)directoryScanner;
        File file = zipFileSet.getSrc();
        ZipInputStream zipInputStream = null;
        try {
            java.util.zip.ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                ZipEntry zipEntry2 = new ZipEntry(zipEntry);
                String string3 = zipEntry2.getName();
                if (!zipScanner.match(string3)) continue;
                if (string2.length() > 0) {
                    this.addParentDirs(null, string2, zipOutputStream, "");
                    this.zipFile(zipInputStream, zipOutputStream, string2, zipEntry2.getTime());
                    continue;
                }
                this.addParentDirs(null, string3, zipOutputStream, string);
                if (zipEntry2.isDirectory()) continue;
                this.zipFile(zipInputStream, zipOutputStream, String.valueOf(string) + string3, zipEntry2.getTime());
            }
        }
        finally {
            Object var12_12 = null;
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
    }

    public void addZipfileset(ZipFileSet zipFileSet) {
        this.filesets.addElement(zipFileSet);
    }

    protected void cleanUp() {
        this.addedDirs = new Hashtable();
        this.addedFiles = new Vector();
    }

    protected boolean createEmptyZip(File file) {
        this.log("Note: creating empty " + this.archiveType + " archive " + file, 2);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                byte[] byArray = new byte[22];
                byArray[0] = 80;
                byArray[1] = 75;
                byArray[2] = 5;
                byArray[3] = 6;
                ((OutputStream)fileOutputStream).write(byArray);
            }
            finally {
                Object var4_5 = null;
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Could not create empty ZIP archive", iOException, this.location);
        }
        return true;
    }

    public void execute() throws BuildException {
        if (this.baseDir == null && this.filesets.size() == 0 && "zip".equals(this.archiveType)) {
            throw new BuildException("basedir attribute must be set, or at least one fileset must be given!");
        }
        if (this.zipFile == null) {
            throw new BuildException("You must specify the " + this.archiveType + " file to create!");
        }
        File file = null;
        this.addingNewFiles = true;
        boolean bl = false;
        if (this.doUpdate && this.zipFile.exists()) {
            bl = true;
            int n = 0;
            while (n < 1000) {
                file = new File(this.zipFile.getParent(), "tmp." + n);
                if (!file.exists()) break;
                ++n;
            }
            if (n == 1000) {
                throw new BuildException("Can't find available temporary filename to which to rename old file.");
            }
            try {
                if (!this.zipFile.renameTo(file)) {
                    throw new BuildException("Unable to rename old file to temporary file");
                }
            }
            catch (SecurityException securityException) {
                throw new BuildException("Not allowed to rename old file to temporary file");
            }
        }
        Vector<DirectoryScanner> vector = new Vector<DirectoryScanner>();
        if (this.baseDir != null) {
            vector.addElement(this.getDirectoryScanner(this.baseDir));
        }
        int n = 0;
        while (n < this.filesets.size()) {
            FileSet fileSet = (FileSet)this.filesets.elementAt(n);
            vector.addElement(fileSet.getDirectoryScanner(this.project));
            ++n;
        }
        int n2 = vector.size();
        Object[] objectArray = new FileScanner[n2];
        vector.copyInto(objectArray);
        if (this.isUpToDate((FileScanner[])objectArray, this.zipFile)) {
            return;
        }
        String string = bl ? "Updating " : "Building ";
        this.log(String.valueOf(string) + this.archiveType + ": " + this.zipFile.getAbsolutePath());
        boolean bl2 = false;
        try {
            try {
                Object object2;
                ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.zipFile));
                zipOutputStream.setEncoding(this.encoding);
                try {
                    if (this.doCompress) {
                        zipOutputStream.setMethod(8);
                    } else {
                        zipOutputStream.setMethod(0);
                    }
                    this.initZipOutputStream(zipOutputStream);
                    if (this.baseDir != null) {
                        this.addFiles(this.getDirectoryScanner(this.baseDir), zipOutputStream, "", "");
                    }
                    this.addFiles(this.filesets, zipOutputStream);
                    if (bl) {
                        this.addingNewFiles = false;
                        object2 = new ZipFileSet();
                        ((ZipFileSet)object2).setSrc(file);
                        StringBuffer stringBuffer = new StringBuffer();
                        int n3 = 0;
                        while (n3 < this.addedFiles.size()) {
                            if (n3 != 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append((String)this.addedFiles.elementAt(n3));
                            ++n3;
                        }
                        ((FileSet)object2).setExcludes(stringBuffer.toString());
                        Vector<Object> vector2 = new Vector<Object>();
                        vector2.addElement(object2);
                        this.addFiles(vector2, zipOutputStream);
                    }
                    this.finalizeZipOutputStream(zipOutputStream);
                    bl2 = true;
                }
                finally {
                    block32: {
                        Object var13_18 = null;
                        try {
                            if (zipOutputStream != null) {
                                zipOutputStream.close();
                            }
                        }
                        catch (IOException object2) {
                            if (!bl2) break block32;
                            throw object2;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                String string2 = "Problem creating " + this.archiveType + ": " + iOException.getMessage();
                if (!this.zipFile.delete()) {
                    string2 = String.valueOf(string2) + " (and the archive is probably corrupt but I could not delete it)";
                }
                if (bl && !file.renameTo(this.zipFile)) {
                    string2 = String.valueOf(string2) + " (and I couldn't rename the temporary file " + file.getName() + " back)";
                }
                throw new BuildException(string2, iOException, this.location);
            }
            Object var10_22 = null;
            this.cleanUp();
        }
        catch (Throwable throwable) {
            Object var10_23 = null;
            this.cleanUp();
            throw throwable;
        }
        if (bl2 && bl && !file.delete()) {
            this.log("Warning: unable to delete temporary file " + file.getName(), 1);
        }
    }

    protected void finalizeZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
    }

    protected static String[][] grabFileNames(FileScanner[] fileScannerArray) {
        String[][] stringArray = new String[fileScannerArray.length][];
        int n = 0;
        while (n < fileScannerArray.length) {
            String[] stringArray2 = fileScannerArray[n].getIncludedFiles();
            String[] stringArray3 = fileScannerArray[n].getIncludedDirectories();
            stringArray[n] = new String[stringArray2.length + stringArray3.length];
            System.arraycopy(stringArray2, 0, stringArray[n], 0, stringArray2.length);
            System.arraycopy(stringArray3, 0, stringArray[n], stringArray2.length, stringArray3.length);
            ++n;
        }
        return stringArray;
    }

    protected static File[] grabFiles(FileScanner[] fileScannerArray) {
        return Zip.grabFiles(fileScannerArray, Zip.grabFileNames(fileScannerArray));
    }

    protected static File[] grabFiles(FileScanner[] fileScannerArray, String[][] stringArray) {
        Object[] objectArray;
        Vector<File> vector = new Vector<File>();
        int n = 0;
        while (n < stringArray.length) {
            objectArray = fileScannerArray[n].getBasedir();
            int n2 = 0;
            while (n2 < stringArray[n].length) {
                vector.addElement(new File((File)objectArray, stringArray[n][n2]));
                ++n2;
            }
            ++n;
        }
        objectArray = new File[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected void initZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
    }

    protected boolean isAddingNewFiles() {
        return this.addingNewFiles;
    }

    protected boolean isUpToDate(FileScanner[] fileScannerArray, File file) throws BuildException {
        String[][] stringArray = Zip.grabFileNames(fileScannerArray);
        File[] fileArray = Zip.grabFiles(fileScannerArray, stringArray);
        if (fileArray.length == 0) {
            if (this.emptyBehavior.equals("skip")) {
                this.log("Warning: skipping " + this.archiveType + " archive " + file + " because no files were included.", 1);
                return true;
            }
            if (this.emptyBehavior.equals("fail")) {
                throw new BuildException("Cannot create " + this.archiveType + " archive " + file + ": no files were included.", this.location);
            }
            return this.createEmptyZip(file);
        }
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].equals(file)) {
                throw new BuildException("A zip file cannot include itself", this.location);
            }
            ++n;
        }
        if (!file.exists()) {
            return false;
        }
        SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
        MergingMapper mergingMapper = new MergingMapper();
        mergingMapper.setTo(file.getAbsolutePath());
        int n2 = 0;
        while (n2 < fileScannerArray.length) {
            if (sourceFileScanner.restrict(stringArray[n2], fileScannerArray[n2].getBasedir(), null, mergingMapper).length > 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void setBasedir(File file) {
        this.baseDir = file;
    }

    public void setCompress(boolean bl) {
        this.doCompress = bl;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setFilesonly(boolean bl) {
        this.doFilesonly = bl;
    }

    public void setUpdate(boolean bl) {
        this.doUpdate = bl;
    }

    public void setWhenempty(WhenEmpty whenEmpty) {
        this.emptyBehavior = whenEmpty.getValue();
    }

    public void setZipfile(File file) {
        this.zipFile = file;
    }

    protected void zipDir(File file, ZipOutputStream zipOutputStream, String string) throws IOException {
        if (this.addedDirs.get(string) != null) {
            return;
        }
        this.addedDirs.put(string, string);
        ZipEntry zipEntry = new ZipEntry(string);
        if (file != null && file.exists()) {
            zipEntry.setTime(file.lastModified());
        } else {
            zipEntry.setTime(System.currentTimeMillis());
        }
        zipEntry.setSize(0L);
        zipEntry.setMethod(0);
        zipEntry.setCrc(emptyCrc);
        zipEntry.setExternalAttributes(1107099664L);
        zipOutputStream.putNextEntry(zipEntry);
    }

    protected void zipFile(File file, ZipOutputStream zipOutputStream, String string) throws IOException {
        if (file.equals(this.zipFile)) {
            throw new BuildException("A zip file cannot include itself", this.location);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.zipFile(fileInputStream, zipOutputStream, string, file.lastModified());
        }
        finally {
            Object var6_5 = null;
            fileInputStream.close();
        }
    }

    protected void zipFile(InputStream inputStream, ZipOutputStream zipOutputStream, String string, long l) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(l);
        if (!this.doCompress) {
            Object object;
            long l2 = 0L;
            CRC32 cRC32 = new CRC32();
            if (!inputStream.markSupported()) {
                object = new ByteArrayOutputStream();
                byte[] byArray = new byte[8192];
                int n = 0;
                do {
                    l2 += (long)n;
                    cRC32.update(byArray, 0, n);
                    ((ByteArrayOutputStream)object).write(byArray, 0, n);
                } while ((n = inputStream.read(byArray, 0, byArray.length)) != -1);
                inputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
            } else {
                inputStream.mark(Integer.MAX_VALUE);
                object = new byte[8192];
                int n = 0;
                do {
                    l2 += (long)n;
                    cRC32.update((byte[])object, 0, n);
                } while ((n = inputStream.read((byte[])object, 0, ((Object)object).length)) != -1);
                inputStream.reset();
            }
            zipEntry.setSize(l2);
            zipEntry.setCrc(cRC32.getValue());
        }
        zipOutputStream.putNextEntry(zipEntry);
        byte[] byArray = new byte[8192];
        int n = 0;
        do {
            if (n == 0) continue;
            zipOutputStream.write(byArray, 0, n);
        } while ((n = inputStream.read(byArray, 0, byArray.length)) != -1);
        this.addedFiles.addElement(string);
    }

    public static class WhenEmpty
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"fail", "skip", "create"};
        }
    }
}

