/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.condition;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.condition.Condition;

public class Os
implements Condition {
    private String family;

    public boolean eval() throws BuildException {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("path.separator");
        if (this.family != null) {
            if (this.family.equals("windows")) {
                return string.indexOf("windows") > -1;
            }
            if (this.family.equals("dos")) {
                return string2.equals(";");
            }
            if (this.family.equals("mac")) {
                return string.indexOf("mac") > -1;
            }
            if (this.family.equals("unix")) {
                return string2.equals(":") && (!string.startsWith("mac") || string.endsWith("x"));
            }
            throw new BuildException("Don't know how to detect os family \"" + this.family + "\"");
        }
        return false;
    }

    public void setFamily(String string) {
        this.family = string.toLowerCase();
    }
}

