/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.rmic;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.rmic.KaffeRmic;
import org.apache.tools.ant.taskdefs.rmic.RmicAdapter;
import org.apache.tools.ant.taskdefs.rmic.SunRmic;
import org.apache.tools.ant.taskdefs.rmic.WLRmic;

public class RmicAdapterFactory {
    private RmicAdapterFactory() {
    }

    public static RmicAdapter getRmic(String string, Task task) throws BuildException {
        if (string == null) {
            try {
                Class.forName("sun.rmi.rmic.Main");
                string = "sun";
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    Class.forName("kaffe.rmi.rmic.RMIC");
                    Class.forName("kaffe.tools.compiler.Compiler");
                    string = "kaffe";
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    throw new BuildException("Couldn't guess rmic implementation");
                }
            }
        }
        if (string.equalsIgnoreCase("sun")) {
            return new SunRmic();
        }
        if (string.equalsIgnoreCase("kaffe")) {
            return new KaffeRmic();
        }
        if (string.equalsIgnoreCase("weblogic")) {
            return new WLRmic();
        }
        return RmicAdapterFactory.resolveClassName(string);
    }

    private static RmicAdapter resolveClassName(String string) throws BuildException {
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            return (RmicAdapter)obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException(String.valueOf(string) + " can't be found.", classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            throw new BuildException(String.valueOf(string) + " isn't the classname of " + "a rmic adapter.", classCastException);
        }
        catch (Throwable throwable) {
            throw new BuildException(String.valueOf(string) + " caused an interesting " + "exception.", throwable);
        }
    }
}

