/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.regexp.RegexpMatcher;
import org.apache.tools.ant.util.regexp.RegexpMatcherFactory;

public class RegexpPatternMapper
implements FileNameMapper {
    protected RegexpMatcher reg = null;
    protected char[] to = null;
    protected StringBuffer result = new StringBuffer();

    public RegexpPatternMapper() throws BuildException {
        this.reg = new RegexpMatcherFactory().newRegexpMatcher();
    }

    public String[] mapFileName(String string) {
        if (this.reg == null || this.to == null || !this.reg.matches(string)) {
            return null;
        }
        return new String[]{this.replaceReferences(string)};
    }

    protected String replaceReferences(String string) {
        Vector vector = this.reg.getGroups(string);
        this.result.setLength(0);
        int n = 0;
        while (n < this.to.length) {
            if (this.to[n] == '\\') {
                if (++n < this.to.length) {
                    int n2 = Character.digit(this.to[n], 10);
                    if (n2 > -1) {
                        this.result.append((String)vector.elementAt(n2));
                    } else {
                        this.result.append(this.to[n]);
                    }
                } else {
                    this.result.append('\\');
                }
            } else {
                this.result.append(this.to[n]);
            }
            ++n;
        }
        return this.result.toString();
    }

    public void setFrom(String string) throws BuildException {
        try {
            this.reg.setPattern(string);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new BuildException("Cannot load regular expression matcher", noClassDefFoundError);
        }
    }

    public void setTo(String string) {
        this.to = string.toCharArray();
    }
}

