/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class PropertyFile
extends Task {
    private static final String NEWLINE = System.getProperty("line.separator");
    private String m_comment;
    private Properties m_properties;
    private File m_propertyfile;
    private Vector entries = new Vector();
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$java$lang$String;

    private boolean checkParam(File param) {
        return param != null;
    }

    private boolean checkParam(String param) {
        return (param == null || param.equals("null")) ^ true;
    }

    private void checkParameters() throws BuildException {
        if (!this.checkParam(this.m_propertyfile)) {
            throw new BuildException("file token must not be null.", this.location);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Entry createEntry() {
        Entry e = new Entry();
        this.entries.addElement(e);
        return e;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        this.readFile();
        this.executeOperation();
        this.writeFile();
    }

    private void executeOperation() throws BuildException {
        Enumeration e = this.entries.elements();
        while (e.hasMoreElements()) {
            Entry entry = (Entry)e.nextElement();
            entry.executeOn(this.m_properties);
        }
    }

    private void readFile() throws BuildException {
        this.m_properties = new Properties();
        try {
            if (this.m_propertyfile.exists()) {
                this.log("Updating property file: " + this.m_propertyfile.getAbsolutePath());
                this.m_properties.load(new BufferedInputStream(new FileInputStream(this.m_propertyfile)));
            } else {
                this.log("Creating new property file: " + this.m_propertyfile.getAbsolutePath());
                FileOutputStream out = new FileOutputStream(this.m_propertyfile.getAbsolutePath());
                out.flush();
                out.close();
            }
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.toString());
        }
    }

    public void setComment(String hdr) {
        this.m_comment = hdr;
    }

    public void setFile(File file) {
        this.m_propertyfile = file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeFile() throws BuildException {
        BufferedOutputStream bos = null;
        try {
            try {
                bos = new BufferedOutputStream(new FileOutputStream(this.m_propertyfile));
                Method m = (class$java$util$Properties != null ? class$java$util$Properties : (class$java$util$Properties = PropertyFile.class$("java.util.Properties"))).getMethod("store", class$java$io$OutputStream != null ? class$java$io$OutputStream : (class$java$io$OutputStream = PropertyFile.class$("java.io.OutputStream")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = PropertyFile.class$("java.lang.String")));
                m.invoke((Object)this.m_properties, bos, this.m_comment);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.m_properties.save(bos, this.m_comment);
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getTargetException();
                throw new BuildException(t, this.location);
            }
            catch (IllegalAccessException iae) {
                throw new BuildException((Throwable)iae, this.location);
            }
            catch (IOException ioe) {
                throw new BuildException((Throwable)ioe, this.location);
            }
            Object var3_7 = null;
            if (bos == null) return;
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            if (bos == null) throw throwable;
            try {
                bos.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            bos.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public static class Entry {
        static final String NOW_VALUE_ = "now";
        static final String NULL_VALUE_ = "never";
        private static final int DEFAULT_INT_VALUE = 1;
        private static final GregorianCalendar DEFAULT_DATE_VALUE = new GregorianCalendar();
        private String m_key = null;
        private int m_type = 2;
        private int m_operation = 2;
        private String m_value = "1";
        private String m_default = null;
        private String m_pattern = null;

        private void checkParameters() throws BuildException {
            if (this.m_type == 2 && this.m_operation == 1) {
                throw new BuildException("- is not suported for string properties (key:" + this.m_key + ")");
            }
            if (this.m_value == null) {
                throw new BuildException("value is mandatory (key:" + this.m_key + ")");
            }
            if (this.m_key == null) {
                throw new BuildException("key is mandatory");
            }
            if (this.m_type == 2 && this.m_pattern != null) {
                throw new BuildException("pattern is not suported for string properties (key:" + this.m_key + ")");
            }
        }

        private void executeDate(String oldValue) throws BuildException {
            GregorianCalendar value = new GregorianCalendar();
            GregorianCalendar newValue = new GregorianCalendar();
            if (this.m_pattern == null) {
                this.m_pattern = "yyyy/MM/dd HH:mm";
            }
            SimpleDateFormat fmt = new SimpleDateFormat(this.m_pattern);
            if (this.m_value != null) {
                if (NOW_VALUE_.equals(this.m_value.toLowerCase())) {
                    value.setTime(new Date());
                } else if (NULL_VALUE_.equals(this.m_value.toLowerCase())) {
                    value = null;
                } else {
                    try {
                        value.setTime(fmt.parse(this.m_value));
                    }
                    catch (Exception exception) {
                        try {
                            int offset = Integer.parseInt(this.m_value);
                            value.clear();
                            value.set(6, offset);
                        }
                        catch (Exception exception2) {
                            value.clear();
                            value.set(6, 1);
                        }
                    }
                }
            }
            if (this.m_default != null && NOW_VALUE_.equals(this.m_default.toLowerCase()) && (this.m_operation == 0 || this.m_operation == 1)) {
                oldValue = null;
            }
            if (oldValue != null) {
                try {
                    newValue.setTime(fmt.parse(oldValue));
                }
                catch (ParseException parseException) {}
            } else if (this.m_default != null) {
                if (NOW_VALUE_.equals(this.m_default.toLowerCase())) {
                    newValue.setTime(new Date());
                } else if (NULL_VALUE_.equals(this.m_default.toLowerCase())) {
                    newValue = null;
                } else {
                    try {
                        newValue.setTime(fmt.parse(this.m_default));
                    }
                    catch (ParseException parseException) {}
                }
            }
            if (this.m_operation == 2) {
                newValue = value;
            } else if (this.m_operation == 0) {
                newValue.add(13, value.get(13));
                newValue.add(12, value.get(12));
                newValue.add(11, value.get(11));
                newValue.add(6, value.get(6));
            } else if (this.m_operation == 1) {
                newValue.add(13, -1 * value.get(13));
                newValue.add(12, -1 * value.get(12));
                newValue.add(11, -1 * value.get(11));
                newValue.add(6, -1 * value.get(6));
            }
            this.m_value = newValue != null ? fmt.format(newValue.getTime()) : "";
        }

        private void executeInteger(String oldValue) throws BuildException {
            DecimalFormat fmt;
            int value = 0;
            int newValue = 0;
            DecimalFormat decimalFormat = fmt = this.m_pattern != null ? new DecimalFormat(this.m_pattern) : new DecimalFormat();
            if (this.m_value != null) {
                try {
                    value = fmt.parse(this.m_value).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (ParseException parseException) {}
            }
            if (oldValue != null) {
                try {
                    newValue = fmt.parse(oldValue).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (ParseException parseException) {}
            } else if (this.m_default != null) {
                try {
                    newValue = fmt.parse(this.m_default).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (ParseException parseException) {}
            }
            if (this.m_operation == 2) {
                newValue = value;
            } else if (this.m_operation == 0) {
                newValue += value;
            } else if (this.m_operation == 1) {
                newValue -= value;
            }
            this.m_value = fmt.format(newValue);
        }

        protected void executeOn(Properties props) throws BuildException {
            block5: {
                this.checkParameters();
                try {
                    if (this.m_type == 0) {
                        this.executeInteger((String)((Hashtable)props).get(this.m_key));
                        break block5;
                    }
                    if (this.m_type == 1) {
                        this.executeDate((String)((Hashtable)props).get(this.m_key));
                        break block5;
                    }
                    if (this.m_type == 2) {
                        this.executeString((String)((Hashtable)props).get(this.m_key));
                        break block5;
                    }
                    throw new BuildException("Unknown operation type: " + this.m_type);
                }
                catch (NullPointerException npe) {
                    npe.printStackTrace();
                }
            }
            ((Hashtable)props).put(this.m_key, this.m_value);
        }

        private void executeString(String oldValue) throws BuildException {
            String value = "";
            String newValue = "";
            if (this.m_value != null) {
                value = this.m_value;
            }
            if (oldValue != null) {
                newValue = oldValue;
            } else if (this.m_default != null) {
                newValue = this.m_default;
            }
            if (this.m_operation == 2) {
                newValue = value;
            } else if (this.m_operation == 0) {
                newValue = String.valueOf(newValue) + value;
            }
            this.m_value = newValue;
        }

        public void setDefault(String value) {
            this.m_default = value;
        }

        public void setKey(String value) {
            this.m_key = value;
        }

        public void setOperation(Operation value) {
            int newOperation = Operation.toOperation(value.getValue());
            if (newOperation == 3) {
                this.m_operation = 2;
                this.setValue(NOW_VALUE_);
            } else if (newOperation == 4) {
                this.m_operation = 2;
                this.setValue(NULL_VALUE_);
            } else {
                this.m_operation = newOperation;
            }
        }

        public void setPattern(String value) {
            this.m_pattern = value;
        }

        public void setType(Type value) {
            this.m_type = Type.toType(value.getValue());
        }

        public void setValue(String value) {
            this.m_value = value;
        }

        public static class Operation
        extends EnumeratedAttribute {
            public static final int INCREMENT_OPER = 0;
            public static final int DECREMENT_OPER = 1;
            public static final int EQUALS_OPER = 2;
            public static final int NOW_VALUE = 3;
            public static final int NULL_VALUE = 4;

            public String[] getValues() {
                return new String[]{"+", "-", "=", Entry.NOW_VALUE_, Entry.NULL_VALUE_};
            }

            public static int toOperation(String oper) {
                if ("+".equals(oper)) {
                    return 0;
                }
                if ("-".equals(oper)) {
                    return 1;
                }
                if (Entry.NOW_VALUE_.equals(oper)) {
                    return 3;
                }
                if (Entry.NULL_VALUE_.equals(oper)) {
                    return 4;
                }
                return 2;
            }
        }

        public static class Type
        extends EnumeratedAttribute {
            public static final int INTEGER_TYPE = 0;
            public static final int DATE_TYPE = 1;
            public static final int STRING_TYPE = 2;

            public String[] getValues() {
                return new String[]{"int", "date", "string"};
            }

            public static int toType(String type) {
                if ("int".equals(type)) {
                    return 0;
                }
                if ("date".equals(type)) {
                    return 1;
                }
                return 2;
            }
        }
    }
}

