/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;

public class NetCommand {
    protected Task _owner;
    protected Execute _exe;
    protected Commandline _commandLine;
    protected String _title;
    protected String _program;
    protected boolean _traceCommandLine = false;
    protected boolean _failOnError;

    public NetCommand(Task owner, String title, String program) {
        this._owner = owner;
        this._title = title;
        this._program = program;
        this._commandLine = new Commandline();
        this._commandLine.setExecutable(this._program);
        this.prepareExecutor();
    }

    public void addArgument(String argument) {
        if (argument != null && argument.length() != 0) {
            this._commandLine.createArgument().setValue(argument);
        }
    }

    public boolean getFailFailOnError() {
        return this._failOnError;
    }

    protected void logError(String msg) {
        this._owner.getProject().log(msg, 0);
    }

    protected void logVerbose(String msg) {
        this._owner.getProject().log(msg, 3);
    }

    protected void prepareExecutor() {
        File dir = this._owner.getProject().getBaseDir();
        LogStreamHandler handler = new LogStreamHandler(this._owner, 2, 1);
        this._exe = new Execute((ExecuteStreamHandler)handler, null);
        this._exe.setAntRun(this._owner.getProject());
        this._exe.setWorkingDirectory(dir);
    }

    public void runCommand() throws BuildException {
        int err = -1;
        try {
            if (this._traceCommandLine) {
                this._owner.log(this._commandLine.toString());
            } else {
                this.logVerbose(this._commandLine.toString());
            }
            this._exe.setCommandline(this._commandLine.getCommandline());
            err = this._exe.execute();
            if (err != 0) {
                if (this._failOnError) {
                    throw new BuildException(String.valueOf(this._title) + " returned: " + err, this._owner.getLocation());
                }
                this._owner.log(String.valueOf(this._title) + "  Result: " + err, 0);
            }
        }
        catch (IOException e) {
            throw new BuildException(String.valueOf(this._title) + " failed: " + e, (Throwable)e, this._owner.getLocation());
        }
    }

    public void setFailOnError(boolean b) {
        this._failOnError = b;
    }

    public void setTraceCommandLine(boolean b) {
        this._traceCommandLine = b;
    }
}

