/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.metamata;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public abstract class AbstractMetamataTask
extends Task {
    protected Path classPath = null;
    protected Path sourcePath = null;
    protected File metamataHome = null;
    protected CommandlineJava cmdl = new CommandlineJava();
    protected Vector fileSets = new Vector();
    protected File optionsFile = null;
    protected Hashtable includedFiles = null;

    public AbstractMetamataTask() {
    }

    protected AbstractMetamataTask(String className) {
        this.cmdl.setVm("java");
        this.cmdl.setClassname(className);
    }

    protected static final void addAllVector(Vector dest, Enumeration files) {
        while (files.hasMoreElements()) {
            dest.addElement(files.nextElement());
        }
    }

    public void addFileSet(FileSet fs) {
        this.fileSets.addElement(fs);
    }

    protected void checkOptions() throws BuildException {
        if (this.metamataHome == null || !this.metamataHome.exists()) {
            throw new BuildException("'metamatahome' must point to Metamata home directory.");
        }
        this.metamataHome = ((ProjectComponent)this).project.resolveFile(this.metamataHome.getPath());
        File jar = this.getMetamataJar(this.metamataHome);
        if (!jar.exists()) {
            throw new BuildException(String.valueOf(String.valueOf(jar)) + " does not exist. Check your metamata installation.");
        }
    }

    protected void cleanUp() {
        if (this.optionsFile != null) {
            this.optionsFile.delete();
            this.optionsFile = null;
        }
    }

    public Path createClasspath() {
        if (this.classPath == null) {
            this.classPath = new Path(((ProjectComponent)this).project);
        }
        return this.classPath;
    }

    public Commandline.Argument createJvmarg() {
        return this.cmdl.createVmArgument();
    }

    public Path createSourcepath() {
        if (this.sourcePath == null) {
            this.sourcePath = new Path(((ProjectComponent)this).project);
        }
        return this.sourcePath;
    }

    protected abstract ExecuteStreamHandler createStreamHandler();

    protected static final File createTmpFile() {
        long rand = new Random(System.currentTimeMillis()).nextLong();
        File file = new File("metamata" + rand + ".tmp");
        return file;
    }

    public void execute() throws BuildException {
        try {
            this.setUp();
            ExecuteStreamHandler handler = this.createStreamHandler();
            this.execute0(handler);
        }
        finally {
            Object var2_2 = null;
            this.cleanUp();
        }
    }

    protected void execute0(ExecuteStreamHandler handler) throws BuildException {
        Execute process = new Execute(handler);
        this.log(this.cmdl.toString(), 3);
        process.setCommandline(this.cmdl.getCommandline());
        try {
            if (process.execute() != 0) {
                throw new BuildException("Metamata task failed.");
            }
        }
        catch (IOException e) {
            throw new BuildException("Failed to launch Metamata task: " + e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void generateOptionsFile(File tofile, Vector options) throws BuildException {
        FileWriter fw = null;
        try {
            try {
                fw = new FileWriter(tofile);
                PrintWriter pw = new PrintWriter(fw);
                int size = options.size();
                int i = 0;
                while (i < size) {
                    pw.println(options.elementAt(i));
                    ++i;
                }
                pw.flush();
            }
            catch (IOException e) {
                throw new BuildException("Error while writing options file " + tofile, (Throwable)e);
            }
            Object var5_8 = null;
            if (fw == null) return;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (fw == null) throw throwable;
            try {
                fw.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fw.close();
            return;
        }
        catch (IOException iOException) {}
    }

    protected Hashtable getFileMapping() {
        return this.includedFiles;
    }

    protected final File getMetamataJar(File home) {
        return new File(new File(home.getAbsolutePath()), "lib/metamata.jar");
    }

    protected abstract Vector getOptions();

    protected Hashtable scanFileSets() {
        Hashtable<String, String> files = new Hashtable<String, String>();
        int i = 0;
        while (i < this.fileSets.size()) {
            FileSet fs = (FileSet)this.fileSets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(((ProjectComponent)this).project);
            ds.scan();
            String[] f = ds.getIncludedFiles();
            this.log(String.valueOf(i) + ") Adding " + f.length + " files from directory " + ds.getBasedir(), 3);
            int j = 0;
            while (j < f.length) {
                String pathname = f[j];
                if (pathname.endsWith(".java")) {
                    File file = new File(ds.getBasedir(), pathname);
                    String classname = pathname.substring(0, pathname.length() - ".java".length());
                    classname = classname.replace(File.separatorChar, '.');
                    files.put(file.getAbsolutePath(), classname);
                }
                ++j;
            }
            ++i;
        }
        return files;
    }

    public void setMaxmemory(String max) {
        if (Project.getJavaVersion().startsWith("1.1")) {
            this.createJvmarg().setValue("-mx" + max);
        } else {
            this.createJvmarg().setValue("-Xmx" + max);
        }
    }

    public void setMetamatahome(File metamataHome) {
        this.metamataHome = metamataHome;
    }

    protected void setUp() throws BuildException {
        this.checkOptions();
        File jar = this.getMetamataJar(this.metamataHome);
        Path classPath = this.cmdl.createClasspath(((ProjectComponent)this).project);
        classPath.createPathElement().setLocation(jar);
        Commandline.Argument vmArgs = this.cmdl.createVmArgument();
        vmArgs.setValue("-Dmetamata.home=" + this.metamataHome.getAbsolutePath());
        this.includedFiles = this.scanFileSets();
        this.log(String.valueOf(this.includedFiles.size()) + " files added for audit", 3);
        Vector options = this.getOptions();
        this.optionsFile = AbstractMetamataTask.createTmpFile();
        this.generateOptionsFile(this.optionsFile, options);
        Commandline.Argument args = this.cmdl.createArgument();
        args.setLine("-arguments " + this.optionsFile.getAbsolutePath());
    }
}

