/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.vss;

import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.vss.MSVSS;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class MSVSSHISTORY
extends MSVSS {
    private String m_FromDate = null;
    private String m_ToDate = null;
    private DateFormat m_DateFormat = DateFormat.getDateInstance(3);
    private String m_FromLabel = null;
    private String m_ToLabel = null;
    private String m_OutputFileName = null;
    private String m_User = null;
    private int m_NumDays = Integer.MIN_VALUE;
    private String m_Style = "";
    private boolean m_Recursive = false;
    public static final String VALUE_FROMDATE = "~d";
    public static final String VALUE_FROMLABEL = "~L";
    public static final String FLAG_OUTPUT = "-O";
    public static final String FLAG_USER = "-U";

    private String calcDate(String fromDate, int numDays) throws ParseException {
        String toDate = null;
        Date currdate = new Date();
        GregorianCalendar calend = new GregorianCalendar();
        currdate = this.m_DateFormat.parse(fromDate);
        calend.setTime(currdate);
        ((Calendar)calend).add(5, numDays);
        toDate = this.m_DateFormat.format(calend.getTime());
        return toDate;
    }

    public void execute() throws BuildException {
        Commandline commandLine = new Commandline();
        int result = 0;
        if (this.getVsspath() == null) {
            String msg = "vsspath attribute must be set!";
            throw new BuildException(msg, this.location);
        }
        commandLine.setExecutable(this.getSSCommand());
        commandLine.createArgument().setValue("History");
        commandLine.createArgument().setValue(this.getVsspath());
        commandLine.createArgument().setValue("-I-");
        this.getVersionDateCommand(commandLine);
        this.getVersionLabelCommand(commandLine);
        if (this.m_Recursive) {
            commandLine.createArgument().setValue("-R");
        }
        if (this.m_Style.length() > 0) {
            commandLine.createArgument().setValue(this.m_Style);
        }
        this.getLoginCommand(commandLine);
        this.getOutputCommand(commandLine);
        System.out.println("***: " + commandLine);
        result = this.run(commandLine);
        if (result != 0) {
            String msg = "Failed executing: " + commandLine.toString();
            throw new BuildException(msg, this.location);
        }
    }

    private void getOutputCommand(Commandline cmd) {
        if (this.m_OutputFileName != null) {
            cmd.createArgument().setValue(FLAG_OUTPUT + this.m_OutputFileName);
        }
    }

    private void getRecursiveCommand(Commandline cmd) {
        if (!this.m_Recursive) {
            return;
        }
        cmd.createArgument().setValue("-R");
    }

    private void getUserCommand(Commandline cmd) {
        if (this.m_User != null) {
            cmd.createArgument().setValue(FLAG_USER + this.m_User);
        }
    }

    private void getVersionDateCommand(Commandline cmd) throws BuildException {
        if (this.m_FromDate == null && this.m_ToDate == null && this.m_NumDays == Integer.MIN_VALUE) {
            return;
        }
        if (this.m_FromDate != null && this.m_ToDate != null) {
            cmd.createArgument().setValue("-Vd" + this.m_ToDate + VALUE_FROMDATE + this.m_FromDate);
        } else if (this.m_ToDate != null && this.m_NumDays != Integer.MIN_VALUE) {
            String startDate = null;
            try {
                startDate = this.calcDate(this.m_ToDate, this.m_NumDays);
            }
            catch (ParseException parseException) {
                String msg = "Error parsing date: " + this.m_ToDate;
                throw new BuildException(msg, this.location);
            }
            cmd.createArgument().setValue("-Vd" + this.m_ToDate + VALUE_FROMDATE + startDate);
        } else if (this.m_FromDate != null && this.m_NumDays != Integer.MIN_VALUE) {
            String endDate = null;
            try {
                endDate = this.calcDate(this.m_FromDate, this.m_NumDays);
            }
            catch (ParseException parseException) {
                String msg = "Error parsing date: " + this.m_FromDate;
                throw new BuildException(msg, this.location);
            }
            cmd.createArgument().setValue("-Vd" + endDate + VALUE_FROMDATE + this.m_FromDate);
        } else if (this.m_FromDate != null) {
            cmd.createArgument().setValue("-V~d" + this.m_FromDate);
        } else {
            cmd.createArgument().setValue("-Vd" + this.m_ToDate);
        }
    }

    private void getVersionLabelCommand(Commandline cmd) throws BuildException {
        if (this.m_FromLabel == null && this.m_ToLabel == null) {
            return;
        }
        if (this.m_FromLabel != null && this.m_ToLabel != null) {
            cmd.createArgument().setValue("-VL" + this.m_ToLabel + VALUE_FROMLABEL + this.m_FromLabel);
        } else if (this.m_FromLabel != null) {
            cmd.createArgument().setValue("-V~L" + this.m_FromLabel);
        } else {
            cmd.createArgument().setValue("-VL" + this.m_ToLabel);
        }
    }

    public void setDateFormat(String dateFormat) {
        if (!dateFormat.equals("") && dateFormat != null) {
            this.m_DateFormat = new SimpleDateFormat(dateFormat);
        }
    }

    public void setFromDate(String fromDate) {
        this.m_FromDate = fromDate.equals("") || fromDate == null ? null : fromDate;
    }

    public void setFromLabel(String fromLabel) {
        this.m_FromLabel = fromLabel.equals("") || fromLabel == null ? null : fromLabel;
    }

    public void setNumdays(int numd) {
        this.m_NumDays = numd;
    }

    public void setOutput(File outfile) {
        this.m_OutputFileName = outfile == null ? null : outfile.getAbsolutePath();
    }

    public void setRecursive(boolean recursive) {
        this.m_Recursive = recursive;
    }

    public void setStyle(BriefCodediffNofile attr) {
        String option = attr.getValue();
        if (option.equals("brief")) {
            this.m_Style = "-B";
        } else if (option.equals("codediff")) {
            this.m_Style = "-D";
        } else if (option.equals("default")) {
            this.m_Style = "";
        } else if (option.equals("nofile")) {
            this.m_Style = "-F-";
        } else {
            throw new BuildException("Style " + (Object)((Object)attr) + " unknown.");
        }
    }

    public void setToDate(String toDate) {
        this.m_ToDate = toDate.equals("") || toDate == null ? null : toDate;
    }

    public void setToLabel(String toLabel) {
        this.m_ToLabel = toLabel.equals("") || toLabel == null ? null : toLabel;
    }

    public void setUser(String user) {
        this.m_User = user;
    }

    public static class BriefCodediffNofile
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"brief", "codediff", "nofile", "default"};
        }
    }
}

