proc filter {dir} {
  set f [.top0.e1 get]
  set lb .top0.lb0
  $lb delete 0 end
  set list [exec ls -a $dir]
  foreach i $list {
    if {[file isdirectory $i]} {
      $lb insert end $i/
    } else {
      if {[lmatch -glob $i $f]!=""} {
        $lb insert end $i
      }
    }
  }
}

proc refilter {w} {
  global done RETURN
  set i [$w curselection]
  if {$i != ""} {
    set file [$w get $i]
  } else { set file "" }
  if {[file isdirectory $file]} {
    cd $file
    filter .
  } else {
    echo [pwd]/$file
    exit 
  }
}

proc setfilename {w} {
  set i [$w curselection]
  if {$i != ""} {
    set file [$w get $i]
  } else { set file "" }
  .top0.e2 delete 0 end
  .top0.e2 insert end [pwd]/$file
  .top0.e2 view [clength [pwd]]

}

proc done_cb {} {
  echo [.top0.e2 get]
  exit
}

set done 0
set RETURN ""
set lb .top0.lb0
wm deicon .top0
tk_listboxSingleSelect $lb
bind $lb <Double-1> {refilter %W}
set Bind [bind Listbox <Button-1>]
bind $lb <1> "$Bind\nsetfilename %W"
.top0.e1 delete 0 end
set arg ""
if {[catch "set argv"]==1} {set argv ""}
if {$argv != ""} {set arg [lvarpop argv]} else {set arg "*"}
.top0.e1 insert end $arg
bind .top0.e1 <Return> "filter ."
filter .
