#
# Copyright (c) 1995 Sean Halliday
# All rights reserved.
#
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in
# all copies of this software.
#
# IN NO EVENT SHALL SEAN HALLIDAY BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF SEAN HALLIDAY
# HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# SEAN HALLIDAY SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND SEAN HALLIDAY HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
#
# halliday@BanffCentre.AB.CA or halliday@cs.ualberta.ca

proc make_menu {w cmd} {
  catch "destroy $w.m"
  menu $w.m
  for {set i 0} {$i < [llength $cmd]} {set i [expr $i+1]} {
    set line [lindex $cmd $i]
    if {"[lindex $line 0]" == "separator" } {
      set CMD "$w.m add separator [lrange $line 1 end]"
      eval $CMD
    } else {
      if {"[lindex $line 1]" == "menu" } {
        set CMD "$w.m add cascade -label \"[lindex $line 0]\" -menu [make_menu $w.m [lindex $line 2]] [lrange $line 3 end]"
        eval $CMD
      } else {
        set CMD "$w.m add [lindex $line 1] -label \"[lindex $line 0]\" -command \"[lindex $line 2]\" [lrange $line 3 end]"
        eval $CMD
      }
    }
  }
  return $w.m
}
