proc show_text {type} {
  set helptext(general) "GENERAL HELP\n\
\nAdding Widgets:\n-----------------\n\
\tSelect a widget type from the main window.\
 (ex \"Create Button\").  Click in an edit window\
to add the widget.  Click again to add same type\
of widget again.\n
\n\Moving Widgets:\n-----------------\n\
\tClick on widget with right mouse button and drag mouse to move widget.\
\n\n\Resizing Widgets:\n-----------------\n\
\tClick on widget with middle mouse button and drag mouse to resize widget.\n\
\n\Configuring Widgets:\n-----------------\n\
\tUse SHIFT+right mouse button over a widget\
to popup the Configuration Dialog Box.\n\
\n\Deleting Widgets:\n-----------------\n\
\tUse DELETE+right mouse button to delete the widget.\n\
"
  set helptext(scrolled) "SCROLLED WIDGETS\n\
\n\tEntry, Text, Canvas and Listbox widgets can have scollbars.  A scrollable\
widget and a scrollbar will automatically connect if the widget is scrollable\
in the scrollbar's orientation (i.e. a vertical scrollbar will not connect to an Entry widget) and both widgets have the same parent.  If\
you want multiple scrolled widgets in the same window: \n
1) Create a frame for each scrollable widget.
2) Add a scrolled widget to the frame.
3) Add a scrollbar to the frame.\
"
  set helptext(menus) "MENUS\n\
\nMenus can be built using a simple menu script. \
This script can be edited using the Configuration Dialog Box. \
A menu is represented by:

{
  <menu item>
  <menu item>
  <menu item>
  .
  .
  .
}

Where a menu item is:

{<Name> command <command> \[<options>\]}
or
{<Name> radiobutton <command> \[<options>\]}
or
{<Name> checkbutton <command> \[<options>\]}
or
{<Name> menu <menu> \[<options>\]}
or
{separator}

Where options are (examples):

-foreground red -variable V1  (see Tcl/Tk manual for options of menu items)

A default menu is given when a menu is created.  I suggest editing this\
script to understand what happens. \
(Click on Apply and then click on menubutton.)

"
  set helptext(config) "CONFIGURE OPTIONS\n\
\n\tEvery configure option for any widget can be set through the\
Configuration Dialog Box.  The most common options are displayed\
in this box; the remaining options can be edited using the Configure\
Options Dialog Box (click on Configure Options).  This dialog box\
will give a list of widget specific options.  Some of these options\
can be set using a popup menu.  Click with the right mouse over the\
entry field to popup a menu.

\tNote that Name and Command may not do anything for some widgets. \
They are there in case Tk changes.  (For example entry widget's name\
could become a label for it.)  

\tStretch and Move checkbuttons are used to set whether a widget\
resizes or moves when it's parent resizes.  To set whether the toplevel\
widget is resizable, just set or clear StretchX; the others have no affect.
"
  set T .top0.t3
  $T delete 0.0 end
  $T insert end $helptext($type)
}

show_text general
