#!/usr/local/bin/wish -f

###
### -- text.t , listbox based article viewer for arTCLs
###

set ListFont "lucidasanstypewriter-12"
set artcls_Interp "artcls"

# do not touch the next line !!
set Profile(ArtclsLib) /usr/local/lib/artcls;#SEDMARK
set ArticleHeader(.) _bogus

###
### These functions are callbacks that you may want to modify
### a bit
###
proc tkerror {s} {puts stderr "\narTCLs_text: '$s'\n" }


# return the pipeline command to use for saving 'filename' into a folder.
#
# XXX - this is rather contrived. we are capable of writing it ourselves. 
# this will happen soon
proc folderSaver {filename} {
    if {[file executable /usr/ucb/mail]} { 
	return "/usr/ucb/mail $filename" 
    }
    if {[file executable /usr/bin/mailx]} { 
	return "/usr/bin/mailx -F $filename"
    }
    return "cat >> $filename"
}

#
# Return the name of the save folder file for news group 'groupname'
# e.g. 
#	[saveName comp.windows.x]
# will evaluate to something like
#	~/News/Comp.windows.x
#
proc saveName {groupname} {
    global Profile
    set s [string trimleft $groupname .]
    set firstchar [string toupper [string range $s 0 0]]
    set therest [string range $s 1 end]
    return [format "%s/%s%s" $Profile(FolderDir) $firstchar $therest]
}

proc articleLine {topw y} {
    if {[$topw.list.box size] > 0} {
	# get picked line
	set ln [$topw.list.box get [$topw.list.box nearest $y]]
	# see if there are any references on this line
	if {[llength [set refs [hdrMsgIds $ln]]] > 0} {
	    referencePager $refs
	}
    }
    return -1
}

###
### More callback functions.
###

# for use in binding stuff to the article text display
proc pipeBind {w binddesc msgid cmd} {
    bind $w $binddesc "nntpArticlePipe a \"$cmd\" $msgid"
}

###
### callbacks that remotely call $artcls_Interp
###

proc Send {i c} {
    # puts stderr "send $i $c"
    send $i after 1 "{ $c }"
}

proc r_newArt {specifier} {
    global artcls_Interp
    return [Send $artcls_Interp "newArt $specifier"]
}

proc r_cancelArticlesThatMatch {matchstr {filter ""}} {
    global artcls_Interp
    return [Send $artcls_Interp "cancelArticlesThatMatch $matchstr $filter"]
}

proc r_cancelArticlesOnPage {} {
    global artcls_Interp
    return [Send $artcls_Interp cancelArticlesOnPage]
}

# Note:
#  the use of filterSubject trashes any special string matching chars like *
#  so we don't have to worry about any unexptected matches happening
proc r_killCurrentSubject {} {
    global ArticleHeader artcls_Interp
    if {[info exists ArticleHeader(Subject)]} {
	r_cancelArticlesThatMatch \
	    [filterSubject $ArticleHeader(Subject)] filterSubject
    }
}

###
###
###


# function to allow user to bind keys etc.
# to article text widget
proc userArticleTextBind {w grp msgid} {
    global Profile

    # s == save
    set savefile [saveName $grp]
    pipeBind $w <KeyPress-s> $msgid [folderSaver $savefile]

    pipeBind $w <KeyPress-S> $msgid \
	"filesaver $Profile(FolderDir) - savedArticles"

    set availfile [format "%s/available" [glob ~]]
    pipeBind $w <KeyPress-a> $msgid [folderSaver $availfile]

    # p == print
    pipeBind $w <KeyPress-p> $msgid $Profile(PrintCommand)

    # XXX -- seems if you rebind something alot it 
    # it eventually leaves garbage at the end of the 
    # bind command so just do the static bindings once..
    #
    # XXX -- bind is supposed to return a empty string
    # here if there is no binding, it does not.
    # it returns something an string of form
    # no binding available for etc...
    set x [bind $w <space>]

    case $x {r_newArt*} {
	# already bound
    } default {
	# space == article at top of list viewport
	bind $w <space> {r_newArt first}

	# n == next article of the current subject
	bind $w <KeyPress-n> {r_newArt bysubject}

	# m == bring up cross references messages
	bind $w <KeyPress-x> {referencePager}

	# C == cancel all Articles
	bind $w <KeyPress-C> {r_cancelArticlesThatMatch *}

	# c == cancel all Articles on screen
	bind $w <KeyPress-c> {r_cancelArticlesOnPage} 

	# k == kill all articles w/ current subject
	#      and go to next article displayed
	bind $w <KeyPress-k> {
	    r_killCurrentSubject
	    r_newArt first
	}

	bind $w.list.box <ButtonPress-1> "articleLine $w %y"
    }
}

proc userArticleTextMenuBar {w} {
    global Profile
    makeMenuBar $w {
	"Read" {
	    "Current subject" command {r_newArt bysubject}
	    "First displayed article" command { r_newArt first }
	    "References" command {referencePager}
	}
	"Cancel" {
	    "Articles on this page" command {r_cancelArticlesOnPage}
	    "All Articles" command {r_cancelArticlesThatMatch *}
	}
	"Kill" {
	    "Articles with current subject" command {
		r_killCurrentSubject
		r_newArt first
	    }
	}
	"Write" {
	    "To printer" command {
		nntpArticlePipe a $Profile(PrintCommand)
	    }
	    "To folder" command { 
		global ArticleHeader
		if {[info exists ArticleHeader(X-Group)]} {
		   set t [getMsg .]
		   set sn [saveName $ArticleHeader(X-Group)]
		       showMsg . "appending to folder $sn..."
		       nntpArticlePipe a [folderSaver $sn]
		   showMsg . $t
		} else {
		    statusMsg "no current group to save under"
		}
	    }
	    "To file.." command {
		puts stderr "filesaver $Profile(FolderDir) - savedArticles"
		nntpArticlePipe a \
		    "filesaver $Profile(FolderDir) - savedArticles"
	    }
	}
    }
}

###
### functions to load an article from some source
###

# Returns:
#    Path name of the file for article 'artnum' in newsgroup 'group'
proc articleDiskName {group artnum} {
    global Profile
    set f [string trimright $Profile(NewsDir) /]
    foreach b [split [string trim $group .] .] { append f "/$b" }
    append f "/$artnum"
}

# Load the file for article 'artnum' in newsgroup 'group' from disk
# Returns:
#	0 if sucessful
#      -1 if file not readable
proc articleFromDisk {group artnum} {
    global ArticleHeader Profile
    set fname [articleDiskName $group $artnum]
    if {![file readable $fname]} {
	puts stderr "Cannot read '$fname'"
	return -1;
    }
    set fin [open $fname]
    set lookforhdr 1
    while {[gets $fin ln]>=0} {
	# puts stdout "$ln"
	if {$lookforhdr} {
	    if {[set lookforhdr [hdrAdd $ln ArticleHeader]]} {
		case $ln $Profile(ShowHeaderLines) {
		    listBoxAppendLine .artText $ln
		}
	    }
	} else {
	    listBoxAppendLine .artText $ln
	}
    }
    close $fin
    return 0;
}

# like articleFromDisk except it get it from the server
proc articleFromServer {group artnum}  {
    global Profile Server ArticleHeader
    # make request for the text
    nntpPuts "ARTICLE $artnum"

    # get response
    # 222 nnn <aaa> - article retrieved body follows
    #
    gets $Server(in) resp
    scan $resp "%d %d" code artnum
    case $code {22?} {
	# request recvd. and article is available. start reading the article..
	set lookforhdr 1
	for {set x 0} {[gets $Server(in) ln]>=0} {incr x} {
	    if {$lookforhdr} {
		if {[set lookforhdr [hdrAdd $ln ArticleHeader]]} {
		    case $ln $Profile(ShowHeaderLines) {
			listBoxAppendLine .artText $ln
		    }
		    continue
		}
	    }
	    case $ln {.\r .} {
		return 0;
	    } {..*} {
		listBoxAppendLine .artText [string range $ln 1 end]
	    } default {
		listBoxAppendLine .artText $ln
		### if {$x==100} { update }
	    }
	}
	# if we get here conenction went away.
	statusMsg "articleFromServer: connection died"
	return -1
    } default {
	# Hmmm... not what we expected
	listBoxAppendLine .artText "++++++ $resp +++++"
	return 0
    }
}

###
###
###

set CurrentGroup ""
proc setGroup {groupname} {
    global CurrentGroup
    if {$CurrentGroup!=$groupname} {
	set rval [nntpGroup s $groupname]
	if {$s!=211} {
	    statusMsg $rval
	    nntpRestart
	    return -2
	}
	set CurrentGroup $groupname
    }
    return 0
}

proc loadNewArticle {groupname artnum {noload 0}} {
    after 1 reallyLoadNewArticle $groupname $artnum $noload
    return 0
}

proc reallyLoadNewArticle {groupname artnum {noload 0}} {
    global CurrentGroup
    if {$groupname != $CurrentGroup} {
	statusMsg "warning: CurrentGroup is out of sync!, fixing..."
	setGroup $groupname
    }
    global ArticleHeader CurrentGroup Profile


    listBoxClear .artText.list.box

    if {![winfo ismapped .]} {
	# XXX does this work for all window mgrs??
	# if it does not work for yours and you are using
	# wish to run this script try --> map .artText
	wm deiconify .
    }

    unset ArticleHeader

    # 'bind' callback's occasionally need this 
    # and it's a convenient place to stash it...
    set ArticleHeader(X-Group) $groupname
    set ArticleHeader(Message-ID) "None"
    set ArticleHeader(Xref) "None"
    set ArticleHeader(Subject) ""

    showMsg . "fetching article..."
    set artFrom articleFromServer
    if {[$artFrom $groupname $artnum]!=0} { 
	return -1 
    } 

    # got the article OK
    if {$ArticleHeader(Message-ID)!="None"} {
	userArticleTextBind .artText \
	    $groupname $ArticleHeader(Message-ID)
    } else {
	statusMsg "warning: no Message-ID in header for $groupname <$artnum>"
    }
    # set title of article window
    showMsg . $ArticleHeader(Subject)
    if {$ArticleHeader(Subject)!=""} {
	global artcls_Interp
	Send $artcls_Interp \
	    [list setArticleHeader Subject $ArticleHeader(Subject)]
    }
    update

    # nail crossposts here...
    if {$ArticleHeader(Xref)!="None"} {
	global artcls_Interp
	foreach xref [hdrXrefs $Profile(Xrefname)  $ArticleHeader(Xref)] {
	    # puts stderr "Xref $xref nailed"
	    Send $artcls_Interp "rcMark [lindex $xref 0] [lindex $xref 1]"
	}
    }
    return 0
}

# load external files
foreach f { 
    setProfile.t
    nntp.t
    hdr.t
    menuBind.t
    makeMenuBar.t 
    listBoxHelper.t
    filterSubject.t
    pagerCreate.t
    referencePager.t
    showMsg.t
} {
    source $Profile(ArtclsLib)/$f
}

# initialize user profile
initProfile 0

proc Die {{w .}} { after 1 _Die $w }
proc _Die {{w .}} {
    destroy $w
    nntpDisconnect
    exit
}
proc hide {w} { 
    wm withdraw $w
}

# XXX -- You need mike hoegeman's WM_PROTOCOL patches for this to work
catch {wm protocol . delete {hide .}}

proc makePager {} {
    if {[pagerCreate .artText frame]} {
	# new, set static bindings
	bind .artText <ButtonPress-1>  {articleLine .artText %y}
	userArticleTextMenuBar .artText
	pack append .artText .artText.mb {top fill}
	pack append . .artText {top expand fill}
	wm geometry . 600x350
	wm minsize . 300 300
	wm maxsize . \
	    [expr [winfo screenwidth .]-64] \
	    [expr [winfo screenheight .]-64]
	wm withdraw .
    }
}

set x "OK"; 
catch {
    makePager
    nntpClientInit
    return "OK"
} x

if {$x!="OK"} {
    puts stderr "text.t: error\n$x"
    Die .
}
