# Bindings for file I/O

# Opens up $path/$name or just $name if it is a command pipeline, and
# dumps contents of text widget t into it.
proc write_file {t f path name} {
	global use_pipe
	if {([string match \|* $name])} {	set file [open $name w]
	} elseif $use_pipe {			set file [open "| $name" w]
	} else {				set file [open $path/$name w]}
	puts $file [$t get 1.0 end] nonewline
	close $file
}

proc default_file_prompter {msg} {
	global file_done fsBox text frame Keys
	set name $fsBox(name)
	create_f_entry $text $frame.filel $frame.filee {complete_string filter_glob ""}
	$frame.filel configure -text $msg
	if {(![string match \|* $name])} {$frame.filee insert 0 $fsBox(path)/}
	set index [$frame.filee index insert]
	$frame.filee insert $index $name
	$frame.filee icursor $index
	$frame.filee view [expr $index - [lindex [$frame.filee configure -width] 4]]
	parse_bindings $frame.filee \
$Keys(C_m)	 		{set file_done 1} \
C-g				{set file_done 2}
	global file_done cwd;	set file_done 0
	tkwait variable file_done
	set what [string trim [$frame.filee get] { }]

	destroy_f_entry $text $frame.filel $frame.filee
	if {$file_done == 2} {
		beep
		set fsBox(name) ""
		return 0}
	if {([string match \|* $what]) || ([file dirname $what] == ".")} {
		set fsBox(path) $cwd
		set fsBox(name) $what
	} else {set fsBox(path) [file dirname $what]
		set fsBox(name) [file tail $what]
	}
	return 1
}

# Get the path/file via a file prompting widget.
proc file_prompt {msg f} {
	global fsBox file_prompter
	set path $fsBox(path) ; set name $fsBox(name)
	set grab_status [grab status .] 
	$file_prompter $msg
	if {($grab_status != "none")} {take_control $f}
	if {($fsBox(name) == "")} {
		set fsBox(path) $path;	set fsBox(name) $name
		return 0}
	set fsBox(name) [string trimright $fsBox(name) "*/"]
	return 1
}


# File Messages
set confirm_save_msg " has been modified. Do you want to save it first?"
set save_msg "Select a file to save"
set read_msg "Select a file to read"
set mutual_edit_conflict_msg " is being editied by another interpreter. What should I do?"

# Variable to determine if file needs saving. (also set in editbind.tcl)
set modified 0

# Confirm if user wants to save the file.
proc save_confirm {default t f} {
	global modified confirm_save_msg fsBox
	set message "$fsBox(name) $confirm_save_msg"
	if {($modified == 1)} {
		set choice [tk_dialog .conf "Save Dialog" $message question 0 "Save" "Don't Save" "Cancel"]
		if {($choice == 0)} {save_file $t $f}
		if {($choice == 2)} {return 0} else {return 1}
}}

# Time we last accessed this file. (generally shortly after startup time)
after 1000 {catch {set atime [file mtime $fsBox(path)/$fsBox(name)]}}

proc save_file {t f} {
	global fsBox save_msg last_io
	if {($fsBox(name) == "") || ([string match \|* $fsBox(name)] &&
					($last_io == "read"))} {
		if {[save_file_prompt $t $f] == 0} {return 0}}
	if {([$t get {end -1 chars}] != "\n")} {$t insert end "\n"}
	write_file $t $f $fsBox(path) $fsBox(name)
	global modified atime;	set modified 0
	catch {set atime [file mtime $fsBox(path)/$fsBox(name)]}
	set_window_title $fsBox(name)
	check_for_duplicate_interps $t $f $fsBox(path) $fsBox(name)
	return 1
}

# Set to read or write depending on last operation performed.
set last_io "read"

proc save_file_prompt {t f} {
	global save_msg last_io
	if {([file_prompt $save_msg $f] == 0)} {return 0}
	set last_io "write"
	save_file $t $f
	return 1
}

proc revert_file {t f} {
	global fsBox read_msg last_io modified atime
	if {([save_confirm 1 $t $f] == 0)} {return}
	if {($fsBox(name) == "") || ([string match \|* $fsBox(name)] &&
					($last_io == "write"))} {
		set old_modified $modified
		set modified 0
		if {[read_file $t $f] == 0} {
			set modified $old_modified
			set return 0}}
	load_file $t end $f $fsBox(path) $fsBox(name)
	catch {set atime [file mtime $fsBox(path)/$fsBox(name)]}
	set_window_title $fsBox(name)
	check_for_duplicate_interps $t $f $fsBox(path) $fsBox(name)
	$t yview 1.0 ; $t mark set insert 1.0
	focus $t
	set modified 0
	return 1
}

proc read_file {t f} {
	global read_msg last_io modified
	if {([save_confirm 1 $t $f] == 0)} {return}
	set old_modified $modified
	set modified 0
	if {([file_prompt $read_msg $f] == 0)} {
		set modified $old_modified
		return 0}
	set last_io "read"
	revert_file $t $f
	set modified 0
	return 1
}

proc goto_file {f path name} {
	global all_interps me visit_cmd
	foreach him $all_interps {
		if {$him == $me} {continue}
		set his_name [check_send $him {set fsBox(name)}]
		set his_path [check_send $him {set fsBox(path)}]
		if {($his_name == 0) || ($his_path == 0)} {continue}
		if {($his_name != $name) || ($his_path != $path)} {continue}
		transfer_control $him $f
		return $him
	}
	eval exec $visit_cmd $path/$name &
	return ""
}

proc visit_file {f} {
	global fsBox read_msg all_interps me
	set path $fsBox(path);	set name $fsBox(name)
	if {([file_prompt $read_msg $f] == 0)} {return}
	goto_file $f $fsBox(path) $fsBox(name)
	set fsBox(path) $path;	set fsBox(name) $name
}

# Set modified if file has been modified since we last read/saved it.
proc check_mtime {} {
	global atime modified fsBox
	if {[catch {set atime}]} {return}
	if {[string match \|* $fsBox(name)]} {return}
	if {[catch {file mtime $fsBox(path)/$fsBox(name)}]} {set modified 1 ; return}
	if {([file mtime $fsBox(path)/$fsBox(name)] > $atime)} {set modified 1
}}


# Mutual file exclusion.

# Waits until all interps have titles differing from their interpreter names.
proc resolve_all_titles {} {
	global all_interps me
	foreach interp $all_interps {if {$interp != $me} {
		if {$interp == [send $interp wm title .]} {after 1000
}}}}

# Ensures no other interp is editing the same file I am editing.
proc check_for_duplicate_interps {t f path name} {
	# If we're looking at a pipe output, stdin, or
	# X selection, don't bother.
	if {[string match \|* $name] || ($name == "-") || \
		($name == {""}) || ($name == "X") || ($name == "=") ||
		($name == "")} {return}

	global all_interps me
	foreach him $all_interps {
		# Oh...it's just me.
		if {($me == $him)} {continue}
		# Maybe he's dead
		if {![check_interp $him]} {continue}
		# Maybe he's not ready yet.
		if {[send $him wm title .] == $him} {continue}
		# Maybe he's looking at a different file.
		if {[catch {send $him {set fsBox(name)}} result]} {continue}
		if {($name != $result)} {continue}
		# Maybe he's looking in a different directory.
		if {($path != [send $him "set fsBox(path)"])} {continue}
		# Maybe he can only browse. Fine.
		if {(![send $him "set edit_flag"])} {continue}
		# Oh well...gotta resolve it.
		resolve_mutual_edit_conflict $him "$path/$name" $t $f
}}

proc resolve_mutual_edit_conflict {him file t f} {
	global mutual_edit_conflict_msg
	set message "$file $mutual_edit_conflict_msg"
	set choice [tk_dialog .conf "Interpreter Dialog" $message warning \
      		0 "Quit" "Read another file" "Kill other interpreter" "Nothing"]
	if {($choice == 0)} {after 1000 quit_beth
	} elseif {($choice == 1)} {read_file $t $f
	} elseif {($choice == 2)} {catch {send $him {quit_beth
}}}}

# Confirm file saving on quit (a redefinition of quit_beth)
proc quit_beth {} {
	global quit_hook text frame
	if {([save_confirm 1 $text $frame] == 0)} {return}
	if {[info exists quit_hook]} {eval $quit_hook}
	exit
}


# File bindings. f is a frame widget to put messages in.
proc filebind {f t m} {
	bind . <Any-Enter> "check_mtime"
	parse_bindings all \
C-g			"+catch \{destroy_f_entry $t $f.filel $f.filee\}" \
M-R			"revert_file $t $f" \
M-S			"save_file_prompt $t $f" \
M-r			"read_file $t $f" \
M-s			"save_file $t $f" \
M-C-v			"visit_file $f"

	if {[winfo exists $m]} {
		parse_menuentries $m.file.m separator
		$m.file.m add checkbutton -label "Use a Pipe" -underline 6 \
			-variable use_pipe -offvalue 0 -onvalue 1
		$m.file.m add checkbutton -label "Gradual output" -underline 0 \
			-variable gradual_io -offvalue 0 -onvalue 1
		parse_menuentries $m.file.m {
				separator
					{Read 0 M-r}
					{Revert 1 M-R}
					{Save 0 M-s}
					{"Save as" 5 M-C-s}
					{Visit 0 M-C-v}}
}}

filebind $frame $text $menu

# Create file path label
catch {destroy $frame.fpl}
label $frame.fpl -relief flat -anchor e
label_expand_bind $frame.fpl fsBox(path)

# Create file name label
catch {destroy $frame.fnl}
label $frame.fnl -relief flat
label_expand_bind $frame.fnl fsBox(name)

pack $frame.fpl $frame.fnl -side left

if {(![info exists file_prompter])} {set file_prompter default_file_prompter}


# Ensure we're not editing file another beth interp is editing.
after 1 {
	after 20000 "set registered 1"
	tkwait variable registered
	catch {resolve_all_titles}
	if {[info exists name]} {
                catch {check_for_duplicate_interps $text $frame $path $name} msg
}}
