# Bindings for C/C++ code
# Uses the regions module...regions are C functions here, and filler is area
# between procs (including global variables/typedefs/includes)

# The heuristic for finding a function's boundaries are:
# A function begins with a type (such as int or char*). (Previous line ends
# with a close brace or whitespace or is empty) A function contains some
# stuff in parentheses and follows with an open brace. The function ends with
# said open brace's matching close brace.

load_library_module regions.tcl
load_library_module balancebind.tcl

proc region_end {t index} {
	set ob "\{"	; set cb "\}"
	set body_start [text_string_first $t $ob $index]
	return "[find_right_pair $t "$body_start +1 chars" $ob $cb] lineend"
}

# index points to a function's beginning
proc check_proc {t index} {
# First char must be legit in a type definition
	if {![regexp {[A-Z_a-z\*\(\)]} [$t get $index]]} {return 0}

# Last char before newline must be brace or whitespace or / (as in */)
# or . for collapsed fillers.
	if {![regexp {[\./\{\}\ \t\n]} [$t get "$index -2c"]] &&
		!([$t get "$index -2c"] == "\n")} {return 0}

# Must not be in a comment
	set comstart [text_string_first $t "/*" $index]
	set comend [text_string_first $t "*/" $index]
	if {($comstart == "") && ($comend != "")} {return 0}
	if {($comstart != "") && ($comend != "") &&
		[$t compare $comend < $comstart]} {return 0}

# Must have paren before brace
	set ob "\{"	; set cb "\}"
	set op "\("	; set cp "\)"
	set nextparen [text_string_first $t $op $index]
	set nextbrace [text_string_first $t $ob $index]
	if {($nextparen == "") || ($nextbrace == "")} {return 0}
	if {[$t compare $nextparen > $nextbrace]} {return 0}

# May not have semicolon before the first paren
	set nextsemi [text_string_first $t ";" $index]
	if {($nextsemi != "") && [$t compare $nextsemi < $nextparen]} {return 0}

	return 1
}

proc region_prev {t index} {
	set index "$index linestart"
	while {$index != "1.0"} {
		if {[check_proc $t $index]} {	return $index	}
		set index [$t index "$index -1 lines"]
	}
	return ""
}

proc region_next {t index} {
	set index "$index linestart +1 lines"
	while {![$t compare $index == end]} {
		if {[check_proc $t $index]} {	return $index	}
		set index [$t index "$index +1 lines"]
	}
	return ""
}

# For when the collapsing module is available
proc region_collapse_indicate {t start end} {
	if {[$t compare "$start linestart" == "$end linestart"]} {return ""}
	set op "\("  ;	set cp "\)"
	set ob "\{"  ;	set cb "\}"
	set index [text_string_first $t $cp $start $end]
	return "[$t get $start "$index +1c"] $ob...$cb"
}

# Since a 'filler' in C code consists of some prev decls and, most likely,
# a comment about the forthcoming function, return a description of the
# pre-comment stuff (... if nonempty), then a description of the comment
# (/* start of comment ... end of comment */)
# Do not collapse if only one line break before comment and comment is
# only one line long. (Return text is two lines...this makes a space between
# functions and makes collapsed code look neater.)
proc filler_collapse_indicate {t start end} {
	if {[$t compare $start >= "$end -1 lines"] && ([$t get $start] == "\n")} {return ""}
	set commstart [text_string_last $t "/*" $end $start]
	if {$commstart == ""} {
		set result [selection_indicate $t $start $end]
		if {$result == ""} {return ""} else {return "\n$result"}}
	set commend [text_string_first $t "*/" $commstart $end]

	if {[$t compare "$commstart -1c" == $start]} {
		set prefix ""} else {set prefix "..."}
	set commstart "$commstart +2c"

	set result [selection_indicate $t $commstart $commend]
	if {($result == "") && ($prefix == "")} {return ""}
	if {($prefix != "") && ($result == "")} {
		if {[set result [$t get $commstart $commend]] == ""} {
			append prefix "\[[string range [gensym] 3 end]\]..."
	}}

	return "\n$prefix\/*$result\*/"
}

if $edit_flag {

set adjust_line_width 0

# Splits line if it is longer than length. Returns number of extra lines
# produced (0 is if line was not broken). Index is on line to break, length
# is desired length, string is contents of line.
proc split_line {t begin {prefix "#"} {length ""} {string ""}} {
	set begin [$t index $begin]
	if {($string == "")} {
		set string [$t get $begin "$begin lineend"]
	}
	if {($length == "")} {
		global adjust_line_width 
		if $adjust_line_width {
			set length $adjust_line_width
		} else {set length [lindex [$t configure -width] 4]}}
	set len [expr $length - [string length $prefix] - 1 ]

	if {([string length $string] < $len)} {
		$t insert $begin "$prefix "
		return 0}
	set offset [string last " " [string range $string 0 $len]]
	if {($offset < 0)} {return 0}
	set break [$t index "$begin +$offset chars"]
	$t delete $break
	$t insert $break "\n"
	set breaks [split_line $t "$break +1c" $prefix $length]
	$t insert $begin "$prefix "
	global modified ; set modified 1
	return [incr breaks]
}

proc do_adjust_region {t begin end length} {
	global modified ; set modified 1
	scan [$t index $begin] "%d.%d" beginrow dummy
	scan [$t index $end] "%d.%d" endrow dummy
	for {set i $endrow} {$i > $beginrow} {incr i -1} {
		while {[$t get "$i.0"] == " "} {$t delete "$i.0"}
		$t insert "$i.0" " "
		$t delete "$i.0 -1c"}
	set line [$t get $begin "$begin lineend"]
	set delim [string first "/" $line]
	incr delim [string first " " [string range $line $delim end]]
	set prefix " "
	for {set j 1} {$j < $delim} {incr j} {append prefix " "}

	set begin_prefix [$t get $begin "$begin +[string length $prefix] c"]
	$t delete $begin "$begin +[string length $prefix] c"
	split_line $t $begin $prefix $length
	$t delete $begin "$begin +[string length $prefix] c +1c"
	$t insert $begin $begin_prefix
}

# Adjusts selected region to fit in length columns, so that no lines wrap
# If unspecified, length defaults to window width.
proc adjust_region {t begin end {length ""}} {
	set begin [$t index $begin]
	set end [$t index $end]
	set chars [$t get $begin $end]
	set m1 [gensym] ; set m2 [gensym]
	$t mark set $m2 $end
	do_adjust_region $t $begin $end $length
	$t mark set $m1 $begin
	register_undoable_cmd $t [list undo_filter $t $m1 $m2 $chars] "Adjust $chars" "$m1 $m2"
}

proc adjust_function {t} {
	if {[$t get insert "insert +2c"] == "/*"} {
		set begin [$t index insert]
	} elseif {[$t get "insert-1c" "insert +1c"] == "/*"} {
		set begin [$t index "insert -1c"]
	} else {set begin [text_string_last $t "/*" insert]}
	if {[$t get "insert -2c" insert] == "*/"} {
		set end [$t index insert]
	} elseif {[$t get "insert -1c" "insert +1c"] == "*/"} {
		set end [$t index "insert +1c"]
	} else {set end "[text_string_first $t "*/" insert] +2c"}
	adjust_region $t $begin $end
}


# C bindings.
proc cbind {f m} {
	parse_bindings Text \
M-j			{adjust_function %W}

	if {[winfo exists $m]} {parse_menuentries $m.edit.m {
					{"Reformat Comment" 0 M-j}}
}}

cbind $frame $menu
}
region_bind $frame $menu "Function" 0
set regions_defined 1
