# Module for loading selected Beth libraries.

# These are the modules that can be added to Beth interactively.
# via the menu or ka keyboard. Items are:
# {menu-title menu-underline-index keybinding module disable_var}
set addable_modules {
	{{Abbreviation Expansion} 0 M-a $add_abbrevbind tab_completion_defined}
	{{Parentheses Balancing} 12 M-J $add_balancebind balancebind_loaded}
	{{Collapsing Text} 1 M-O $add_collapsebind collapsebind_loaded}
	{{C Code} 0 C-A $add_cbind regions_defined}
	{{Lisp Code} 0 C-D $add_lispbind regions_defined}
	{{Make Output} 0 M-e $add_makebind makebind_loaded}
	{{Tcl/Tk Code} 5 C-E $add_tclbind regions_defined}
	{{Text Processing} 0 M-j $add_textbind regions_defined}
}

# These indicate a file suffix that automatically loads a file.
# Items are {command suffix suffix ...}
set suffix_adding_list {
	{$add_cbind ".c" ".cc" ".C" ".h" ".hh" ".H"}
	{$add_lispbind ".l" ".lsp" ".lisp" ".scm"}
	{$add_tclbind ".t" ".tcl"}
	{$add_textbind ".txt"}
}


# Some procedures useful to libraries

proc modules_completion_variable {module} {
	return "[string range $module 0 [expr [string length \
			$module] - 5]]_loaded"
}

# Loads library module, ensuring it gets loaded only once. Returns 1 if it
# was already loaded.
proc load_library_module {module {label ""}} {
	set loaded_variable [modules_completion_variable $module]
	if {[uplevel #0 info exists $loaded_variable]} {return "$module is already loaded"}
	global beth_lib_dir $loaded_variable ; set $loaded_variable 1
	uplevel #0 source $beth_lib_dir/$module
	global frame
	if {$label == ""} {set label $loaded_variable}
	flash_label $frame -text $label
	return 1
}



# Set some variables to load the modules in lib.
# This makes add_foobar load add_foobarbind.tcl
# The user can use these to load modules
foreach module [exec ls $beth_lib_dir] {
	if {[string match *.tcl $module]} {
		set module2 [file tail $module]
		set add_[string range $module2 0 [expr [string length \
		    $module2]  - 5]] "load_library_module $module2"
}}


proc disable_menuentries {m entry args} {
	$m entryconfigure $entry -state disabled}

foreach am $addable_modules {eval parse_bindings all [lrange $am 2 3]}
if {[winfo exists $menu]} {
	parse_menu $menu {Modules 0 {separator}}
	foreach am $addable_modules {
		trace variable [lindex $am 4] w "disable_menuentries $menu.modules.m [list [lindex $am 0]]"
		parse_bindings Text [lindex $am 2] "eval [lindex $am 3]"
		parse_menuentries $menu.modules.m [list [lrange $am 0 2]]}}


# If option is a file with an ending in args, execute cmd.
proc load_if_suffix {option cmd args} {
	set doit 0
	foreach suffix $args {
		if {[file extension $option] == $suffix} {set doit 1}}
	if $doit {uplevel #0 $cmd}
}
if {(![string match \|* $option])} {foreach item $suffix_adding_list {
	eval load_if_suffix [list $option] $item
}}
