
/* Copyright (c) 1994
 *      Zbigniew Wieckowski (wieckows@cs.umn.edu)
 *
 * Permission is granted to freely use, copy, modify, and redistribute
 * this software under the terms of the GPL licence agreement.
 */

#include <stdlib.h>
#include "myScreen.h"
extern screen scr;

extern void pass_all(int, int);

#ifdef __cplusplus
extern "C" {
#endif

#include <unistd.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <signal.h>
#include "screen.h"

struct win myWindow;
int screenwidth;
int screenheight;
char* blank;
char* OldImage;
char* OldAttr;
char* OldFont;

extern void ResetScreen(
#if defined(__STDC__) || defined(__cplusplus)
struct win*
#endif
);

int err_quit();

int pty_master();

int err_sys();

int tty_getmode(
#if defined(__STDC__) || defined(__cplusplus)
int
#endif
);

int pty_slave(
#if defined(__STDC__) || defined(__cplusplus)
int
#endif
);

int tty_setmode(
#if defined(__STDC__) || defined(__cplusplus)
int
#endif
);

int exec_tcsh(
#if defined(__STDC__) || defined(__cplusplus)
int, char**, char**
#endif
);

int tty_raw(
#if defined(__STDC__) || defined(__cplusplus)
int
#endif
);

int tty_reset(
#if defined(__STDC__) || defined(__cplusplus)
int
#endif
);

#ifdef __cplusplus
};
#endif

void sig_quit(int);

main(int argc, char **argv, char **envp)
{
  int h, h1, w, w1;

//  if (SIG_IGN != signal(SIGQUIT, SIG_IGN))
//    signal(SIGQUIT, sig_quit);     
  if (argc < 3)
    w = 80;
  else
    w = atoi(argv[2]);
  if (argc < 2)
    h = 24;
  else
    h = atoi(argv[1]);

  scr.set_disp_width(w);
  scr.set_disp_height(h);
  scr.init_disp();
  screenwidth = w;
  screenheight = h;

  myWindow.width = w;
  myWindow.height = h;
  myWindow.state = LIT;
  myWindow.stringp = myWindow.string;
  myWindow.string[0] = '\0';
  myWindow.active = 1;
  myWindow.flow = 7;

  blank = (char*)malloc(myWindow.width*sizeof(char));
  OldImage = (char*)malloc(myWindow.width*sizeof(char));
  OldAttr = (char*)malloc(myWindow.width*sizeof(char));
  OldFont = (char*)malloc(myWindow.width*sizeof(char));

  for (w1 = 0; w1 < myWindow.width; w1++)
    *(blank + w1) = ' ';

  myWindow.image = (char**)malloc(h*sizeof(char*));
  for (h1 = 0; h1 < h; h1++) {
    myWindow.image[h1] = (char*)malloc(w*sizeof(char));
    strncpy(myWindow.image[h1], blank, myWindow.width);
  }

  myWindow.attr = (char**)malloc(h*sizeof(char*));
  for (h1 = 0; h1 < h; h1++)
    myWindow.attr[h1] = (char*)malloc(w*sizeof(char));

  myWindow.font = (char**)malloc(h*sizeof(char*));
  for (h1 = 0; h1 < h; h1++)
    myWindow.font[h1] = (char*)malloc(w*sizeof(char));

  myWindow.tabs = (char*)malloc((myWindow.width + 1)*sizeof(char));

     int master_fd, slave_fd, childpid, fd;
     
     if (!isatty(0) || !isatty(1))
	  err_quit("stdin and stdout must be a terminal");
     
     if ( (master_fd = pty_master()) < 0)
	  err_sys("can't open master pty");
     if (tty_getmode(0) < 0)
	  err_sys("can't get tty mode of standard input");
     
     if ((childpid = fork()) < 0)
	  err_sys("can't fork");
     else if (childpid == 0) {      /* child process */
/*
 * First disassociate from control terminal.
 */

       if ( (fd = open("/dev/tty", O_RDWR)) >= 0) {
	 if (ioctl(fd, TIOCNOTTY, (char *) 0) < 0)
	   err_sys("ioctl TIOCNOTTY error");
	 close(fd);
       }

       /*
	* Now open slave pty device.
	*/

	  if ( (slave_fd = pty_slave(master_fd)) < 0)
	       err_sys("can't open pty slave");
	  close(master_fd);
	  if (tty_setmode(slave_fd) < 0)
	       err_sys("can't set tty mode of pty slave");

	setsid();
	  
	  exec_tcsh(slave_fd, argv, envp);
	  /* NOTREACHED */
     }
     
     if (tty_raw(0) < 0)                    /* set stdin tty to raw mode */
	  err_sys("tty_raw error");

     pass_all(master_fd, childpid);

     if (tty_reset(0) < 0)                  /* reset stdin mode */
	  err_sys("tty_reset error");

  for (h1 = 0; h1 < h; h1++)
    free((void*)(myWindow.image[h1]));
  free((void*)(myWindow.image));

  for (h1 = 0; h1 < h; h1++)
    free((void*)(myWindow.attr[h1]));
  free((void*)(myWindow.attr));

  for (h1 = 0; h1 < h; h1++)
    free((void*)(myWindow.font[h1]));
  free((void*)(myWindow.font));

  free((void*)(myWindow.tabs));
  free((void*)(blank));
  free((void*)(OldImage));
  free((void*)(OldAttr));
  free((void*)(OldFont));

  exit(0);
}

void
sig_quit(int s)
{
   signal(SIGQUIT, sig_quit);
}
