'	# DS - begin display
.de DS
.RS
.nf
.sp
..
'	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.TH "EXMH REFERENCE" 1 "October 14, 1994" "Exmh 1.5"
.SH "EXMH REFERENCE CHAPTER"
.PP
Information for the "purple pages".
.SH "COMMAND LINE OPTIONS"
.PP
There are just a handful of command line options for exmh.
Note that Xt-like command line options are not supported because
\fIexmh\fP is based on Tk, not Xt.
.IP "\fB\-bgAction \fIaction\fR" 15
Override background processing setting.
Valid actions are: off, count, msgchk, flist, and inc.
.IP "\fB\-bgPeriod \fIminutes\fR" 15
Override background period setting.
.IP "\fB\-geometry \fIgeometry\fR" 15
Initial geometry to use for the window.  Exmh remembers the geometry
when you change it interactively, so you do not really need to
specify it each time on the command line.
.IP "\fB\-iconposition \fIgeometry\fR" 15
Initial position to use for the icon in the form +\fIxoff\fP+\fIyoff\fP.
You can use minus signs instead of + to position relative to the right
and bottom of the screen.
.IP "\fB\-iconic\fR" 15
Begin execution iconic.
.IP "\fB\-sedit\fR" 15
Override the editor command defined in Preferences and use
the built-in editor (sedit) instead.
.IP \fIfolder\fP
If the argument is not one of the flags given above, it is assumed to
be the name of a folder.  In this case \fIexmh\fP begins in that folder.
.SH "MAIN BUTTONS AND MENUS"
.TS
center;
c s s
lw(1.25i)1 lw(1.25i)1 lw(3.0i)1.
Exmh Main Buttons (top row)
Menu/Button	Tcl Command	Explaination
_
Help	-	A menu with three choices:
Quick Intro	Help	T{
Some get-started information.
T}
Color Legend	Help_KeyDisplay	T{
A highlighting key for color or monochrome screens.
T}
Frequently Asked Questions	Help FAQ	T{
Displays the exmh.FAQ file.
T}
_
Bindings	-	T{
A menu with two choices:
T}
Commands	Bind_Pref	T{
Dialog to change command key bindings.
T}
Simple Edit	Sedit_Pref	T{
Dialog to change editting key bindings.
T}
_
Log	ExmhLogShow	T{
Display the debug log, if it is enabled.
T}
Aliases	Aliases_Pref	T{
Display an interface to the MH alias file.
T}
Preferences	Preferences_Dialog	T{
Display the preferences user interface.
T}
Quit	Exmh_Done	Quit exmh.
.TE
.SH "FOLDER BUTTONS AND MENU"
.PP
.TS
center;
c s s
lw(1.5i)1 lw(1.5i)1 lw(2.5i)1.
Folder Buttons (middle row)
Menu/Button	Tcl Command	Explaination
_
Pick	Pick	T{
An interface to the MH \fIpick\fP command.
T}
New	Folder_New	Create a new mail folder.
Find	Find_Setup	T{
Display find dialog.
T}
Flist	T{
Fdisp_ClearHighlights\ ;
busy Flist_FindUnseen
T}	T{
Refreshes highlights of labels for folders with unseen messages.
T}
Inc	Inc	T{
Incorporate new mail from your spool file.
T}
Commit	Folder_Commit	T{
Commit pending delete and move operations.
T}
_
More...	-	T{
A menu with more folder operations:
T}
Rescan folder	T{
busy Scan_FolderForce\ ;
Msg_ShowSomething
T}	T{
Force a rescan of the folder contents.
T}
Pack folder	T{
busy Folder_Pack\ ;
Msg_ShowSomething
T}	T{
Renumber messages in the current folder to eliminate any gaps in the number sequence.
T}
Sort folder	T{
busy Folder_Sort\ ;
Msg_ShowSomething
T}	T{
This will sort the current folder by date.
T}
Find all folders	Flist_Refresh	T{
Scan the file system for all your folders.
T}
Delete folder	Folder_Delete	Delete a folder.
Catch-up Unseen	Pick_MarkSeen	T{
Clear the unseen sequence from the current folder.
T}
Update scan caches	Scan_AllFolders	T{
Updates any scan caches that are out of date.
T}
Update all scan caches	Scan_AllFolders 1	Rescans all folders.
Purge folder	Folder_PurgeBg	T{
Delete old messages renamed by \fIrmm\fP.
T}
Purge all folders	Folder_PurgeAllBg	Purge all folders.
Import mailbox folders	Import_Dialog	Copy messages from mailtool folders.
.TE
.SH "MESSAGE BUTTONS AND MENUS"
.PP
.TS
center;
c s s
lw(1.25i)1 lw(1.25i)1 lw(3.0i)1.
Message Buttons (bottom row)
Menu/Button	Tcl Command	Explaination
_
Forward	Msg_Forward	Forward the current message(s).
Send	Msg_Compose	Compose a mail message.
Prev	Ftoc_Prev show	Show previous message.
Next	Ftoc_Next show	Show next message.
Delete	Msg_Remove	T{
Mark the current message(s) for deletion and advance.
T}
Move	Msg_Move Ftoc_MoveMark	T{
Mark the selected message(s) to be moved to the target folder and go to the next message.
T}
Link	Msg_Move Ftoc_CopyMark advance?	T{
Link message to target folder.
T}
_
"Reply..."	-	T{
This is a menu of reply options.
T}
Reply to sender	Msg_Reply -nocc all	T{
Reply to the current message, only to the person that send the original.
T}
Reply all	Msg_Reply -cc all	T{
Reply to the current message, including on the cc line everyone that got the original message.
T}
Reply help	Msg_ReplyHelp	T{
Explains how to add more Reply... menu entries.
T}
_
More...	-	T{
This is a menu of more message operations:
T}
Print	Print	T{
Print the current message(s).
T}
Unmark (Undo)	Ftoc_Unmark	T{
Cancel a move or delete mark on the selected message(s).
T}
Clip	Msg_Clip	T{
Display a new the current message in a new window.
T}
First Unseen	Msg_ShowUnseen	T{
Display the first unseen message, if any.
T}
Burst Digest	Msg_BurstDigest	T{
Use MH \fIburst\fP to split up a digest message into its individual messages.
T}
Redistribute	Msg_Dist Mh_DistSetup	T{
Resend a message to a different recipient.
T}
Save to file	Msg_Save	T{
Copy the current message(s) to a file.
T}
Use message as draft	Msg_CompUse	T{
Copy the current message into the drafts folder and opens your editor on the message.
T}
Edit message	Msg_Edit	T{
Open your editor on the current message.
T}
uudecode message	Msg_UUdecode	T{
Run \fIuudecode\fP with the current message as input.
T}
Print as postscript	Print_Postscript	T{
Strip lines before %! and print the rest.
T}
Apply to message	Message_Apply	T{
This runs a UNIX command over the current message, headers and body.
T}
Apply to body	Message_Apply body	T{
This runs a UNIX command over a temporary file containing the body of the current message.
T}
Mark Unseen	Msg_MarkSeen	T{
Put the current message(s) back into the unseen sequence.
T}
PGP view	Pgp_view	T{
Temporarily decrypt a message using PGP.
T}
PGP decrypt	Pgp_decrypt	T{
Decrypt and save a message using PGP.
T}
.TE
.SH "SEDIT BUTTONS AND MENUS"
.PP
The following table describes the buttons and menus for
the built-in editor, sedit.
Most of these Tcl commands are parameterized by $draft and $t to
allow for multiple drafts in progress.
.TS
center;
c s s
lw(1.25i)1 lw(1.25i)1 lw(3.0i)1.
Simple Editor (sedit) Buttons
Menu/Button	Tcl Command/Variable	Explaination
_
Abort	SeditAbort $draft $t	T{
This deletes the draft message and removes the editor window.
T}
Save&Quit	SeditSave $draft $t SeditNuke	T{
This will save the message and quit the editor window.
T}
Help	SeditHelp	T{
Display a window with a short explanation of the editor.
T}
Insert @	SeditInsertFile $draft $t @	T{
Format and insert the message being replied to.
Only enabled during replies.
T}
Sign	SeditSign $draft $t	T{
This appends your ~/.signature file to the draft.
If this file is instead an executable script or program, it is
executed in order to generate the signature.
T}
Sign...	-	T{
A menu of signature possibilities, which are
all files that match the ~/.signature* pattern
T}
Send	SeditSend $draft $t	T{
Send the message.
T}
Whom	SeditWhom $draft $f $t	T{
Expand aliases to determine who the message is going to.
T}
Text...	-	T{
This menu is used to add bold, italic, underline, etc. to your messages.
This results in a MIME message of type text/enriched.
T}
_
More...	-	T{
This menu contains a few entries for less common operations.
The first three are checkbox entries that set the
named Tcl variable.
T}
Keep on send	sedit($t,keep)	T{
If selected it prevents the editor window from disappearing after you
send or abort a message.
T}
Format mail	sedit($t,format)	T{
Enables line breaking and text/enriched encoding.
T}
Attempt mhn	sedit($t,mhn)	T{
Run your message through \fImhn\fP to create MIME messages.
T}
Insert File...	SeditInsertFileDirect $draft $t	T{
Insert a file into the message without MIME formatting.
T}
Insert Part...	SeditInsertFileDialog $draft $t	T{
Insert a file as part of a MIME message.
T}
Insert External...	SeditInsertExternalDialog $draft $t	T{
Create a Message/External-Body MIME message part.
T}
Save	SeditSave $draft $t	T{
Save the editor buffer to disk.  This does \fInot\fP mean
the draft is preserved after you send it.  Use Save&Quit or
Keep on Send instead.
T}
Spell...	SeditSpell $draft $f $t	T{
This runs a spell command over the draft body.
T}
Find SEL	Sedit_Find $draft $t	T{
This searches the draft for the current X selection.
T}
_
PGP	-	T{
A menu of Pretty Good Privacy commands.
These all work by inserting a pgp-action
header into the message, and the action takes
effect when the message is sent.
T}
encrypt	Pgp_encrypt encrypt $draft $t	T{
Encrypt a message for the recipients of the message.
T}
sign clear	Pgp_encrypt signclear $draft $t	T{
Digitally sign a plain text message.
T}
sign binary	Pgp_encrypt signbinary $draft $t	T{
Digitally sign and base64-encode the message.
T}
encrypt & sign	Pgp_encrypt encryptsign $draft $t	T{
Encrypt and sign the message.
T}
.TE
.SH "WHAT NOW BUTTONS AND MENUS"
.PP
The What Now dialog is opened after you edit a draft
with an external editor that is run via the
exmh-async wrapper script.
.TS
center;
c s s
lw(1.25i)1 lw(1.25i)1 lw(3.0i)1.
What Now Dialog
Menu/Button	Tcl Command	Explaination
_
Kill	EditDialogDone abort $id	T{
Remove the draft instead of sending it.
T}
Dismiss	EditDialogDone dismiss $id	T{
Leave the draft in the drafts folder - do not send, yet.
T}
Re-edit	EditDialogDone reedit $id nohide	T{
Re-run the editor on the draft.
T}
Send	EditDialogDone send $id	T{
Send the message.
T}
_
More...	-	T{
A menu with more operations:
T}
Whom	EditDialogDone whom $id nohide	T{
Expand aliases to determine who the message is going to.
T}
MHN	EditDialogDone mhn $id nohide	T{
Run the draft through MHN.
T}
Spell	EditDialogDone spell $id nohide	T{
Run a spell program on the message.
T}
Sedit	EditDialogDone sedit $id	T{
Run the built-in editor on the message.
T}
.TE
.SH "EXTERNAL EDITOR INTERFACE"
.PP
The following Tcl commands are designed to be used with
an external Tcl-based editor.  Use the Tk send command
to get \fIexmh\fP to do these operations.
.TS
center;
c s
lw(1.25i)1 lw(4.25i)1.
Tcl Interface for External Editors
Tcl Command	Explaination
_
Edit_Dialog $id	T{
Display the WhatNow dialog for the draft.  The $id is the message number of the draft.  Alternatively, the following commands can be issued directly
from the editor's interface.
T}
Edit_Done send $id	T{
Send the message $id in the drafts folder.
T}
Edit_Done reedit $id	T{
Re-edit the message.
T}
Edit_Done sedit $id	T{
Run the built-in editor on the message.
T}
Edit_Done spell $id	T{
Run a spell program on the message.
T}
Edit_Done mhn $id	T{
Run MHN on the message.
T}
Edit_Done abort $id	T{
Remove the draft message.
T}
Edit_Done dismiss $id	T{
Leave the message in the drafts folder.
T}
Edit_Done whom $id	T{
Run the MH \fIwhom\fP program on the message.
T}
.TE
.SH "COMMAND KEYS"
.PP
The following table lists command key bindings.
The keystroke syntax is given as you would
specify it to the Tk bind command. 
Capitalization is important.
Note that
punctuation characters are spelled out;
these are X \fIkeysyms\fP.  The special
keysyms like Next may vary from keyboard to
keyboard.  You can change these bindings via
the Command Binding menu entry, and the results
are saved in your ~/.exmhbindings file.
.TS
center;
c s s
lw(1.25i)1 lw(1.25i)1 lw(3.0i)1.
Command Key Bindings
Keystroke	Tcl Command	Explaination
_
<Key-c>	Msg_Compose	T{
Open the editor on a new draft message.
T}
<Key-d>	Msg_Remove	T{
Delete the current message(s).
T}
<Key-D>	Msg_RemoveNoshow	T{
Delete the current message(s) and advance without displaying.
T}
<Key-f>	Msg_Forward	T{
Forward the current message(s).
T}
<Key-F>	Folder_Unseen	T{
Change to the next folder with unseen messages.
T}
<Key-i>	Inc	T{
Incorporate Mail
T}
<Key-m>	Msg_Move	T{
Refile the current message(s) to the target folder.
T}
<Key-M>	Msg_MoveNoshow	T{
Refile the current message(s) and advance without displaying.
T}
<Key-n>	Ftoc_Next show	T{
Display the next message.
T}
<Key-N>	Ftoc_Next noshow	T{
Select, but do not display, the next message.
T}
<Key-p>	Ftoc_Prev show	T{
Display the previous message.
T}
<Key-P>	Ftoc_Prev noshow	T{
Select, but do not display, the previous message.
T}
<Key-r>	Msg_Reply -nocc all	T{
Reply to the sender of the current message.
T}
<Key-R>	Msg_Reply -cc all	T{
Reply to the sender and all recipients of the current message.
T}
<Key-s>	Msg_ShowCurrent	T{
Display the currently selected message.
T}
<Control-s>	Find_It forw	T{
Search forward in message or FTOC.
T}
<Key-u>	Ftoc_Unmark	T{
Unmark the current message(s).
T}
<Key-U>	Msg_ShowUnseen	T{
Show the next unread message.
T}
<asciicircum>	Msg_First	T{
Select, but do not display, the first message in the folder.
This key prints as ^.
T}
<dollar>	Msg_Last	T{
Select, but do not display, the last message.
This key prints as $.
T}
<minus>	Ftoc_PrevMarked	T{
Display the the previous message, whether or not it is marked.
This key prints as -.
T}
<space>	Msg_PageOrNext	T{
Page down the message or advance to the next one.
T}
<question>	Bind_Pref	T{
Display command binding user interface.
This key prints as ?.
T}
<BackSpace>	Msg_PageUp	T{
Page back through the message.
T}
<Prior>	-	Same as <BackSpace>
<Up>	-	Same as <BackSpace>
<Next>	Msg_PageDown	T{
Page down in the message display.
T}
<Down>	-	Same as <Next>
<Control-p>	Ftoc_PageUp	T{
Page up the folder table of contents.
T}
<Shift-Prev>	-	Save as <Control-p>
<Control-r>	Find_It prev	T{
Search backwards in message or FTOC.
T}
<Control-Return>	Folder_Commit	T{
Commit pending deletes and refiles.
T}
<Control-n>	Ftoc_PageDown	T{
Page down the folder table-of-contents.
T}
<Shift-Next>	-	Same as <Control-n>
.TE
.SH "EDITTING KEYS"
.PP
The following table lists editting key bindings.
These are used in the built-in editor and,
where applicable,
in the text entry widgets in dialogs.
You can change (but not extend) these bindings via
the Simple Edit menu entry, and the results
are saved in your ~/.exmhsedit file.
.TS
center;
c s s
lw(1.25i)1 lw(1.25i)1 lw(3.0i)1.
Simple Edit Bindings
Keystroke	mnemonic	Explaination
_
<Control-h>	backspace	Destructive backspace.
<BackSpace>	backspace
<Control-b>	backchar	Move cursor back a character.
<Key-Left>	backchar
<Meta-less>	bof	Move to beginning of buffer.
<Meta-b>	backword	Move cursor back a word.
<Control-d>	delchar	Delete the character ahead of cursor.
<Control-x><Delete>	delbol	Delete to beginning of line.
<Meta-h>	delwordback	Delete back a word.
<Control-k>	deleol	Delete to end of line.
<Control-n>	down1line	Move cursor down one line.
<Key-Down>	down1line
<Meta-d>	delwordforw	Delete word ahead of cursor.
<Meta-greater>	eof	Move to end of buffer.
<Control-v>	down1page	Scroll down one page.
<Meta-f>	forwword	Move cursor ahead one word.
<Control-f>	forwchar	Move cursor ahead one characer.
<Key-Right>	forwchar
<Control-a>	linestart	Move cursor to beginning of line.
<Control-e>	lineend		Move cursor to end of line.
<Control-w>	seldelete	Cut the selection.
<Delete>	seldelete
<Control-o>	openline	Open a new line after the cursor.
<Control-c><Control-c>	sendMsg	Send the draft.
<Control-y>	selpaste	Paste the selection.
<Meta-t>	transword	Transpose words.
<Control-t>	transpose	Transpose characters.
<Meta-v>	up1page	Scroll up one page.
<Control-p>	up1line	Move cursor up one line.
<Key-Up>	up1line
.TE
