# 
# extrasInit.tcl
#
# This has initialization code for some extra packages.
# The idea is to avoid auto_loading the whole package,
# while still allowing the package to manifest itself
# in the preferences dialog (for example).
#
# Copyright (c) 1993 Xerox Corporation.
# Use and copying of this software and preparation of derivative works based
# upon this software are permitted. Any distribution of this software or
# derivative works must comply with all applicable United States export
# control laws. This software is made available AS IS, and Xerox Corporation
# makes no warranty about the software, its performance or its conformity to
# any specification.

proc Faces_Init {} {
    global faces
    if {$faces(dir) == {}} {
	set faces(enabled) 0
    }
    Preferences_Add "Faces" \
"Exmh will display the facesaver bitmap of the person that sent the current message (or their organization). This relies on the facesaver database, or the presence of an X-Face mail header.  To decompress X-Face headers, you need uncompface and ikon2xbm." {
	{faces(enabled) facesEnabled ON {Show face bitmap}
"Display the bitmap image from
the facesaver database."}
	{faces(mapsEnabled) facesMap ON {Use people.tab and machine.tab}
"The facesaver database supports an alias mechanism implemented
with mapping files.  These are normally consulted to map users and
hosts into a general, site-specific form.  This option enables
or disables the use of these alias files."}
	{faces(xfaceProg) xfaceProg {} {X-Face pipeline}
"A pipeline to convert an X-Face: header line into
a displayable X11 bitmap.
Typically:   uncompface | ikon2xbm
This is independent of the facesaver database."}
    }
}

proc Sound_Init {} {
    global sound
    if {$sound(cmd) == {}} {
	set sound(enabled) 0
    } else {
	# Preferences_Add will set these variables to Xresource values,
	# but only if the variables are not already defined.
	# These sound variables are defined at install time,
	# so we need to unset them in order honor any per-user defaults.
	set cmd $sound(cmd) ; unset sound(cmd)
	set new $sound(newMsg) ; unset sound(newMsg)
	set err $sound(error) ; unset sound(error)
	Preferences_Add "Sound" \
"Exmh can provide audio feedback if your workstation is capable of playing audio files." \
	[list \
	    { sound(enabled) soundEnabled ON {Sound feedback}
"Enable audio feedback.  Exmh will make a sound when
new messages are incorporated into your folders
(except during startup) and when you try to change
folders without committing moves and delete operations."} \
	    { sound(multifile) soundMultiFile OFF {Play Multiple}
"If your play command can handle multiple audio files,
then set this option.  In this case Exmh can run the
audio program in the background when it needs to
play multiple sounds."} \
	    [list sound(cmd) soundCmd $cmd {Play command} \
"The command line used to play audio files.  You may want
to add flags to control the volume, for example.  The
name of the audio file is appended to this command line."] \
	    [list sound(newMsg) soundNewMsg $new {Sound for a new message} \
"The name of an audio file to play when
new messages have arrived."] \
	    [list sound(error) soundError $err {Sound for an error} \
"The name of an audio file to play when
you forget to commit pending operations."] \
]
    }
}

proc Sedit_Init {} {
    global sedit

    set sedit(init) 1
    set sedit(height) 20
    set sedit(allids) {}

    if ![info exists sedit(key,sendMsg)] {
	set sedit(key,sendMsg) <Control-c><Control-c>
    }
    Preferences_Add "Simple Editor" \
"Exmh comes with a simple built in editor called \"sedit\".
It has about 20 keybindings for basic editing operations.
You can tune these bindings with the Bind dialog that defines
bindings for the Text and Entry widget classes."  {
    {sedit(pref,replPrefix) replPrefix "> " {Reply insert prefix}
"This string is prepended to lines included from the reply message
when you use the Insert @ command."}
    {sedit(formatDefault) seditFormatMail ON {Format Mail default}
"Sedit will format mail just before it gets sent out.  This includes
chopping long lines and expanding text/enriched directives.  You
can control whethor or not this happens with the Format Mail menu
item.  This Preference setting chooses the default for that item."}
    {sedit(mhnDefault) seditAttemptMhn OFF {Attempt mhn default}
"Sedit can send your message thru mhn in order to expand its #
MIME formating directives (see the man page about mhn for details).
You can control whethor or not this happens with the Attempt mhn menu
item.  This Preference setting chooses the default for that item."}
    {sedit(keepDefault) seditKeepOnSend OFF {Keep on send default}
"Sedit can save its window after you send a message.  This is useful
if you want to send variations on the same message to different addresses.
This Preference setting chooses the default for this option."}
    {sedit(quoteDefault) seditQuotedPrintable {CHOICE automatic always never} {Quoted-printable default}
"Sedit can encode text as quoted-printable to protect 8-bit characters.
Automatic means it will do this when you use the Compose key to
insert an 8-bit character.  Always means it always does it.
Never means it never does it.  You can also override this on
a per-message basis with the Quoted-Printable menu entry."}
    {sedit(lineLength)   seditLineLength 79 {Max Line Length}
"This is the length at which Format Mail chops lines.
It looks around for a word break when chopping."}
    {sedit(autoSign) seditAutoSign OFF {Automatically sign messages.}
"This will cause your .signature (or selected .signature* file) to
be automatically appended to your message when you Send it."}
    {sedit(sigfileDefault) seditSignatureFile "" {Default signature file}
"This is the name of the default signature file.  If set to something,
then this will be used as the default signature file in the Sign menu
for the built-in editor.  It is assumed to match the ~/.signature* pattern."}
    {sedit(colorize) seditColorize OFF {Colorize multiparts}
"For debugging, the multipart structure of a message can be highlighted
by coloring different type parts with different background colors."}
    {sedit(iso) seditISO ON {Specify Charset for Text}
"If enabled, this option adds character set information to
text content types, and promotes all messages to at least
MIME content-type text/plain."}
    {sedit(charset) seditCharset {CHOICE iso-8859-1 iso-8859-2 iso-8859-8} {8-bit character set}
"If you have enabled support for ISO character sets and enter
text that has the 8-th bit set, then
this is the character set used for text content types"}
    }
    global sedit
    # Fixup code for 1.5minus left-overs
    if {[string compare $sedit(charset) us-ascii] == 0} {
	set sedit(charset) iso-8859-1
    }
}
proc Sedit_CheckPoint {} {
    # Dummy routine overridden when/if sedit.tcl is auto-loaded
}

proc Pgp_Init {} {
    global pgp env

    if {[info exists pgp(path)] && \
	    [string length [string trim $pgp(path)]] && \
	    ([lsearch -exact [split $env(PATH) :] $pgp(path)] < 0)} {
	set env(PATH) $pgp(path):$env(PATH)
    }
    if {[string length [string trim $pgp(path)]] == 0} {
	set pgp(enabled) 0
    }
    if {![info exists env(LOCALHOST)]} {
	if [catch {exec uname -n} env(LOCALHOST)] {
	    set env(LOCALHOST) localhost
	}
    }

    Preferences_Add "PGP interface" \
"PGP is the Pretty Good Privacy package from Zimmerman.
PGP lets you sign and encrypt messages using public keys.
There is considerable documentation that comes with PGP itself." {
    {pgp(enabled)  pgpEnabled  ON {PGP enabled}
"Enable PGP processing during message display.  This includes
automatic signature verification and decryption.  If this is
not enabled, the message is viewed as text." }
    {pgp(keeppass)  pgpKeepPass  ON {Keep PGP password}
"Exmh tries to remember your PGP password between pgp
invocations. But the password is then kept in a global
variable, which is not safe, because of \"send\"'s power.
If you turn this feature off, the password will only be unsafe
while you type it in, just as is always the case because of
other X security holes." }
    {pgp(rfc822) pgpRfc822 OFF {Encrypt headers}
"Used to encrypt the whole message, instead of only encrypting
the body, so that the subject line (for instance) is also
safely transmitted." }
    {pgp(cacheids) pgpCacheIds ON {Cache map from email to public-key}
"The way exmh figures out the public-key to use for an email address is
often slow. This option allows you to cache the result of the matching
so that it doesn't have to be done over and over. Of course, if you
always send to different people, you won't notice any difference."}
    }

    set pgp(password) {}

    set pgp(action,none) {}
    set pgp(action,signclear) {-ast +clearsig=on}
    set pgp(action,signbinary) {-ast +clearsig=off}
    set pgp(action,encrypt) {-aet}
    set pgp(action,encryptsign) {-aest}

    set pgp(headerend) {^(--+.*--+)?$}
}


