proc Widget_FunnyMenuItem {mb l cmd {accel NONE}} {
    # Create a menu command entry with optional accelerator string.
    # The command is munged to make the entry promote itself to a button
    set cmd2 [list $m add command -label $l -command [list WidgetMenuToButton $mb $cmd]]
    if [catch $cmd2 t] {
	puts stderr "Widget_FunnyMenuItem (warning) $t"
	eval $cmd2 {-font fixed}
    }
    if {$accel != "NONE"} {
	$m entryconfigure $l -accelerator $accel
    }
}
proc WidgetMenuToButton { mb cmd } {
    # Warp a menu entry into a button

    # First, do the action
    eval $cmd
    # Search out a menu entry and make it into a button
    set frame [string range $mb 0 [expr [string last . $mb]-1]]
    set numItems [$mb.m index last]
    set hit 0
    for {set i 0} {$i < $numItems} {incr i} {
	foreach conf [$mb.m entryconfigure $i] {
	    # Depend on -command appearing before -label
	    if {[lindex $conf 0] == "-command" &&
		[string match *$cmd* [lindex $conf 4]]} {
		set hit 1
	    }
	    if {$hit && [lindex $conf 0] == "-label"} {
		if [catch {
		    global _PromoteSibling
		    set cmd2 [list button $frame.b$i -text [lindex $conf 4] -command $cmd]
		    if [catch $cmd2 t] {
			puts stderr "WidgetMenuToButton (warning) $t"
			eval $cmd2 {-font fixed}
		    }
		    if ![info exists _PromoteSibling] {
			set _PromoteSibling $mb
		    }
		    pack before $_PromoteSibling $frame.b$i {left fill}
		    set _PromoteSibling $frame.b$i
		} msg] {
		    if {! [string match {*already exists*} $msg]} {
			puts stderr "Promote: $msg"
		    }
		}
		return
	    }
	}
    }
}

