/*
 *	$Source: /home/nlfm/Working/Frink/RCS/tcl.c,v $
 *	$Date: 1995/02/23 13:07:22 $
 *	$Revision: 1.2.1.13 $
 *
 *------------------------------------------------------------------------
 *   AUTHOR:  Lindsay Marshall <lindsay.marshall@newcastle.ac.uk>
 *------------------------------------------------------------------------
 *    Copyright 1994 The University of Newcastle upon Tyne (see COPYRIGHT)
 *========================================================================
 *
 */

#include <malloc.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>

#include "frink.h"

static int inClass = 0;
static Token lbraceToken = {LBRACE, (char *) 0, 0, (Token *) 0, (Token *) 0};
static Token rbraceToken = {RBRACE, (char *) 0, 0, (Token *) 0, (Token *) 0};
static Token xcontToken = {XCONT, (char *) 0, 0, (Token *) 0, (Token *) 0};
static Token ostartToken = {OSTART, (char *) 0, 0, (Token *) 0, (Token *) 0};
static Token startToken = {START, (char *) 0, 0, (Token *) 0,(Token *) 0};
static Token contToken = {CONT, (char *) 0, 0, (Token *) 0, (Token *) 0};
static Token econtToken = {ECONT, (char *) 0, 0, (Token *) 0, (Token *) 0};
static Token emToken = {EM, (char *) 0, 0, (Token *) 0, (Token *) 0};
static Token enToken = {EN, (char *) 0, 0, (Token *) 0, (Token *) 0};
static Token *olsToken = &emToken;

static Token dqStart = {DQSTART, (char *) 0, 0, (Token *) 0, (Token *) 0};
static Token dqEnd = {DQEND, (char *) 0, 0, (Token *) 0, (Token *) 0};
static Token ifToken = {CONST, "if", 2, (Token *) 0, (Token *) 0};
static Token thenToken = {CONST, "then", 4, (Token *) 0, (Token *) 0};
static Token switchToken = {CONST, "switch", 6, (Token *) 0, (Token *) 0};
static Token procToken = {CONST, "proc", 4, (Token *) 0, (Token *) 0};
static Token elseToken = {CONST, "else", 4, (Token *) 0, (Token *) 0};
static Token elseifToken = {CONST, "elseif", 6, (Token *) 0, (Token *) 0};
static Token methodToken = {CONST, "method", 6, (Token *) 0, (Token *) 0};
static Token destToken = {CONST, "destructor", 10, (Token *) 0, (Token *) 0};
static Token consToken = {CONST, "constructor", 11, (Token *) 0, (Token *) 0};
static Token publicToken = {CONST, "public", 6, (Token *) 0, (Token *) 0};
static Token commonToken = {CONST, "common", 6, (Token *) 0, (Token *) 0};
static Token protToken = {CONST, "protected", 9, (Token *) 0, (Token *) 0};
static Token bindToken = {CONST, "bind", 4, (Token *) 0, (Token *) 0};
static Token classToken = {CONST, "itcl_class", 10, (Token *) 0, (Token *) 0};
static Token forToken = {CONST, "for", 3, (Token *) 0, (Token *) 0};
static Token foreachToken = {CONST, "foreach", 7, (Token *) 0, (Token *) 0};
static Token whileToken = {CONST, "while", 5, (Token *) 0, (Token *) 0};
static Token semiToken = {SEMI, ";", 1, (Token *) 0, (Token *) 0};

extern void setIndent();
extern void outdent();

static int tokEqual(Token *tp, char *val)
{
   return (tp != (Token *) 0 && tp->type == CONST && tp->text != (char *) 0 &&
	   strcmp(tp->text, val) == 0);
}

static int oneLine(Token *seq, int semis)
{
    while (seq != (Token *) 0)
    {
	if (seq->type == NL || (semis && seq->type == SEMI)) { return 0; }
	seq = seq->next;
    }
    return 1;
}

static int single(Token * tp)
{
    if (tp != (Token *) 0 && tp->next == (Token *) 0)
    {
	switch (tp->type)
	{
	case CONST :
	case CONC :
	case CALL :
	case VAR :
	    return 1;
	default :
	    return 0;
	}
    }
    return 0;
}

void body(Token *bod, int addBraces)
{
    Input *idx;
    Token *bl;
    int lnr;
    extern void sprocess(Token *, int);

    if (bod == (Token *) 0) { fail(bod, "Program is not correct tcl!"); }
    switch (bod->type)
    {
    case CONST :
	if (embrace)
	{
	    output(&lbraceToken, 1);
	    setIndent();
	    output((oneliner) ? olsToken : &startToken, 0);
	}
        output(bod , 1);
	if (embrace)
	{
	    outdent();
	    if (oneliner) { output(olsToken, 0); }
	    output(&rbraceToken, oneliner);
	}
	break;

    case VAR :
    case CONC :
	if (addBraces && embrace)
	{
	    output(&lbraceToken, 1);
	    setIndent();
	    output((oneliner) ? olsToken : &startToken, 0);
	}
        output(bod , 1);
	if (addBraces && embrace)
	{
	    outdent();
	    if (oneliner) { output(olsToken, 0); }
	    output(&rbraceToken, oneliner);
	}
	break;

    case LIST :
        idx = tokenise(bod->text, bod->length);
        bl = accumulate(idx, 1);
        untokenise(idx);
        if (debrace && bl != (Token *) 0 && bl->next == 0 && bl->type == CONST)
        {
            output(bl, 1);
        }
	else if (oneliner && oneLine(bl, 0))
	{
            output(&lbraceToken, 1);
	    setIndent();
	    output(olsToken, 0);
            lprocess(bl, 1);
            outdent();
	    output(olsToken, 0);
            output(&rbraceToken, 1);
	    
	}
	else
        {
            output(&lbraceToken, 0);
            setIndent();
            lprocess(bl, 1);
            outdent();
            output(&rbraceToken, 0);
        }
	break;

    case STRING :
	output(&dqStart, 1);
	setIndent();
	if ((lnr = oneliner && oneLine(bod->sequence, 1)))
	{
	    output(olsToken, 0);
	}
	sprocess(bod->sequence, 1);
	if (lnr) { output(olsToken, 0); }
	outdent();
	output(&dqEnd, 0);
	bod->sequence = (Token *) 0;
	break;

    case SLIST :
	output(bod, 0);
	break;

    case CALL :
        lprocess(bod->sequence, 0);
	bod->sequence = (Token *) 0;
	break;

    case SEMI:
    case NL:
	blank();
	break;

    default :
        fail(bod, "Block error");
    }
}

typedef enum flags_e { NOBRACE = 01, ADDBRACES = 02, SEMIS = 04 } PressFlags;

static void press(Token *v , PressFlags flags)
{
    Input *idx;
    Token *token, *lst = (Token *) 0;
    extern tokenPush(Token**, Token*);
    
    if (v == (Token *) 0) { fail(v, "Program is not correct tcl!"); }

    switch (v->type)
    {
    case SLIST:
	output(v, 1);
	break;
    case LIST :
        idx = tokenise(v->text, v->length);
        for(;;)
        {
            token = getToken(idx);
            switch (token->type)
	    {
            case ENDF :
		freeToken(token);
		goto done;
	    case NL :
	    case SEMI :
		if (flags & SEMIS)
		{
		    tokenPush(&lst, token);
		    break;
		}
            case COMMENT :
	    case SP :
		freeToken(token);
	    	break;
	    default :
                tokenPush(&lst, token);
            }
        }
done :
        untokenise(idx);
        if ((flags & NOBRACE) && debrace && single(lst))
        {
            output(lst, 1);
        }
	else
        {
            output(&lbraceToken, 1);
	    token = lst;
	    while (token != (Token *) 0)
	    {
		switch (token->type)
		{
		case SEMI :
		    if (flags && SEMIS)
		    {
			output(&semiToken, 1);
		    }
		    else
		    {
			output(&startToken, 1);
		    }
		    break;
		default :
		    output(token, 1);
		}
		token = token->next;
	    }
            output(&rbraceToken, 1);
        }
	break;

    case SEMI :
    case NL :
	if (flags & SEMIS) { output(&semiToken, 1); }
    	break;

    default :
	if (embrace && (flags & ADDBRACES)) { output(&lbraceToken, 1); }
        output(v , 1);
	if (embrace && (flags & ADDBRACES)) { output(&rbraceToken, 1); }
    }
}

void makeCall (Token *prc, Token *arg)
{
    int sol;
    output(&startToken, 0);
    if (tokEqual(prc, "}")) { warn(prc, "unmatched } found"); }
    output(prc, 1);
    if (xf)
    {
        while (arg != (Token *) 0)
        {
            if (arg->type == CONST && arg->text[0] == '-' &&
		arg->next != (Token *) 0)
            {
                output(&xcontToken, 1);
                output(arg, 1);
/*
  Be careful here - watch out for the case where -command is used as an
  access function rather than to set the command!!
*/
		if (strcmp(arg->text, "-command") == 0)
		{
		    arg = arg->next;
		    setIndent();
		    sol = oneliner;
		    oneliner = 1;
		    olsToken = &enToken;
		    body(arg, 0);
		    olsToken = &emToken;
		    oneliner = sol;
		    outdent();
		    continue;
		}
		arg = arg->next;
            }
	    output (arg, 1);
            arg = arg->next;
        }
    }
    else
    {
	while (arg != (Token *) 0)
	{
	    output(arg, 1);
            if (tokEqual(arg, "-command") && arg->next != (Token *) 0)
            {
		arg = arg->next;
		setIndent();
		sol = oneliner;
		oneliner = 1;
		olsToken = &enToken;
		body(arg, 0);
		olsToken = &emToken;
		oneliner = sol;
		outdent();
            }
	    arg = arg->next;
	}
    }
}

void doswitch(Token *cmd)
{
    Token *tp, *bod;
    Input *idx;
    output(&startToken, 0);
    output(&switchToken, 0 );
    tp = cmd;
    while (tp->type == CONST && tp->text[0] == '-')
    {
        output(tp , 1 );
        tp = tp->next;
    }
    output(tp, 1);
    tp = tp->next;
    if (tp->next != (Token *) 0)
    { /* this the non-list format */
	if (switchIn) { setIndent(); }
        while(tp != (Token *) 0)
        {
            output(&contToken, 1 );
            output(tp, 1);
	    tp = tp->next;
	    if (tokEqual(tp, "-"))
	    {
		output(tp, 1);
	    }
	    else
	    {
		setIndent();
		body(tp, 0);
		outdent();
	    }
            tp = tp->next;
        }
	if (switchIn) { outdent(); }
    }
    else
    {
        switch (tp->type)
	{
        case LIST :
            idx = tokenise(tp->text, tp->length);
            tp = bod = accumulate(idx , 0);
            untokenise(idx );
	    output(&lbraceToken, 0);
	    if (switchIn) { setIndent(); }
            while (tp != (Token *) 0)
            {
		if (tp->type == COMMENT) {
		    output(tp, 1 );
		}
		else
		{
                    output(&ostartToken, 1);
		    output(tp, 1 );
		    tp = tp->next;
		    if (tokEqual(tp, "-"))
		    {
			output(tp, 1);
		    }
		    else
		    {
		        setIndent();
		        body(tp, 1);
		        outdent();
		    }
		}
		tp = tp->next;
            }
	    if (switchIn) { outdent(); }
	    output(&rbraceToken, 0);
	    freeToken(bod);
            break;
        case STRING :
/*	    break; */
        default :
	    fail(tp, "switch error");
        }
    }
}

void doif (Token *cmd)
{
    Token *tp, *then;
    output(&startToken, 0 );
    output(&ifToken, 0 );
    press(cmd, NOBRACE | ADDBRACES);
    if (putThen) { output(&thenToken, 0); }
    then = cmd->next;
    if (tokEqual(then, "then")) { then = then->next; }
    if (then == (Token *) 0)
    {
	warn(then, " \"if\" with no then part");
	return;
    }
    body(then, 0);
    tp = then->next;
    while(tokEqual(tp, "elseif"))
    {
        output(&econtToken, 1);
        output(&elseifToken, 0);
        press(tp = tp->next, NOBRACE | ADDBRACES);
        body(tp = tp->next, 0);
        tp = tp->next;;
    }
    if (tokEqual(tp, "else"))
    {
        if (putElse)
        {
            output(&elseToken, 0 );
        }
        body(tp->next, 0);
    }
    else if (tp != (Token *) 0)
    {
        if (putElse)
        {
            output(&elseToken, 0 );
        }
        body(tp, 0);
    }
}

void doProc(Token *tag, Token *cmd)
{
    output(&startToken, 0);
    output(tag, 0);
    output(cmd, 1);
    press(cmd->next, NOBRACE | ADDBRACES);
    body(cmd->next->next, 0);
}

void doproc(Token *cmd) { doProc(&procToken, cmd); }

void domethod(Token *cmd) { doProc(&methodToken ,cmd); }

void dodestructor(Token *cmd)
{
    if (!inClass)
    {
        makeCall(&destToken, cmd);
    }
    else
    {
        output(&startToken, 0);
        output(&destToken , 0);
        body(cmd, 0);
    }
}

void doconstructor(Token *cmd)
{
    if (!inClass)
    {
        makeCall(&consToken, cmd);
    }
    else
    {
        output(&startToken, 0);
        output(&consToken, 0);
        press(cmd, NOBRACE | ADDBRACES);
        body(cmd->next, 0);
    }
}

void dobind(Token *cmd)
{
    Token *tp, *sp, *np;
    int sem;
    if (!dobind)
    {
        makeCall(&bindToken,cmd);
    }
    else
    {
        output(&startToken, 0);
        output(&bindToken, 0);
        output(cmd, 1);
        if ((np = cmd->next) != (Token *) 0)
        {
            output(np, 1);
            if ((tp = np->next) != (Token *) 0)
            {
		if (tp->type == LIST)
		{
		    if (tp->length == 0)
		    {
			output(tp, 1);
			return;
		    }
		}
		else if (tp->type == STRING)
		{
		    if ((sp = tp->sequence) != (Token *) 0)
		    {
			if (((sp->type == SPART && sp->length == 0) ||
			     sp->type == SP) && sp->next == (Token *) 0)
			{
			    output(tp, 1);
			    return;
			}
		    }
		    else
		    {
			output(tp, 1);
			return;
		    }
		}
		sem = embrace;
		embrace = 0;
                body(tp, 0);
		embrace = sem;
            }
        }
    }
}

void doitcl_class(Token *cmd)
{
    output(&startToken, 0);
    output(&classToken, 0);
    output(cmd, 1);
    inClass += 1;
    body(cmd->next, 0);
    inClass += -1;
}

void docvar(Token *cmd, Token *prt)
{
    if (!inClass)
    {
        makeCall(prt, cmd);
    }
    else
    {
        output(&startToken, 0);
	output(prt, 0);
        output(cmd, 1);
        if (cmd->next != (Token *) 0)
        {
            press(cmd->next, NOBRACE | ADDBRACES);
	}
    }
}

void dopublic(Token *cmd)
{
    if (!inClass)
    {
        makeCall(&publicToken, cmd);
    }
    else
    {
        output(&startToken, 0);
        output(&publicToken, 0);
        output(cmd, 1);
        if (cmd->next != (Token *) 0)
        {
            press(cmd->next, NOBRACE | ADDBRACES);
            if(cmd->next->next != (Token *) 0)
            {
                body(cmd->next->next, 0);
            }
        }
    }
}

void doprotected(Token *cmd) { docvar(cmd, &protToken); }

void docommon(Token *cmd) { docvar(cmd, &commonToken); }

void doforeach(Token *cmd)
{
    output(&startToken, 0);
    output(&foreachToken, 0 );
    output(cmd, 0);
    press(cmd->next, NOBRACE);
    body(cmd->next->next, 0);
}

void dofor(Token *cmd )
{
    output(&startToken, 0);
    output(&forToken, 0 );
    press(cmd, NOBRACE | ADDBRACES | SEMIS);
    press(cmd->next, ADDBRACES);
    press(cmd->next->next, NOBRACE | ADDBRACES | SEMIS);
    body(cmd->next->next->next, 0);
}

void dowhile(Token *cmd)
{
    output(&startToken, 0 );
    output(&whileToken, 0 );
    press(cmd, NOBRACE | ADDBRACES);
    body(cmd->next, 0);
}

static struct OpTable
{
    char *procName;
    void (*func)(Token *);
} opTable[] =
{
    {"bind", dobind},
    {"common", docommon},
    {"constructor", doconstructor},
    {"destructor", dodestructor},
    {"for", dofor},
    {"foreach", doforeach},
    {"if", doif},
    {"itcl_class", doitcl_class},
    {"method", domethod},
    {"proc", doproc},
    {"protected", doprotected},
    {"public", dopublic},
    {"switch", doswitch},
    {"while", dowhile},
    {(char *) 0, 0}
};

static int starter[26] = {
    -1, 0, 1, 3, -1, 4, -1, -1, 6, -1, -1, -1, 8,
    -1, -1, 9, -1, -1, 12, -1, -1, -1, 13, -1, -1, -1
};

int tclop(Token *hd, Token *line)
{
    struct OpTable *op = opTable;
    int indx;
    char ch = *hd->text;

    if (!islower(ch) || (indx = starter[(int) ch - 'a']) < 0)
    {
	return 0;
    }
    op = &opTable[indx];
    while (op->procName != (char *) 0)
    {
	switch (strcmp(op->procName, hd->text))
	{
	case 0:
	    {
		(*op->func)(line);
		return 1;
	    }
	case 1 :
	    return 0;
	}
	op++;
    }
    return 0;
}
