# jedit_bindings.tcl - bindings for command accelerators for jedit
# 
# Copyright 1992-1994 by Jay Sekora.  All rights reserved, except 
# that this file may be freely redistributed in whole or in part 
# for non-profit, noncommercial use.

######################################################################
# jedit:mkbindings - set keyboard shortcuts and special map additions
#   widgets and t are often the same, but needn't be - widgets could
#   also include entry widgets
######################################################################

proc jedit:mkbindings {widgets t} {
  global WORD_END
  # the following can't be redefined in ~/.tk/textbindings.tcl;
  # if you want to change them, do so in $HOME/.tk/jeditrc.tcl
  #
  foreach w $widgets {
    bind $w <Meta-Tab>		{jedit:cmd:toggle_dabbrev %W}
    bind $w <Meta-space>	{jedit:cmd:toggle_sabbrev %W}
    bind $w <Meta-minus>	{jedit:cmd:hyphen %W}
    bind $w <Meta-semicolon>	{jedit:cmd:dabbrev %W}
    catch {
      bind $w <Meta-quoteright>	{jedit:cmd:sabbrev %W}
    }
    catch {
      bind $w <Meta-apostrophe>	{jedit:cmd:sabbrev %W}
    }
    bind $w <Meta-bar>		{jedit:cmd:run_pipe %W}
    bind $w <Meta-exclam>	{jedit:cmd:run_command %W}
    bind $w <Meta-bracketleft>	"jedit:text_regsub %W {(^|\n)\[> \] } {\\1}"
    bind $w <Meta-bracketright>	"jedit:text_regsub %W {(^|\n)} {\\1  }"
    bind $w <Meta-a>		{jedit:cmd:select_all %W}
    bind $w <Meta-B>		{jedit:font:bold %W}
    bind $w <Meta-c>		{jedit:cmd:copy %W}
    bind $w <Meta-C>		{jedit:cmd:current_line %W}
    bind $w <Meta-f>		{jedit:cmd:find %W}
    bind $w <Meta-F>		"jedit:pipe $t {fmt}"
    bind $w <Meta-g>		{jedit:cmd:find_again %W}
    bind $w <Meta-G>		{j:global_pref_panel}
    bind $w <Meta-h>		{jedit:cmd:help %W}
    bind $w <Meta-i>		{jedit:cmd:insfile %W}
    bind $w <Meta-I>		{jedit:font:italic %W}
    bind $w <Meta-l>		{jedit:cmd:load %W}
    bind $w <Meta-L>		{jedit:cmd:go_to_line %W}
    bind $w <Meta-m>		{jedit:cmd:ask_mode  %W}
    bind $w <Meta-Key-M>	{jedit:font:typewriter %W}
    bind $w <Meta-n>		{jedit:cmd:new_window %W}
    bind $w <Meta-N>		{jedit:cmd:note %W}
    bind $w <Meta-p>		{jedit:cmd:print %W}
    bind $w <Meta-P>		{jedit:cmd:edit_prefs %W}
    bind $w <Meta-R>		{jedit:font:roman %W}
    bind $w <Meta-s>		{jedit:cmd:save %W}
    bind $w <Meta-S>		{jedit:cmd:saveas %W}
    bind $w <Meta-T>		{j:prompt_tcl}
    bind $w <Meta-U>		{j:prompt_unix}
    bind $w <Meta-v>		{jedit:cmd:paste %W}
    bind $w <Meta-V>		{jedit:cmd:xpaste %W}
    bind $w <Meta-x>		{jedit:cmd:cut %W}
    bind $w <Meta-X>		{jedit:font:bolditalic %W}
    bind $w <Meta-q>		{jedit:cmd:quit %W}
    bind $w <Meta-w>		{jedit:cmd:close %W}
    bind $w <Meta-z>		{jedit:cmd:undo %W}
    bind $w <Meta-Z>		{jedit:cmd:redo %W}
 }
  
  # set up bindings for word-end punctuation (for abbrevs):
  
  foreach key $WORD_END {
    foreach map {basic vi-insert emacs-normal edt-normal} {
      j:tkb:mkmap $w $map $map [format {
        {%s			jedit:self_insert_punct}
      } $key]
    }
  }
  
  # set up bindings for a few other special characters:
  
  foreach map {basic vi-insert emacs-normal edt-normal} {
    j:tkb:mkmap $w $map $map [format {
      {Tab			jedit:tabkey}
    } $key]
    j:tkb:mkmap $w $map $map [format {
      {space			jedit:spacebar}
    } $key]
    j:tkb:mkmap $w $map $map [format {
      {Return			jedit:returnkey}
    } $key]
  }
  
  # additional application-specific Emacs-style keyboard bindings:
  
  j:tkb:mkmap $w emacs-normal emacs-normal {
    {Control-s			jedit:cmd:find_forward}
    {Control-r			jedit:cmd:find_backward}
  }
  j:tkb:mkmap $w emacs-escape emacs-normal {
    {percent			jedit:cmd:find}
  }
  j:tkb:mkmap $w emacs-control-x emacs-normal {
    {Control-s			jedit:cmd:save}
    {Control-w			jedit:cmd:saveas}
    {Control-f			jedit:cmd:load}
    {Control-v			jedit:cmd:load}
    {Control-c			jedit:cmd:quit}
  }
  
  # additional application-specific vi-style keyboard bindings:
  
  j:tkb:mkmap $w vi-command vi-command {
    {slash			jedit:cmd:find_forward}
    {question			jedit:cmd:find_backward}
    {n				jedit:cmd:find_again}
  }
  
  # create a vi-Z map for the "ZZ" command:
  
  j:tkb:mkmap $w vi-command vi-command {
    {Z				j:tkb:new_mode vi-Z}
  }
  
  j:tkb:mkmap $w vi-Z vi-command {
    {DEFAULT			j:tb:no_op}
    {Shift-DEFAULT		j:tb:no_op}
    {Control-DEFAULT		j:tb:no_op}
    {Meta-DEFAULT		j:tb:no_op}
    {Z				jedit:cmd:done}
  }
}
