# mh-mode.tcl - mode for composing mail in MH
######################################################################

proc mode:mh:init { t } {
  global JEDIT_MODEPREFS
  
  j:read_prefs -array JEDIT_MODEPREFS -prefix mh \
    -directory ~/.tk/jeditmodes -file mh-defaults {
    {textfont default}
    {textwidth 80}
    {textheight 24}
    {textwrap char}
    {sabbrev 0}
    {dabbrev 0}
    {autobreak 1}
    {autoindent 0}
    {savestate 0}
    {buttonbar 1}
    {menu,editor 1}
    {menu,file 1}
    {menu,edit 1}
    {menu,prefs 0}
    {menu,abbrev 1}
    {menu,filter 1}
    {menu,format 0}
    {menu,display 0}
    {menu,mode1 1}
    {menu,mode2 1}
    {menu,user 1}
  }
  
  # catch {$t tag configure header -background LemonChiffon}
  $t tag configure header -relief flat		;# just to create it
  $t tag lower header
  catch {$t tag configure sig -font {-*-courier-bold-r-normal--10-100-*}}
  $t tag lower sig
  
  # problematical: gets in the way of dabbrevs
  #
  bind $t <Double-Tab> "mode:mh:to_body $t"
  bind $t <Tab> "mode:mh:next_header $t"
}

######################################################################
# special hooks:

proc mode:mh:post_read_hook { filename t } {
  set separator {}
  if [regexp -indices "\n-*\n" [$t get 0.0 end] separator] {
    set headerend [lindex $separator 0]
    $t tag add header 0.0 "0.0 + $headerend chars + 1 char"
  }
}

######################################################################
# more procedures:

proc mode:mh:border { t } {
  j:text:insert_string $t \
    "     * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\n"
}

# delete the signature if it exists (and is tagged so):

proc mode:mh:delete_sig { t } {
  catch {
    $t delete sig.first end
  }
}

proc mode:mh:insert_sig { t } {
  global env
  mode:mh:delete_sig $t
  set curr [$t index end]
  $t insert end "\n"
  $t insert end [exec cat $env(HOME)/.signature]
  $t insert end "\n"
  $t tag add sig $curr end
}

proc mode:mh:start_reply { t } {
  set reply [exec cat "@" | sed {1,/^$/d} | \
    sed {s/^>/  /} | sed {s/^/  /}]
  $t insert end $reply
}

proc mode:mh:whom { t } {
  jedit:cmd:save $t
  set filename [jedit:get_filename $t]
  j:more -height 10 -width 60 -title "Recipients" \
    -text [exec whom -check $filename]
}

proc mode:mh:to_body { t } {
  $t mark set insert end
  $t yview -pickplace insert
}

# BUG - doesn't handle multi-line headers.

proc mode:mh:next_header { t } {
  if [$t compare header.last <= insert] {
    $t mark set insert 1.0
  }
  
  set headpart [$t get insert header.last]
  
  set regex [format {(^|%s)[A-Za-z-]*:[ %s]*} "\n" "\t"]
  if [regexp -indices -- $regex $headpart indices] {
    $t tag remove sel 1.0 end
    set valuestart [expr [lindex $indices 1] + 1]
    $t mark set hdrfrom "insert + $valuestart chars"
    $t tag add sel hdrfrom {hdrfrom lineend}
    $t mark set insert {hdrfrom lineend}
    $t yview -pickplace insert
  } else {
    # assume we're in the last header field, so jump to body
    mode:mh:to_body $t
  }
}

######################################################################
# define the MH menu:
######################################################################

proc mode:mh:mkmenu1 { menu t } {
  menubutton $menu -text {MH} -menu $menu.m
  
  menu $menu.m
  $menu.m add command -label {Start Reply} \
    -accelerator {[2]} -command "
    mode:mh:start_reply $t
  "
  $menu.m add command -label {Sign Email} -command "
    mode:mh:insert_sig $t
  "
  $menu.m add command -label {List Recipients} \
    -accelerator {[7]} -command "
    mode:mh:whom $t
  "
  $menu.m add command -label {Insert Border} \
    -accelerator {[8]} -command "
    mode:mh:border $t
  "
  $menu.m add command -label {Done} -command "
    jedit:cmd:done $t
  "
  
  bind $t <Meta-Key-2> "mode:mh:start_reply $t"
  bind $t <Meta-Key-7> "mode:mh:whom $t"
  bind $t <Meta-Key-8> "mode:mh:border $t"
}
######################################################################
# define the button bar:
######################################################################

proc mode:mh:mkbuttons { w t } {
  j:buttonbar $w -pady 2 -buttons [format {
    {done Done {jedit:cmd:done %s}}
    {border {* * *} {mode:mh:border %s}}
    {whom Whom {mode:mh:whom %s}}
    {sign Sign {mode:mh:insert_sig %s}}
    {reply {@} {mode:mh:start_reply %s}}
  } $t $t $t $t $t]
  return $w
}

