# jinit.tcl - common application initialisation procedures
# 
# Copyright 1992-1994 by Jay Sekora.  All rights reserved, except 
# that this file may be freely redistributed in whole or in part 
# for non-profit, noncommercial use.
######################################################################

### TO DO
###   more configurability

######################################################################
# global variables:
#
global J_PREFS env
if {! [info exists J_PREFS(autoposition)]} {set J_PREFS(autoposition) 0}
if {! [info exists J_PREFS(confirm)]} {set J_PREFS(confirm) 1}
#
######################################################################


######################################################################
# j:jstools_init - common initialisation for jstools
######################################################################

proc j:jstools_init {} {
  global J_PREFS			;# user preferences
  
  catch {tk colormodel . color}		;# colour even on a 2-bit display
  
  global tk_library
  global env
  
  global NAME; set NAME $env(USER)
  global HOME; set HOME $env(HOME)
  
  j:wm_client				;# set client hostname
  j:wm_command				;# set client command string
  
  # read in standard jstools preferences:
  
  j:read_global_prefs
  
  # following use users prefs, bindings files:
  j:tb:init Text			;# uses prefs, ~/.tk/textbindings.tcl
  j:eb:init Entry			;# uses prefs, ~/.tk/entrybindings.tcl
}
