# jlatin1.tcl - table of Compose-key sequences for iso8859-1 encoding
# 
# Copyright 1994 by Jay Sekora.  All rights reserved, except 
# that this file may be freely redistributed in whole or in part 
# for nonprofit, noncommercial use.
######################################################################

# this is used by jtextkeys.tcl, jbindentry.tcl, and jcompose.tcl

######################################################################
# TO DO:
#   generalise to other character sets
#   Add sequences for ASCII chars for people who might not have them 
#   on their keyboards (e.g. $, [, ], etc.).
######################################################################

# NOTE:  In the list of keysym, character, components, the two-character
#   components MUST be in collating order, because the keys the user 
#   types are sorted by the procs in jcompose.tcl (so `or' will work, 
#   but `ro' won't).

proc j:compose_init:iso8859-1 {} {
  global j_cmp
  
  foreach triple {
    {nobreakspace "\xa0" {  }}
    {exclamdown {} {!!}}
    {cent {} {/c}}
      {cent {} {c|}}
    {sterling {} {-L}}
      {sterling {} {=L}}
      {sterling {} {LL}}
      {sterling {} {##}}
    {currency {} {ox}}
      {currency {} {$$}}
    {yen {} {=Y}}
      {yen {} {-Y}}
    {brokenbar {} {||}}
    {section {} {OS}}
      {section {} {So}}
      {section {} {os}}
    {diaeresis {} {""}}
    {copyright {} {co}}
      {copyright {} {Oc}}
      {copyright {} {CO}}
    {ordfeminine {} {-a}}
      {ordfeminine {} {_a}}
    {guillemotleft {} {<<}}
    {notsign {} {-|}}
      {notsign {} {,-}}
    {hyphen {} {--}}
    {registered {} {or}}
      {registered {} {Or}}
      {registered {} {OR}}
    {macron {} {-^}}
      {macron {} {^_}}
      {macron {} {__}}
    {degree {} {oo}}
      {degree {} {0^}}
      {degree {} {00}}
    {plusminus {} {+-}}
      {plusminus {} {+_}}
    {twosuperior {} {2^}}
      {twosuperior {} {22}}
    {threesuperior {} {3^}}
      {threesuperior {} {33}}
    {acute {} {''}}
      {acute {} {\\}}
    {mu {} {/u}}
      {mu {} {u|}}
      {mu {} {mu}}
    {paragraph {} {PP}}
    {periodcentered {} {..}}
      {periodcentered {} {*+}}
      {periodcentered {} {+o}}
      {periodcentered {} {*.}}
    {cedilla {} {,,}}
    {onesuperior {} {1^}}
      {onesuperior {} {11}}
    {masculine {} {-o}}
      {masculine {} {_o}}
    {guillemotright {} {>>}}
    {onequarter {} {14}}
    {onehalf {} {12}}
    {threequarters {} {34}}
    {questiondown {} {??}}
    {Agrave {} {A`}}
    {Aacute {} {'A}}
    {Acircumflex {} {A^}}
    {Atilde {} {A~}}
    {Adiaeresis {} {"A}}
    {Aring {} {Ao}}
      {Aring {} {AO}}
      {Aring {} {*A}}
      {Aring {} {AA}}
    {AE {} {AE}}
    {Ccedilla {} {,C}}
      {Ccedilla {} {CC}}
    {Egrave {} {E`}}
    {Eacute {} {'E}}
    {Ecircumflex {} {E^}}
    {Ediaeresis {} {"E}}
    {Igrave {} {I`}}
    {Iacute {} {'I}}
    {Icircumflex {} {I^}}
    {Idiaeresis {} {"I}}
    {ETH {} {DH}}
      {ETH {} {Dh}}
      {ETH {} {DD}}
      {ETH {} {-D}}
      {ETH {} {/D}}
      {ETH {} {'D}}
    {Ntilde {} {N~}}
      {Ntilde {} {NN}}
    {Ograve {} {O`}}
    {Oacute {} {'O}}
    {Ocircumflex {} {O^}}
    {Otilde {} {O~}}
    {Odiaeresis {} {"O}}
    {multiply {} {xx}}
      {multiply {} {**}}
    {Ooblique {} {/O}}
    {Ugrave {} {U`}}
    {Uacute {} {'U}}
    {Ucircumflex {} {U^}}
    {Udiaeresis {} {"U}}
    {Yacute {} {'Y}}
    {THORN {} {HT}}
      {THORN {} {Th}}
      {THORN {} {TT}}
      {THORN {} {Tt}}
      {THORN {} {BP}}
      {THORN {} {Pb}}
    {ssharp {} {ss}}
      {ssharp {} {SS}}
    {agrave {} {`a}}
    {aacute {} {'a}}
    {acircumflex {} {^a}}
    {atilde {} {a~}}
    {adiaeresis {} {"a}}
    {aring {} {ao}}
      {aring {} {*a}}
      {aring {} {aa}}
    {ae {} {ae}}
    {ccedilla {} {,c}}
      {ccedilla {} {cc}}
    {egrave {} {`e}}
    {eacute {} {'e}}
    {ecircumflex {} {^e}}
    {ediaeresis {} {"e}}
    {igrave {} {`i}}
    {iacute {} {'i}}
    {icircumflex {} {^i}}
    {idiaeresis {} {"i}}
    {eth {} {dh}}
      {eth {} {dd}}
      {eth {} {/d}}
      {eth {} {-d}}
      {eth {} {'d}}
    {ntilde {} {n~}}
      {ntilde {} {nn}}
    {ograve {} {`o}}
    {oacute {} {'o}}
    {ocircumflex {} {^o}}
    {otilde {} {o~}}
    {odiaeresis {} {"o}}
    {division {} {-:}}
      {division {} {//}}
    {oslash {} {/o}}
    {ugrave {} {`u}}
    {uacute {} {'u}}
    {ucircumflex {} {^u}}
    {udiaeresis {} {"u}}
    {yacute {} {'y}}
    {thorn {} {ht}}
      {thorn {} {bp}}
      {thorn {} {tt}}
    {ydiaeresis {} {"y}}
  } {
    set keysym [lindex $triple 0]
    set glyph [lindex $triple 1]
    set pair [lindex $triple 2]
    set j_cmp(iso8859-1,glyph,$pair) $glyph
    set j_cmp(iso8859-1,keysym,$pair) $keysym
    
    # signal to programs that the latin1 definitions have been loaded:
    set j_cmp(iso8859-1) 1
  }
}
